/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.core;

import java.util.Objects;
import org.kingdoms.server.core.ServerContainer;
import org.kingdoms.server.events.EventHandler;
import org.kingdoms.server.location.WorldRegistry;

public interface Server {
    public static void init(Server instance) {
        ServerContainer.INSTANCE = instance;
    }

    public static Server get() {
        return Objects.requireNonNull(ServerContainer.INSTANCE, "Server instance not initiated yet");
    }

    public EventHandler getEventHandler();

    public int getTicks();

    public boolean isMainThread();

    public WorldRegistry getWorldRegistry();

    public boolean isReady();

    default public void onStartup() {
    }

    default public void onReady() {
    }

    default public void onEnable() {
    }
}

