/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.scheduler;

import java.time.Duration;
import java.util.concurrent.Executor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.kingdoms.dependencies.classpath.BootstrapProvider;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.PluginState;
import org.kingdoms.scheduler.AbstractDelayedRepeatingTask;
import org.kingdoms.scheduler.AbstractDelayedTask;
import org.kingdoms.scheduler.AbstractJavaScheduler;
import org.kingdoms.scheduler.AbstractTask;
import org.kingdoms.scheduler.DelayedRepeatingTask;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.scheduler.Task;
import org.kingdoms.scheduler.TaskScheduler;
import org.kingdoms.scheduler.TracedRunnable;
import org.kingdoms.utils.time.internal.TickTemporalUnit;

public class BukkitSchedulerAdapter
extends AbstractJavaScheduler {
    private final Executor sync;
    private final BukkitScheduler bukkitScheduler;
    private final Plugin plugin;
    private final BukkitTaskScheduler taskScheduler;

    public BukkitSchedulerAdapter(Kingdoms loader, BootstrapProvider bootstrapProvider) {
        super(bootstrapProvider);
        this.plugin = loader;
        this.bukkitScheduler = loader.getServer().getScheduler();
        this.sync = task -> {
            PluginState state = Kingdoms.get().getState();
            if (state == PluginState.DISABLING || state == PluginState.DISABLED) {
                return;
            }
            loader.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)loader.getLoader(), (Runnable)new TracedRunnable(task));
        };
        this.taskScheduler = new BukkitTaskScheduler();
    }

    @Override
    public TaskScheduler sync() {
        return this.taskScheduler;
    }

    private final class BukkitTaskScheduler
    implements TaskScheduler {
        private BukkitTaskScheduler() {
        }

        @Override
        @NotNull
        public Task.ExecutionContextType getExecutionContextType() {
            return Task.ExecutionContextType.SYNC;
        }

        @Override
        @NotNull
        public Executor getExecutor() {
            return BukkitSchedulerAdapter.this.sync;
        }

        @Override
        @NotNull
        public Task execute(@NotNull Runnable runnable) {
            BukkitSchedulerAdapter.this.sync.execute(runnable);
            return new AbstractTask(this.getExecutionContextType(), runnable);
        }

        @Override
        @NotNull
        public DelayedTask delayed(@NotNull Duration delay, @NotNull Runnable runnable) {
            int taskId = BukkitSchedulerAdapter.this.bukkitScheduler.scheduleSyncDelayedTask(BukkitSchedulerAdapter.this.plugin, (Runnable)new TracedRunnable(runnable), TickTemporalUnit.toTicks(delay));
            return new BukkitDelayedTask(runnable, delay, this.getExecutionContextType(), taskId, BukkitSchedulerAdapter.this.bukkitScheduler);
        }

        @Override
        @NotNull
        public DelayedRepeatingTask repeating(@NotNull Duration initialDelay, @NotNull Duration intervalDelays, @NotNull Runnable runnable) {
            int taskId = BukkitSchedulerAdapter.this.bukkitScheduler.scheduleSyncRepeatingTask(BukkitSchedulerAdapter.this.plugin, (Runnable)new TracedRunnable(runnable), TickTemporalUnit.toTicks(initialDelay), TickTemporalUnit.toTicks(intervalDelays));
            return new BukkitDelayedRepeatingTask(runnable, initialDelay, intervalDelays, this.getExecutionContextType(), taskId, BukkitSchedulerAdapter.this.bukkitScheduler);
        }
    }

    private static final class BukkitDelayedRepeatingTask
    extends AbstractDelayedRepeatingTask {
        private final int taskId;
        private final BukkitScheduler bukkitScheduler;

        private BukkitDelayedRepeatingTask(Runnable runnable, Duration initialDelay, Duration intervalDelays, Task.ExecutionContextType executionContextType, int taskId, BukkitScheduler bukkitScheduler) {
            super(runnable, initialDelay, intervalDelays, executionContextType);
            this.taskId = taskId;
            this.bukkitScheduler = bukkitScheduler;
        }

        @Override
        public boolean cancel() {
            this.bukkitScheduler.cancelTask(this.taskId);
            return super.cancel();
        }
    }

    private static final class BukkitDelayedTask
    extends AbstractDelayedTask {
        private final int taskId;
        private final BukkitScheduler bukkitScheduler;

        private BukkitDelayedTask(Runnable runnable, Duration delay, Task.ExecutionContextType executionContextType, int taskId, BukkitScheduler bukkitScheduler) {
            super(runnable, delay, executionContextType);
            this.taskId = taskId;
            this.bukkitScheduler = bukkitScheduler;
        }

        @Override
        public boolean cancel() {
            this.bukkitScheduler.cancelTask(this.taskId);
            return super.cancel();
        }
    }
}

