/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.scheduler;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.kingdoms.dependencies.classpath.BootstrapProvider;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.scheduler.AbstractDelayedRepeatingTask;
import org.kingdoms.scheduler.AbstractDelayedTask;
import org.kingdoms.scheduler.AbstractTask;
import org.kingdoms.scheduler.DelayedRepeatingTask;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.scheduler.Task;
import org.kingdoms.scheduler.TaskScheduleProvider;
import org.kingdoms.scheduler.TaskScheduler;
import org.kingdoms.scheduler.TracedRunnable;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.internal.stacktrace.StackTraces;

public abstract class AbstractJavaScheduler
implements TaskScheduleProvider {
    private static final int PARALLELISM = 16;
    private static final String PREFIX = "kingdoms";
    private static final String THREAD_SUFFIX_SCHEDULER = "-scheduler";
    private static final String THREAD_SUFFIX_WORKER = "-worker-";
    private final BootstrapProvider bootstrap;
    private final ScheduledThreadPoolExecutor scheduler;
    private final ForkJoinPool worker;
    private final AsyncExecutor asyncTaskScheduler;
    private boolean shutdown;

    public AbstractJavaScheduler(BootstrapProvider bootstrap) {
        this.bootstrap = bootstrap;
        this.scheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("kingdoms-scheduler");
            return thread;
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.worker = new ForkJoinPool(16, new WorkerThreadFactory(), new ExceptionHandler(), false);
        this.asyncTaskScheduler = new AsyncExecutor();
    }

    @Override
    public TaskScheduler async() {
        return this.asyncTaskScheduler;
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    @MustBeInvokedByOverriders
    public void shutdown() {
        if (this.shutdown) {
            throw new IllegalStateException(this + " is already shutdown");
        }
        this.shutdown = true;
        this.shutdownScheduler();
        this.shutdownExecutor();
    }

    private void shutdownScheduler() {
        this.shutdownService(this.scheduler, THREAD_SUFFIX_SCHEDULER, "scheduler");
    }

    private void shutdownExecutor() {
        this.shutdownService(this.worker, THREAD_SUFFIX_WORKER, "worker thread pool");
    }

    private void shutdownService(ExecutorService service, String threadSuffix, String serviceDescription) {
        service.shutdown();
        try {
            if (!service.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.bootstrap.getLogger().severe("Timed out waiting for the " + serviceDescription + " to terminate");
                this.reportRunningTasks(thread -> thread.getName().startsWith(PREFIX + threadSuffix));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void reportRunningTasks(Predicate<Thread> predicate) {
        Thread.getAllStackTraces().forEach((thread, stack) -> {
            if (predicate.test((Thread)thread)) {
                this.bootstrap.getLogger().log(Level.WARNING, "Thread " + thread.getName() + " is blocked, and may be the reason for the slow shutdown!\n" + Arrays.stream(stack).map(el -> "  " + el).collect(Collectors.joining("\n")));
            }
        });
    }

    private static final class WorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private static final AtomicInteger COUNT = new AtomicInteger(0);

        private WorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread.setDaemon(true);
            thread.setName("kingdoms-worker-" + COUNT.getAndIncrement());
            StackTraces.linkThreads(Thread.currentThread(), thread);
            return thread;
        }
    }

    private final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            try {
                AbstractJavaScheduler.this.bootstrap.getLogger().log(Level.WARNING, "Thread " + t.getName() + " threw an uncaught exception", e);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private final class AsyncExecutor
    implements TaskScheduler {
        private AsyncExecutor() {
        }

        @Override
        @NotNull
        public Task.ExecutionContextType getExecutionContextType() {
            return Task.ExecutionContextType.ASYNC;
        }

        @Override
        @NotNull
        public Executor getExecutor() {
            return AbstractJavaScheduler.this.worker;
        }

        @Override
        @NotNull
        public Task execute(@NotNull Runnable runnable) {
            AbstractJavaScheduler.this.worker.execute(new TracedRunnable(runnable));
            return new AbstractTask(this.getExecutionContextType(), runnable);
        }

        @Override
        @NotNull
        public DelayedTask delayed(@NotNull Duration delay, @NotNull Runnable runnable) {
            TracedRunnable traced = new TracedRunnable(runnable);
            ScheduledFuture<?> future = AbstractJavaScheduler.this.scheduler.schedule(() -> AbstractJavaScheduler.this.worker.execute(traced), delay.toMillis(), TimeUnit.MILLISECONDS);
            return new AsyncDelayedTask(runnable, delay, this.getExecutionContextType(), future);
        }

        @Override
        @NotNull
        public DelayedRepeatingTask repeating(@NotNull Duration initialDelay, @NotNull Duration intervalDelays, @NotNull Runnable runnable) {
            TracedRunnable traced = new TracedRunnable(runnable);
            ScheduledFuture<?> future = AbstractJavaScheduler.this.scheduler.scheduleAtFixedRate(() -> AbstractJavaScheduler.this.worker.execute(traced), initialDelay.toMillis(), intervalDelays.toMillis(), TimeUnit.MILLISECONDS);
            return new AsyncRepeatingTask(runnable, initialDelay, intervalDelays, this.getExecutionContextType(), future);
        }
    }

    private static final class TracedThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final StackTraceElement[] creationStackTrace = new Throwable().getStackTrace();

        private TracedThreadExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            try {
                e.setStackTrace(ArrayUtils.merge(this.creationStackTrace, e.getStackTrace()));
                Kingdoms.get().getLogger().log(Level.WARNING, "Thread " + t.getName() + " threw an uncaught exception", e);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private static final class AsyncRepeatingTask
    extends AbstractDelayedRepeatingTask {
        private final ScheduledFuture<?> future;

        public AsyncRepeatingTask(@NotNull Runnable runnable, @NotNull Duration initialDelay, @NotNull Duration intervalDelays, @NotNull Task.ExecutionContextType executionContextType, ScheduledFuture<?> future) {
            super(runnable, initialDelay, intervalDelays, executionContextType);
            this.future = future;
        }

        @Override
        public boolean cancel() {
            this.future.cancel(true);
            return super.cancel();
        }
    }

    private static final class AsyncDelayedTask
    extends AbstractDelayedTask {
        private final ScheduledFuture<?> future;

        public AsyncDelayedTask(@NotNull Runnable runnable, @NotNull Duration delay, @NotNull Task.ExecutionContextType executionContextType, ScheduledFuture<?> future) {
            super(runnable, delay, executionContextType);
            this.future = future;
        }

        @Override
        public boolean cancel() {
            this.future.cancel(true);
            return super.cancel();
        }
    }
}

