/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.platform.bukkit.item;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.libs.xseries.reflection.ReflectiveNamespace;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftMapping;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;

public final class ItemNBT {
    public static final boolean CAN_ACCESS_UNBREAKABLE;
    public static final boolean SUPPORTS_COMPONENTS;
    public static final MethodHandle AS_NMS_COPY;
    public static final MethodHandle AS_BUKKIT_COPY;
    public static final MethodHandle SET_TAG;
    public static final MethodHandle CUSTOM_DATA_CTOR;
    public static final MethodHandle GET_TAG;
    public static final MethodHandle COPY_TAG;
    public static final Object CUSTOM_DATA_TYPE;

    private ItemNBT() {
    }

    private static Object asNMSCopy(ItemStack item) {
        try {
            return AS_NMS_COPY.invoke(item);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static ItemStack asBukkitCopy(Object nmsItem) {
        try {
            return AS_BUKKIT_COPY.invoke(nmsItem);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static ItemStack setTag(ItemStack item, NBTTagCompound tag) {
        Object nbtTag = BukkitAdapter.adapt(tag);
        Object nmsItem = Objects.requireNonNull(ItemNBT.asNMSCopy(item), () -> "NMS copy is null for " + item);
        try {
            if (SUPPORTS_COMPONENTS) {
                Object customData = CUSTOM_DATA_CTOR.invoke(nbtTag);
                SET_TAG.invoke(nmsItem, CUSTOM_DATA_TYPE, customData);
            } else {
                SET_TAG.invoke(nmsItem, nbtTag);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return ItemNBT.asBukkitCopy(nmsItem);
    }

    public static NBTTagCompound getTag(ItemStack item) {
        Objects.requireNonNull(item, "Cannot get tag of null item");
        Object nmsItem = ItemNBT.asNMSCopy(item);
        if (nmsItem == null) {
            return NBTTagCompound.empty();
        }
        Object tag = null;
        try {
            if (SUPPORTS_COMPONENTS) {
                tag = GET_TAG.invoke(nmsItem, CUSTOM_DATA_TYPE);
                if (tag != null) {
                    tag = COPY_TAG.invoke(tag);
                }
            } else {
                tag = GET_TAG.invoke(nmsItem);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        if (tag == null) {
            return NBTTagCompound.empty();
        }
        return BukkitAdapter.adapt(NBTTagType.COMPOUND, tag);
    }

    static {
        MethodHandle getTag;
        MethodHandle setTag;
        CAN_ACCESS_UNBREAKABLE = XReflection.supports((int)11);
        MethodHandle asNmsCopy = null;
        MethodHandle asBukkitCopy = null;
        MethodHandle customDataCtor = null;
        MethodHandle copyTag = null;
        Object customDataType = null;
        boolean supportsComponents = false;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ReflectiveNamespace ns = XReflection.namespaced();
        Class crafItemStack = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "inventory").named(new String[]{"CraftItemStack"}).unreflect();
        Class nmsItemStack = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.item").named(new String[]{"ItemStack"}).unreflect();
        Class CompoundTagClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "nbt").map(MinecraftMapping.MOJANG, "CompoundTag").map(MinecraftMapping.SPIGOT, "NBTTagCompound").unreflect();
        try {
            asNmsCopy = lookup.findStatic(crafItemStack, "asNMSCopy", MethodType.methodType(nmsItemStack, ItemStack.class));
            asBukkitCopy = lookup.findStatic(crafItemStack, "asBukkitCopy", MethodType.methodType(ItemStack.class, nmsItemStack));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            Class DataComponentsClass = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core.component").named(new String[]{"DataComponents"}).reflect();
            Class DataComponentHolderClass = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core.component").named(new String[]{"DataComponentHolder"}).reflect();
            Class DataComponentTypeClass = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core.component").named(new String[]{"DataComponentType"}).reflect();
            Class CustomDataClass = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.item.component").named(new String[]{"CustomData"}).reflect();
            setTag = XReflection.of((Class)nmsItemStack).method().map(MinecraftMapping.MOJANG, "set").map(MinecraftMapping.OBFUSCATED, "b").returns(Object.class).parameters(new Class[]{DataComponentTypeClass, Object.class}).reflect();
            getTag = XReflection.of((Class)nmsItemStack).method().map(MinecraftMapping.MOJANG, "get").map(MinecraftMapping.OBFUSCATED, "a").returns(Object.class).parameters(new Class[]{DataComponentTypeClass}).reflect();
            copyTag = XReflection.of((Class)CustomDataClass).method().map(MinecraftMapping.MOJANG, "copyTag").map(MinecraftMapping.OBFUSCATED, (String)XReflection.v((int)21, (int)4, (Object)"d").orElse((Object)"c")).returns(CompoundTagClass).reflect();
            Constructor customDataCtorJvm = CustomDataClass.getDeclaredConstructor(CompoundTagClass);
            customDataCtorJvm.setAccessible(true);
            customDataCtor = lookup.unreflectConstructor(customDataCtorJvm);
            customDataType = XReflection.of((Class)DataComponentsClass).field().asStatic().getter().returns(DataComponentTypeClass).map(MinecraftMapping.MOJANG, "CUSTOM_DATA").map(MinecraftMapping.OBFUSCATED, "b").reflect().invoke();
            supportsComponents = true;
        }
        catch (Throwable ex) {
            try {
                setTag = lookup.findVirtual(nmsItemStack, (String)XReflection.v((int)18, (Object)"c").orElse((Object)"setTag"), MethodType.methodType(Void.TYPE, CompoundTagClass));
                getTag = lookup.findVirtual(nmsItemStack, (String)XReflection.v((int)19, (Object)"v").v(18, (Object)"t").orElse((Object)"getTag"), MethodType.methodType(CompoundTagClass));
            }
            catch (IllegalAccessException | NoSuchMethodException ex2) {
                RuntimeException newEx = new RuntimeException(ex2);
                newEx.addSuppressed(ex);
                throw newEx;
            }
        }
        AS_NMS_COPY = asNmsCopy;
        AS_BUKKIT_COPY = asBukkitCopy;
        SET_TAG = setTag;
        GET_TAG = getTag;
        COPY_TAG = copyTag;
        CUSTOM_DATA_TYPE = customDataType;
        CUSTOM_DATA_CTOR = customDataCtor;
        SUPPORTS_COMPONENTS = supportsComponents;
    }
}

