/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.platform.bukkit.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.awt.Color;
import java.lang.invoke.MethodHandle;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftConnection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftMapping;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.platform.bukkit.channel.BlockMarker;
import org.kingdoms.platform.bukkit.channel.BlockMarkerPluginChannel;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.internal.jdk.RecordAccessor;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.internal.reflection.Reflect;

public final class PluginChannels {
    private static final Color INVISIBLE_MARKER = new Color(0, 0, 0, 0);
    private static final Duration REMOVE_MARKER_DURATION = Duration.ofSeconds(1L);
    private static final int INVISIBLE_MARKER_ARGB = PluginChannels.encodeARGB(INVISIBLE_MARKER);
    private static final MethodHandle MINECRAFTKEY;
    protected static final Map<UUID, Set<BlockMarkerPluginChannel>> MARKERS;
    private static final MethodHandle SEND_CUSTOM_PAYLOAD;
    private static final boolean SUPPORTED;

    private static int encodeARGB(Color color) {
        return (0xFF & color.getAlpha()) << 24 | (0xFF & color.getRed()) << 16 | (0xFF & color.getGreen()) << 8 | 0xFF & color.getBlue();
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    private static void ensureSupported() {
        if (!PluginChannels.isSupported()) {
            throw new UnsupportedOperationException("Plugin channels are not supported in this version");
        }
    }

    public static void clearBlockMarkers(@NotNull Player player) {
        PluginChannels.ensureSupported();
        PluginChannels.sendPayload(player, DefaultChannel.DEBUG$GAME_TEST_CLEAR.getMinecraftKey(), Unpooled.EMPTY_BUFFER);
    }

    public static void clearBlockMarkers(@NotNull Player player, @NotNull Collection<BlockMarkerPluginChannel> markers) {
        PluginChannels.ensureSupported();
        Set<BlockMarkerPluginChannel> handles = MARKERS.get(player.getUniqueId());
        ArrayList<Object> packets = new ArrayList<Object>(markers.stream().mapToInt(x -> x.getMarkers().size()).sum());
        for (BlockMarkerPluginChannel marker : markers) {
            if (!(handles != null && handles.isEmpty() || handles.remove(marker))) {
                return;
            }
            for (Map.Entry<BlockVector3, BlockMarker> block : marker.getMarkers().entrySet()) {
                BlockVector3 loc = block.getKey();
                Object packet = RecordAccessor.createCustomPayload(loc.getX(), loc.getY(), loc.getZ(), INVISIBLE_MARKER_ARGB, "", REMOVE_MARKER_DURATION);
                packets.add(packet);
            }
        }
        if (handles != null && handles.isEmpty()) {
            MARKERS.remove(player.getUniqueId());
        }
        MinecraftConnection.sendPacket((Player)player, (Object[])packets.toArray());
    }

    public static void sendBlockMarker(@NotNull Player player, Collection<BlockVector3> blocks, BlockMarker marker) {
        HashMap<BlockVector3, BlockMarker> markers = new HashMap<BlockVector3, BlockMarker>(blocks.size());
        for (BlockVector3 block : blocks) {
            markers.put(block, marker);
        }
        BlockMarkerPluginChannel channel = new BlockMarkerPluginChannel(markers);
        PluginChannels.sendBlockMarker(player, Collections.singleton(channel));
    }

    public static void sendBlockMarker(@NotNull Player player, Collection<BlockMarkerPluginChannel> markers) {
        PluginChannels.ensureSupported();
        ArrayList<Object> packets = new ArrayList<Object>(markers.stream().mapToInt(x -> x.getMarkers().size()).sum());
        Set handles = MARKERS.computeIfAbsent(player.getUniqueId(), k -> Collections.newSetFromMap(new IdentityHashMap()));
        for (BlockMarkerPluginChannel marker : markers) {
            handles.add(marker);
            for (Map.Entry<BlockVector3, BlockMarker> block : marker.getMarkers().entrySet()) {
                BlockVector3 loc = block.getKey();
                BlockMarker props = block.getValue();
                Object packet = RecordAccessor.createCustomPayload(loc.getX(), loc.getY(), loc.getZ(), PluginChannels.encodeARGB(props.color), props.title, props.duration);
                packets.add(packet);
            }
        }
        MinecraftConnection.sendPacket((Player)player, (Object[])packets.toArray());
    }

    private static long toBlockPositionBit(int x, int y, int z) {
        return ((long)x & 0x3FFFFFFL) << 38 | (long)y & 0xFFFL | ((long)z & 0x3FFFFFFL) << 12;
    }

    private static void wrap(ByteBuf packet, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            packet.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        packet.writeByte(i);
    }

    private static void writeString(@NotNull ByteBuf packet, @NotNull String string) {
        byte[] byteArray = string.getBytes(StandardCharsets.UTF_8);
        PluginChannels.wrap(packet, byteArray.length);
        packet.writeBytes(byteArray);
    }

    private static void sendPayload(@NotNull Player receiver, MinecraftKey channel, ByteBuf bytes) {
        Objects.requireNonNull(receiver, "receiver");
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(bytes, "bytes");
        PluginChannels.ensureSupported();
        try {
            byte[] arr = new byte[bytes.readableBytes()];
            bytes.readBytes(arr);
            SEND_CUSTOM_PAYLOAD.invoke(receiver, channel, arr);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MARKERS = NonNullMap.of(new ConcurrentHashMap());
        MINECRAFTKEY = Reflect.classExists("net.minecraft.resources.MinecraftKey") || Reflect.classExists("net.minecraft.resources.ResourceLocation") ? (MethodHandle)XReflection.namespaced().imports("MinecraftKey", MinecraftKey.class).of(MinecraftKey.class).method("public static MinecraftKey fromNamespaceAndPath(String namespace, String key);").map(MinecraftMapping.OBFUSCATED, "a").reflectOrNull() : null;
        SEND_CUSTOM_PAYLOAD = null;
        SUPPORTED = MINECRAFTKEY != null && XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.common.custom").named(new String[]{"GameTestAddMarkerDebugPayload"}).exists();
    }

    public static enum DefaultChannel {
        DEBUG$GAME_TEST_ADD_MARKER,
        DEBUG$GAME_TEST_CLEAR;

        private final MinecraftKey minecraftKey;

        private DefaultChannel() {
            try {
                this.minecraftKey = MINECRAFTKEY.invoke("minecraft", this.name().replace('$', '/').toLowerCase(Locale.ENGLISH));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        public MinecraftKey getMinecraftKey() {
            return this.minecraftKey;
        }
    }
}

