/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.permissions;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.permissions.Permission;
import org.kingdoms.server.permission.PermissionDefaultValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/kingdoms/permissions/BukkitPermission;", "Lorg/kingdoms/permissions/Permission;", "systematicObject", "Lorg/bukkit/permissions/Permission;", "<init>", "(Lorg/bukkit/permissions/Permission;)V", "getSystematicObject", "()Lorg/bukkit/permissions/Permission;", "namespace", "", "getNamespace", "()Ljava/lang/String;", "name", "", "getName", "()[Ljava/lang/String;", "defaultValue", "Lorg/kingdoms/server/permission/PermissionDefaultValue;", "getDefaultValue", "()Lorg/kingdoms/server/permission/PermissionDefaultValue;", "description", "Lorg/kingdoms/locale/messenger/Messenger;", "getDescription", "()Lorg/kingdoms/locale/messenger/Messenger;", "split", "", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBukkitPermission.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BukkitPermission.kt\norg/kingdoms/permissions/BukkitPermission\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,34:1\n37#2:35\n36#2,3:36\n*S KotlinDebug\n*F\n+ 1 BukkitPermission.kt\norg/kingdoms/permissions/BukkitPermission\n*L\n12#1:35\n12#1:36,3\n*E\n"})
public final class BukkitPermission
implements Permission {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final org.bukkit.permissions.Permission systematicObject;
    @NotNull
    private final List<String> split;
    @JvmField
    @NotNull
    public static final BiMap<PermissionDefaultValue, PermissionDefault> DEFAULT_VALUE_MAPPING;

    public BukkitPermission(@NotNull org.bukkit.permissions.Permission systematicObject) {
        Intrinsics.checkNotNullParameter((Object)systematicObject, (String)"systematicObject");
        this.systematicObject = systematicObject;
        String string = this.systematicObject.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{"."};
        this.split = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public final org.bukkit.permissions.Permission getSystematicObject() {
        return this.systematicObject;
    }

    @Override
    @NotNull
    public String getNamespace() {
        return (String)CollectionsKt.first(this.split);
    }

    @Override
    @NotNull
    public String[] getName() {
        Collection $this$toTypedArray$iv = CollectionsKt.drop((Iterable)this.split, (int)1);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public PermissionDefaultValue getDefaultValue() {
        Object object = DEFAULT_VALUE_MAPPING.inverse().get((Object)this.systematicObject.getDefault());
        Intrinsics.checkNotNull((Object)object);
        return (PermissionDefaultValue)((Object)object);
    }

    @Override
    @NotNull
    public Messenger getDescription() {
        return new StaticMessenger(this.systematicObject.getDescription());
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("BukkitPermission(permission=").append(this.systematicObject).append(", namespace='").append(this.getNamespace()).append("', name=");
        String string = Arrays.toString(this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).append(", defaultValue=").append((Object)this.getDefaultValue()).append(", description=").append(this.getDescription()).append(", split=").append(this.split).append(')').toString();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)PermissionDefaultValue.EVERYONE), (Object)PermissionDefault.TRUE), TuplesKt.to((Object)((Object)PermissionDefaultValue.NO_ONE), (Object)PermissionDefault.FALSE), TuplesKt.to((Object)((Object)PermissionDefaultValue.NOT_OP), (Object)PermissionDefault.NOT_OP), TuplesKt.to((Object)((Object)PermissionDefaultValue.OP), (Object)PermissionDefault.OP)};
        EnumBiMap enumBiMap = EnumBiMap.create((Map)MapsKt.hashMapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)enumBiMap, (String)"create(...)");
        DEFAULT_VALUE_MAPPING = (BiMap)enumBiMap;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kingdoms/permissions/BukkitPermission$Companion;", "", "<init>", "()V", "DEFAULT_VALUE_MAPPING", "Lcom/google/common/collect/BiMap;", "Lorg/kingdoms/server/permission/PermissionDefaultValue;", "Lorg/bukkit/permissions/PermissionDefault;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

