/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.OptionalInt;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.internal.SurroundingNBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagType;

public final class NBTTagLongArray
extends NBTTag<long[]> {
    private long[] value;

    @NotNull
    public static NBTTagLongArray of(long ... value) {
        return new NBTTagLongArray((long[])value.clone());
    }

    private NBTTagLongArray(long[] value) {
        this.value = value;
    }

    @Override
    @NotNull
    public NBTTagType<NBTTagLongArray> type() {
        return NBTTagType.LONG_ARRAY;
    }

    @Override
    public long[] value() {
        return (long[])this.value.clone();
    }

    @Override
    public void setValue(long[] value) {
        this.value = value;
    }

    @NotNull
    public LongBuffer view() {
        return LongBuffer.wrap(this.value).asReadOnlyBuffer();
    }

    @Override
    @NotNull
    public NBTStream stream() {
        return new SurroundingNBTStream(new NBTToken.LongArrayStart(OptionalInt.of(this.value.length)), new NBTStream(){
            private static final int BUFFER_SIZE = 4096;
            private int i = 0;

            @Override
            @Nullable
            public NBTToken nextOrNull() {
                if (this.i >= NBTTagLongArray.this.value.length) {
                    return null;
                }
                int length = Math.min(4096, NBTTagLongArray.this.value.length - this.i);
                LongBuffer buffer = LongBuffer.wrap(NBTTagLongArray.this.value, this.i, length).asReadOnlyBuffer();
                this.i += length;
                return new NBTToken.LongArrayContent(buffer);
            }
        }, new NBTToken.LongArrayEnd());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTTagLongArray that = (NBTTagLongArray)o;
        return Arrays.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.value());
    }
}

