/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.tag;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Optional;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.stream.NBTBinaryIO;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.NBTStreamable;
import org.kingdoms.nbt.stream.internal.SurroundingNBTStream;
import org.kingdoms.nbt.stream.token.NBTToken;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagReader;
import org.kingdoms.nbt.tag.ToNBTTag;

public final class NBTRootEntry
implements ToNBTTag<NBTTagCompound>,
NBTStreamable {
    private final String name;
    private final NBTTagCompound value;

    public NBTRootEntry(String name, NBTTagCompound value) {
        this.name = name;
        this.value = value;
    }

    public NBTTagCompound getValue() {
        return this.value;
    }

    public static NBTRootEntry readFrom(@NotNull NBTStream tokens) throws IOException {
        return NBTTagReader.readRoot(tokens);
    }

    public byte[] writeToArray() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(output);){
            NBTBinaryIO.write(dataOutputStream, this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return output.toByteArray();
    }

    @Override
    @NotNull
    public NBTTagCompound toNBTTag() {
        HashMap<String, NBTTagCompound> map = new HashMap<String, NBTTagCompound>();
        map.put(this.name, this.value);
        return NBTTagCompound.of(map);
    }

    @Override
    @NotNull
    public NBTStream stream() {
        return new SurroundingNBTStream(new NBTToken.Name(this.name, Optional.of(NBTTagId.COMPOUND)), this.value.stream(), null);
    }
}

