/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.stream.internal;

import java.io.IOException;
import java.util.Iterator;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.NBTStreamable;
import org.kingdoms.nbt.stream.token.NBTToken;

public class FlatteningNBTStream
implements NBTStream {
    private final Iterator<? extends NBTStreamable> streamables;
    private NBTStream current;

    public FlatteningNBTStream(Iterator<? extends NBTStreamable> streamables) {
        this.streamables = streamables;
    }

    @Override
    @Nullable
    public NBTToken nextOrNull() throws IOException {
        NBTToken token;
        while (true) {
            if (this.current == null) {
                if (!this.streamables.hasNext()) {
                    return null;
                }
                this.current = this.streamables.next().stream();
            }
            if ((token = this.current.nextOrNull()) != null) break;
            this.current = null;
        }
        return token;
    }
}

