/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.stream.impl;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import java.util.OptionalInt;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.exception.NBTParseException;
import org.kingdoms.nbt.stream.impl.ValueCounter;
import org.kingdoms.nbt.stream.token.NBTToken;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0007\u0010\u0011\u0012\u0013\u0014\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\t\u001a\u00020\u0001H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator;", "Lorg/kingdoms/nbt/stream/NBTStream;", "original", "<init>", "(Lorg/kingdoms/nbt/stream/NBTStream;)V", "tokenBuffer", "Ljava/util/Deque;", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "nextOrNull", "calculateOptionalInfo", "fillIfNeeded", "Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$TokenAndBuffer;", "token", "getFilled", "fill", "Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$OptionalFill;", "OptionalFill", "TokenAndBuffer", "ListStartFill", "ByteArrayStartFill", "IntArrayStartFill", "LongArrayStartFill", "NameFill", "nbt"})
public final class OptionalInfoCalculator
implements NBTStream {
    @NotNull
    private final NBTStream original;
    @Nullable
    private Deque<NBTToken> tokenBuffer;

    public OptionalInfoCalculator(@NotNull NBTStream original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.original = original;
    }

    @Override
    @Nullable
    public NBTToken nextOrNull() throws IOException {
        NBTToken next;
        if (this.tokenBuffer != null) {
            Deque<NBTToken> deque = this.tokenBuffer;
            Intrinsics.checkNotNull(deque);
            next = deque.pollFirst();
            if (next != null) {
                return next;
            }
            this.tokenBuffer = null;
        }
        NBTToken nBTToken = this.original.nextOrNull();
        if (nBTToken == null) {
            return null;
        }
        next = nBTToken;
        TokenAndBuffer tokenAndBuffer = this.fillIfNeeded(next);
        if (tokenAndBuffer.getBuffer() != null && !tokenAndBuffer.getBuffer().isEmpty()) {
            this.tokenBuffer = tokenAndBuffer.getBuffer();
        }
        return tokenAndBuffer.getToken();
    }

    @Override
    @NotNull
    public NBTStream calculateOptionalInfo() {
        return this;
    }

    private final TokenAndBuffer fillIfNeeded(NBTToken token) throws IOException {
        if (token instanceof NBTToken.ListStart && (((NBTToken.ListStart)token).getSize().isEmpty() || ((NBTToken.ListStart)token).getElementId().isEmpty())) {
            return this.getFilled(new ListStartFill((NBTToken.ListStart)token));
        }
        if (token instanceof NBTToken.ByteArrayStart) {
            if (((NBTToken.ByteArrayStart)token).getSize().isPresent()) {
                return new TokenAndBuffer(token, null);
            }
            return this.getFilled(new ByteArrayStartFill());
        }
        if (token instanceof NBTToken.IntArrayStart) {
            if (((NBTToken.IntArrayStart)token).getSize().isPresent()) {
                return new TokenAndBuffer(token, null);
            }
            return this.getFilled(new IntArrayStartFill());
        }
        if (token instanceof NBTToken.LongArrayStart && ((NBTToken.LongArrayStart)token).getSize().isEmpty()) {
            return this.getFilled(new LongArrayStartFill());
        }
        if (token instanceof NBTToken.Name && ((NBTToken.Name)token).getId().isEmpty()) {
            return this.getFilled(new NameFill(((NBTToken.Name)token).getName()));
        }
        return new TokenAndBuffer(token, null);
    }

    private final TokenAndBuffer getFilled(OptionalFill fill) throws IOException {
        NBTToken filled;
        ArrayDeque<NBTToken> buffer = new ArrayDeque<NBTToken>();
        ArrayDeque<NBTToken> consumedTokenStack = new ArrayDeque<NBTToken>();
        while (true) {
            NBTToken next;
            if ((next = (NBTToken)buffer.pollFirst()) == null) {
                NBTToken originalNext;
                if (this.original.nextOrNull() == null) {
                    throw new NBTParseException("Optional value not filled by the end of token stream");
                }
                TokenAndBuffer tokenAndBuffer = this.fillIfNeeded(originalNext);
                buffer.add(tokenAndBuffer.getToken());
                consumedTokenStack.add(tokenAndBuffer.getToken());
                if (tokenAndBuffer.getBuffer() == null) continue;
                buffer.addAll((Collection)tokenAndBuffer.getBuffer());
                consumedTokenStack.addAll((Collection)tokenAndBuffer.getBuffer());
                continue;
            }
            filled = fill.tryFill(next);
            if (filled != null) break;
        }
        return new TokenAndBuffer(filled, (Deque<NBTToken>)consumedTokenStack);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$ByteArrayStartFill;", "Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$OptionalFill;", "<init>", "()V", "size", "", "tryFill", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "token", "nbt"})
    private static final class ByteArrayStartFill
    implements OptionalFill {
        private int size;

        @Override
        @Nullable
        public NBTToken tryFill(@NotNull NBTToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            if (token instanceof NBTToken.ByteArrayEnd) {
                OptionalInt optionalInt = OptionalInt.of(this.size);
                Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                return new NBTToken.ByteArrayStart(optionalInt);
            }
            if (token instanceof NBTToken.ByteArrayContent) {
                this.size += ((NBTToken.ByteArrayContent)token).getBuffer().remaining();
            } else {
                throw new NBTParseException("Unexpected token: " + token);
            }
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$IntArrayStartFill;", "Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$OptionalFill;", "<init>", "()V", "size", "", "tryFill", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "token", "nbt"})
    private static final class IntArrayStartFill
    implements OptionalFill {
        private int size;

        @Override
        @Nullable
        public NBTToken tryFill(@NotNull NBTToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            if (token instanceof NBTToken.IntArrayEnd) {
                OptionalInt optionalInt = OptionalInt.of(this.size);
                Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                return new NBTToken.IntArrayStart(optionalInt);
            }
            if (token instanceof NBTToken.IntArrayContent) {
                this.size += ((NBTToken.IntArrayContent)token).getBuffer().remaining();
            } else {
                throw new NBTParseException("Unexpected token: " + token);
            }
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$ListStartFill;", "Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$OptionalFill;", "listStart", "Lorg/kingdoms/nbt/stream/token/NBTToken$ListStart;", "<init>", "(Lorg/kingdoms/nbt/stream/token/NBTToken$ListStart;)V", "knownSize", "", "counter", "Lorg/kingdoms/nbt/stream/impl/ValueCounter;", "elementId", "Lorg/kingdoms/nbt/NBTTagId;", "tryFill", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "token", "nbt"})
    private static final class ListStartFill
    implements OptionalFill {
        private int knownSize;
        @Nullable
        private final ValueCounter counter;
        @Nullable
        private NBTTagId elementId;

        public ListStartFill(@NotNull NBTToken.ListStart listStart) {
            Intrinsics.checkNotNullParameter((Object)listStart, (String)"listStart");
            if (listStart.getSize().isPresent()) {
                this.knownSize = listStart.getSize().getAsInt();
                this.counter = null;
            } else {
                this.knownSize = -1;
                this.counter = new ValueCounter();
            }
            this.elementId = listStart.getElementId().orElse(null);
        }

        @Override
        @Nullable
        public NBTToken tryFill(@NotNull NBTToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            if (this.counter == null || !this.counter.isNested()) {
                NBTTagId elementId = this.elementId;
                if (elementId == null) {
                    if (token instanceof NBTToken.ListEnd) {
                        elementId = NBTTagId.END;
                    } else {
                        NBTTagId nBTTagId = token.getTagId();
                        if (nBTTagId == null) {
                            throw new NBTParseException("Token doesn't represent a tag directly: " + token);
                        }
                        elementId = nBTTagId;
                    }
                    this.elementId = elementId;
                }
                if (this.counter == null) {
                    OptionalInt optionalInt = OptionalInt.of(this.knownSize);
                    Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                    NBTTagId nBTTagId = elementId;
                    Intrinsics.checkNotNull((Object)((Object)nBTTagId));
                    Optional<NBTTagId> optional = Optional.of(nBTTagId);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    return new NBTToken.ListStart(optionalInt, optional);
                }
                if (token instanceof NBTToken.ListEnd) {
                    OptionalInt optionalInt = OptionalInt.of(this.counter.count());
                    Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                    NBTTagId nBTTagId = elementId;
                    Intrinsics.checkNotNull((Object)((Object)nBTTagId));
                    Optional<NBTTagId> optional = Optional.of(nBTTagId);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    return new NBTToken.ListStart(optionalInt, optional);
                }
            }
            this.counter.add(token);
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$LongArrayStartFill;", "Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$OptionalFill;", "<init>", "()V", "size", "", "tryFill", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "token", "nbt"})
    private static final class LongArrayStartFill
    implements OptionalFill {
        private int size;

        @Override
        @Nullable
        public NBTToken tryFill(@NotNull NBTToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            if (token instanceof NBTToken.LongArrayEnd) {
                OptionalInt optionalInt = OptionalInt.of(this.size);
                Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"of(...)");
                return new NBTToken.LongArrayStart(optionalInt);
            }
            if (token instanceof NBTToken.LongArrayContent) {
                this.size += ((NBTToken.LongArrayContent)token).getBuffer().remaining();
            } else {
                throw new NBTParseException("Unexpected token: " + token);
            }
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$NameFill;", "Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$OptionalFill;", "name", "", "<init>", "(Ljava/lang/String;)V", "tryFill", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "token", "nbt"})
    private static final class NameFill
    implements OptionalFill {
        @NotNull
        private final String name;

        public NameFill(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Override
        @NotNull
        public NBTToken tryFill(@NotNull NBTToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            NBTTagId nBTTagId = token.getTagId();
            if (nBTTagId == null) {
                throw new NBTParseException("Token doesn't represent a tag directly: " + token);
            }
            Optional<NBTTagId> optional = Optional.of(nBTTagId);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return new NBTToken.Name(this.name, optional);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$OptionalFill;", "", "tryFill", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "token", "nbt"})
    private static interface OptionalFill {
        @Nullable
        public NBTToken tryFill(@NotNull NBTToken var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/kingdoms/nbt/stream/impl/OptionalInfoCalculator$TokenAndBuffer;", "", "token", "Lorg/kingdoms/nbt/stream/token/NBTToken;", "buffer", "Ljava/util/Deque;", "<init>", "(Lorg/kingdoms/nbt/stream/token/NBTToken;Ljava/util/Deque;)V", "getToken", "()Lorg/kingdoms/nbt/stream/token/NBTToken;", "getBuffer", "()Ljava/util/Deque;", "nbt"})
    private static final class TokenAndBuffer {
        @NotNull
        private final NBTToken token;
        @Nullable
        private final Deque<NBTToken> buffer;

        public TokenAndBuffer(@NotNull NBTToken token, @Nullable Deque<NBTToken> buffer) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.token = token;
            this.buffer = buffer;
        }

        @NotNull
        public final NBTToken getToken() {
            return this.token;
        }

        @Nullable
        public final Deque<NBTToken> getBuffer() {
            return this.buffer;
        }
    }
}

