/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.snbt.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.internal.AbstractIterator;
import org.kingdoms.nbt.snbt.Elusion;
import org.kingdoms.nbt.snbt.reader.SNBTToken;
import org.kingdoms.nbt.snbt.reader.SNBTTokenWithMetadata;
import org.kingdoms.nbt.stream.exception.NBTParseException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u0010\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/nbt/snbt/reader/SNBTTokenizer;", "Lorg/kingdoms/nbt/internal/AbstractIterator;", "Lorg/kingdoms/nbt/snbt/reader/SNBTTokenWithMetadata;", "input", "Ljava/io/Reader;", "<init>", "(Ljava/io/Reader;)V", "charIndex", "", "eatAllWhitespaceAfter", "", "errorPrefix", "", "skipWhitespace", "", "computeNext", "readSimpleValue", "readQuotedText", "quoteChar", "", "nbt"})
public final class SNBTTokenizer
extends AbstractIterator<SNBTTokenWithMetadata> {
    @NotNull
    private final Reader input;
    private int charIndex;
    private final boolean eatAllWhitespaceAfter;

    public SNBTTokenizer(@NotNull Reader input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input.markSupported() ? input : (Reader)new BufferedReader(input);
        this.charIndex = -1;
    }

    private final String errorPrefix() {
        return "At character index " + this.charIndex + ": ";
    }

    private final void skipWhitespace() throws IOException {
        block1: {
            int n;
            int next;
            do {
                this.input.mark(1);
                next = this.input.read();
                if (next == -1) break block1;
                n = this.charIndex;
                this.charIndex = n + 1;
            } while (Character.isWhitespace(next));
            this.input.reset();
            n = this.charIndex;
            this.charIndex = n + -1;
        }
    }

    @Override
    @Nullable
    protected SNBTTokenWithMetadata computeNext() {
        try {
            SNBTTokenWithMetadata sNBTTokenWithMetadata;
            this.skipWhitespace();
            this.input.mark(1);
            int next = this.input.read();
            if (next == -1) {
                return (SNBTTokenWithMetadata)this.end();
            }
            int n = this.charIndex;
            this.charIndex = n + 1;
            switch ((char)next) {
                case '{': {
                    sNBTTokenWithMetadata = new SNBTTokenWithMetadata(SNBTToken.CompoundStart.INSTANCE, this.charIndex);
                    break;
                }
                case '}': {
                    sNBTTokenWithMetadata = new SNBTTokenWithMetadata(SNBTToken.CompoundEnd.INSTANCE, this.charIndex);
                    break;
                }
                case '[': {
                    sNBTTokenWithMetadata = new SNBTTokenWithMetadata(SNBTToken.ListLikeStart.INSTANCE, this.charIndex);
                    break;
                }
                case ']': {
                    sNBTTokenWithMetadata = new SNBTTokenWithMetadata(SNBTToken.ListLikeEnd.INSTANCE, this.charIndex);
                    break;
                }
                case ':': {
                    sNBTTokenWithMetadata = new SNBTTokenWithMetadata(SNBTToken.EntrySeparator.INSTANCE, this.charIndex);
                    break;
                }
                case ';': {
                    sNBTTokenWithMetadata = new SNBTTokenWithMetadata(SNBTToken.ListTypeSeparator.INSTANCE, this.charIndex);
                    break;
                }
                case ',': {
                    sNBTTokenWithMetadata = new SNBTTokenWithMetadata(SNBTToken.Separator.INSTANCE, this.charIndex);
                    break;
                }
                case '\"': 
                case '\'': {
                    int initialCharIndex = this.charIndex;
                    sNBTTokenWithMetadata = new SNBTTokenWithMetadata(new SNBTToken.Text(true, this.readQuotedText((char)next)), initialCharIndex);
                    break;
                }
                default: {
                    this.input.reset();
                    int n2 = this.charIndex;
                    this.charIndex = n2 + -1;
                    sNBTTokenWithMetadata = this.readSimpleValue();
                }
            }
            return sNBTTokenWithMetadata;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final SNBTTokenWithMetadata readSimpleValue() throws IOException {
        int initialCharIndex = this.charIndex + 1;
        StringBuilder builder = new StringBuilder();
        boolean wasWhitespace = false;
        while (true) {
            this.input.mark(1);
            int next = this.input.read();
            if (next == -1) break;
            int n = this.charIndex;
            this.charIndex = n + 1;
            if (next == 44 || next == 58 || next == 59 || next == 125 || next == 93) {
                this.input.reset();
                n = this.charIndex;
                this.charIndex = n + -1;
                break;
            }
            if (Character.isWhitespace(next)) {
                wasWhitespace = true;
                continue;
            }
            if (!Elusion.isSafeCharacter((char)next)) {
                throw new NBTParseException(this.errorPrefix() + "Unexpected character: " + (char)next);
            }
            if (wasWhitespace) {
                throw new NBTParseException(this.errorPrefix() + "Found non-terminator after whitespace");
            }
            builder.append((char)next);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new SNBTTokenWithMetadata(new SNBTToken.Text(false, string), initialCharIndex);
    }

    private final String readQuotedText(char quoteChar) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        while (true) {
            int c;
            if ((c = this.input.read()) == -1) {
                throw new NBTParseException(this.errorPrefix() + "Unexpected end of input in quoted value");
            }
            int n = this.charIndex;
            this.charIndex = n + 1;
            if (!escaped) {
                if (c == quoteChar) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    return string;
                }
                if (c == 92) {
                    escaped = true;
                    continue;
                }
            } else {
                if (c != quoteChar && c != 92) {
                    throw new NBTParseException(this.errorPrefix() + "Invalid escape: \\" + (char)c);
                }
                escaped = false;
            }
            sb.append((char)c);
        }
    }
}

