/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.nbt.snbt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.nbt.IOFunction;
import org.kingdoms.nbt.snbt.SNBTWriter;
import org.kingdoms.nbt.snbt.reader.SNBTReader;
import org.kingdoms.nbt.snbt.reader.SNBTTokenizer;
import org.kingdoms.nbt.stream.NBTStream;
import org.kingdoms.nbt.stream.NBTStreamable;
import org.kingdoms.nbt.tag.NBTTag;

public final class NBTStringIO {
    @NotNull
    public static NBTStream read(@NotNull Reader input) {
        return new SNBTReader(new SNBTTokenizer(input));
    }

    @NotNull
    public static NBTStream readFromString(@NotNull String input) {
        return NBTStringIO.read(new StringReader(input));
    }

    public static <R> R readUsing(@NotNull Reader input, @NotNull IOFunction<? super NBTStream, R> transform) throws IOException {
        return transform.apply(NBTStringIO.read(input));
    }

    public static <R> R readFromStringUsing(@NotNull String input, @NotNull IOFunction<? super NBTStream, R> transform) {
        try {
            return transform.apply(NBTStringIO.readFromString(input));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(@NotNull Appendable output, @NotNull NBTStreamable tokens) throws IOException {
        new SNBTWriter().write(output, tokens.stream());
    }

    public static String toString(NBTTag<?> tag) {
        return NBTStringIO.writeToString(tag);
    }

    public static String writeToString(@NotNull NBTStreamable tokens) {
        StringBuilder builder = new StringBuilder();
        try {
            NBTStringIO.write(builder, tokens);
        }
        catch (IOException e) {
            throw new AssertionError("No I/O to perform, so shouldn't throw an I/O exception", e);
        }
        return builder.toString();
    }

    private NBTStringIO() {
    }
}

