/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.teleportation;

import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.teleportation.TeleportTask;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.hash.EntityHashMap;
import org.kingdoms.utils.hash.EntityWeakHashMap;

public final class TpManager
implements Listener {
    private static final EntityWeakHashMap<Player, TeleportTask> TELEPORTING = EntityHashMap.weakBuilder(Player.class).build();

    public static void put(Player player, BukkitTask task) {
        TpManager.put(new TeleportTask(player, task));
    }

    public static void put(TeleportTask task) {
        TeleportTask previous = TELEPORTING.put(task.player, task);
        if (previous != null) {
            previous.task.cancel();
        }
    }

    public static boolean end(Player entity2) {
        TeleportTask task = TELEPORTING.remove(entity2);
        if (task != null) {
            task.task.cancel();
        }
        return task != null;
    }

    public static void cancelAll(Collection<Player> entities) {
        for (Player entity2 : entities) {
            TpManager.end(entity2);
        }
    }

    public static boolean isTeleporting(Player entity2) {
        return TELEPORTING.containsKey(entity2);
    }

    public static boolean alreadyTping(Player player) {
        if (TpManager.isTeleporting(player)) {
            KingdomsLang.TELEPORTS_ALREADY_TELEPORTING.sendError((CommandSender)player, new Object[0]);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        TELEPORTING.remove(event.getPlayer());
    }

    @EventHandler
    public void onLeave(PlayerDeathEvent event) {
        TeleportTask task = TELEPORTING.remove(event.getEntity());
        if (task != null && task.onDamage != null) {
            task.onDeath.apply(event);
            task.task.cancel();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        TeleportTask task = TELEPORTING.remove((Player)event.getEntity());
        if (task != null && task.onDamage != null) {
            task.onDamage.apply(event);
            task.task.cancel();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent event) {
        Kingdoms.taskScheduler().async().execute(() -> {
            if (!LocationUtils.hasMoved(event.getFrom(), event.getTo())) {
                return;
            }
            TeleportTask task = TELEPORTING.remove(event.getPlayer());
            if (task != null && task.onMove != null) {
                task.onMove.apply(event);
                task.task.cancel();
            }
        });
    }
}

