/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.teleportation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.managers.teleportation.TeleportTask;
import org.kingdoms.managers.teleportation.TpManager;

public class IsolatedTpManager {
    private final Map<UUID, TeleportTask> teleporting = new HashMap<UUID, TeleportTask>();

    public void put(Player player, BukkitTask task) {
        this.put(new TeleportTask(player, task));
    }

    public void put(TeleportTask task) {
        TpManager.put(task);
        TeleportTask previous = this.teleporting.put(task.player.getUniqueId(), task);
        if (previous != null) {
            previous.task.cancel();
        }
    }

    public boolean isTeleporting(Entity entity2) {
        return this.teleporting.containsKey(entity2.getUniqueId());
    }

    public Collection<TeleportTask> getTasks() {
        return this.teleporting.values();
    }

    public boolean end(Player entity2) {
        TpManager.end(entity2);
        TeleportTask task = this.teleporting.remove(entity2.getUniqueId());
        if (task != null) {
            task.task.cancel();
        }
        return task != null;
    }
}

