/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.pvp;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0016H\u0007R.\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/managers/pvp/PvPTagManager;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onLeave", "", "event", "Lorg/bukkit/event/player/PlayerQuitEvent;", "TAGGED", "", "Ljava/util/UUID;", "", "Lorg/kingdoms/managers/pvp/PvPTagManager$TagData;", "getTAGGED$annotations", "getTAGGED", "()Ljava/util/Map;", "getTags", "player", "readOnly", "", "tag", "damaged", "Lorg/bukkit/entity/Player;", "damager", "isTagged", "TagData", "core"})
public final class PvPTagManager
implements Listener {
    @NotNull
    public static final PvPTagManager INSTANCE = new PvPTagManager();
    @NotNull
    private static final Map<UUID, Set<TagData>> TAGGED = new HashMap();

    private PvPTagManager() {
    }

    @EventHandler
    public final void onLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TAGGED.remove(event.getPlayer().getUniqueId());
    }

    @NotNull
    public static final Map<UUID, Set<TagData>> getTAGGED() {
        return TAGGED;
    }

    @JvmStatic
    public static /* synthetic */ void getTAGGED$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final Set<TagData> getTags(@NotNull UUID player, boolean readOnly) {
        Set data;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Set set = TAGGED.get(player);
        if (set == null) {
            PvPTagManager $this$getTags_u24lambda_u240 = INSTANCE;
            boolean bl = false;
            if (readOnly) {
                set = new HashSet();
            } else {
                Set newData = new HashSet();
                TAGGED.put(player, newData);
                set = newData;
            }
        }
        if ((data = set).isEmpty()) {
            return data;
        }
        long currTime = System.currentTimeMillis();
        data.removeIf(arg_0 -> PvPTagManager.getTags$lambda$2(arg_0 -> PvPTagManager.getTags$lambda$1(currTime, arg_0), arg_0));
        if (readOnly && data.isEmpty()) {
            TAGGED.remove(player);
        }
        return data;
    }

    @JvmStatic
    public static final void tag(@NotNull Player damaged, @NotNull Player damager) {
        Intrinsics.checkNotNullParameter((Object)damaged, (String)"damaged");
        Intrinsics.checkNotNullParameter((Object)damager, (String)"damager");
        long currTime = System.currentTimeMillis();
        UUID uUID = damaged.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        Set<TagData> set = PvPTagManager.getTags(uUID, false);
        UUID uUID2 = damager.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUniqueId(...)");
        set.add(new TagData(uUID2, currTime));
        UUID uUID3 = damager.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUniqueId(...)");
        Set<TagData> set2 = PvPTagManager.getTags(uUID3, false);
        UUID uUID4 = damaged.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUniqueId(...)");
        set2.add(new TagData(uUID4, currTime));
    }

    @JvmStatic
    public static final boolean isTagged(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return !((Collection)PvPTagManager.getTags(player, true)).isEmpty();
    }

    @JvmStatic
    public static final boolean isTagged(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        return PvPTagManager.isTagged(uUID);
    }

    private static final boolean getTags$lambda$1(long $currTime, TagData x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        long diff = $currTime - x.getAt();
        return diff >= 10000L;
    }

    private static final boolean getTags$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/kingdoms/managers/pvp/PvPTagManager$TagData;", "", "player", "Ljava/util/UUID;", "at", "", "<init>", "(Ljava/util/UUID;J)V", "getPlayer", "()Ljava/util/UUID;", "getAt", "()J", "core"})
    public static final class TagData {
        @NotNull
        private final UUID player;
        private final long at;

        public TagData(@NotNull UUID player, long at) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.player = player;
            this.at = at;
        }

        @NotNull
        public final UUID getPlayer() {
            return this.player;
        }

        public final long getAt() {
            return this.at;
        }
    }
}

