/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.pvp;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.pets.PetInfo;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;

public final class PvPManager
implements Listener {
    private static final String TRIDENT_LIGHTNING_SHOOTER = "TRIDENT_LIGHTNING_SHOOTER";
    private static final PvPType PVP_TYPE;
    private static final List<PvPHandler> HANDLERS;
    private static final String ARROW_FORCE = "ARROW_FORCE";

    public static void registerHandler(PvPHandler handler) {
        Objects.requireNonNull(handler);
        HANDLERS.add(handler);
    }

    public PvPManager() {
        if (XReflection.supports((int)13)) {
            Bukkit.getPluginManager().registerEvents((Listener)new v1_13(), (Plugin)Kingdoms.get());
        }
    }

    public static LivingEntity getKiller(EntityDeathEvent event) {
        EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            ProjectileSource shooter;
            Entity damager = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
            if (damager instanceof Projectile && (shooter = ((Projectile)damager).getShooter()) instanceof LivingEntity) {
                UUID owner;
                LivingEntity entityShooter = (LivingEntity)shooter;
                PetInfo petInfo = ServiceHandler.getPetInfo((Entity)entityShooter);
                UUID uUID = owner = petInfo == null ? null : petInfo.getOwner();
                if (owner != null) {
                    return Bukkit.getPlayer((UUID)owner);
                }
                return entityShooter;
            }
            if (damager instanceof LivingEntity) {
                UUID owner;
                PetInfo petInfo = ServiceHandler.getPetInfo(damager);
                UUID uUID = owner = petInfo == null ? null : petInfo.getOwner();
                if (owner != null) {
                    return Bukkit.getPlayer((UUID)owner);
                }
                return (LivingEntity)damager;
            }
        }
        return event.getEntity().getKiller();
    }

    public static boolean isPvPType(PvPType PvPType2) {
        return PVP_TYPE == PvPType2;
    }

    public static PvPType getPvpType() {
        return PVP_TYPE;
    }

    public static Player getDamager(Entity entity2) {
        AreaEffectCloud aec;
        ProjectileSource src;
        Object shooter;
        if (entity2 instanceof Projectile && (shooter = ((Projectile)entity2).getShooter()) instanceof Player) {
            UUID owner;
            Player entityShooter = (Player)shooter;
            PetInfo petInfo = ServiceHandler.getPetInfo((Entity)entityShooter);
            UUID uUID = owner = petInfo == null ? null : petInfo.getOwner();
            if (owner != null) {
                return Bukkit.getPlayer((UUID)owner);
            }
            return entityShooter;
        }
        if (entity2 instanceof LivingEntity) {
            UUID owner;
            PetInfo petInfo = ServiceHandler.getPetInfo(entity2);
            UUID uUID = owner = petInfo == null ? null : petInfo.getOwner();
            if (owner != null) {
                return Bukkit.getPlayer((UUID)owner);
            }
        }
        if (entity2 instanceof LightningStrike && !(shooter = entity2.getMetadata(TRIDENT_LIGHTNING_SHOOTER)).isEmpty()) {
            return (Player)((MetadataValue)shooter.get(0)).value();
        }
        if (entity2 instanceof AreaEffectCloud && (src = (aec = (AreaEffectCloud)entity2).getSource()) instanceof Player) {
            return (Player)src;
        }
        if (entity2 instanceof Player) {
            return (Player)entity2;
        }
        return null;
    }

    public static boolean canFight(@NonNull Player damager, @NonNull Player victim) {
        boolean victimUnclaimed;
        PvPType pvpType;
        if (PVP_TYPE == PvPType.DISABLED) {
            return true;
        }
        if (PVP_TYPE == PvPType.DISALLOWED) {
            return false;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)damager)) {
            return true;
        }
        KingdomPlayer damagerKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)damager);
        if (damagerKp.isAdmin()) {
            return true;
        }
        KingdomPlayer victimKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)victim);
        if (damagerKp.isPvp() && victimKp.isPvp()) {
            return true;
        }
        for (PvPHandler handler : HANDLERS) {
            Boolean result = handler.canFight(victim, damager);
            if (result == null) continue;
            return result;
        }
        if (PVP_TYPE == PvPType.CONDITIONAL) {
            ConditionalExpression condition = KingdomsConfig.Relations.PVP_ADVANCED.getManager().getCondition();
            PlaceholderContextBuilder context = new PlaceholderContextBuilder().withContext(damager).other(victim);
            return ConditionProcessor.process(condition, context);
        }
        Kingdom damagerKingdom = damagerKp.getKingdom();
        Kingdom victimKingdom = victimKp.getKingdom();
        PvPType pvPType = PVP_TYPE != PvPType.RELATIONAL ? PVP_TYPE : (pvpType = (damagerKingdom == null || victimKingdom == null ? KingdomRelation.NEUTRAL : damagerKingdom.getRelationWith(victimKingdom)).getPvPType());
        if (pvpType == PvPType.DISABLED) {
            return true;
        }
        if (pvpType == PvPType.DISALLOWED) {
            return false;
        }
        if ((damagerKingdom != null && damagerKingdom.isPacifist() || victimKingdom != null && victimKingdom.isPacifist()) && KingdomsConfig.Invasions.PACIFISM_DISABLE_PVP.getManager().getBoolean()) {
            return false;
        }
        if ((damagerKingdom != null && !damagerKingdom.getShield().hasExpired() || victimKingdom != null && !victimKingdom.getShield().hasExpired()) && KingdomsConfig.Invasions.SHIELDS_DISABLE_PVP.getManager().getBoolean()) {
            return false;
        }
        if (damagerKingdom != null && victimKingdom != null && StandardRelationAttribute.CEASEFIRE.hasAttribute(victimKingdom, damagerKingdom)) {
            return false;
        }
        if (damagerKp.isInvading() || victimKp.isInvading()) {
            return true;
        }
        if (pvpType == PvPType.NORMAL) {
            return true;
        }
        if (pvpType == PvPType.MASSWAR && Masswar.getInstance().isRunning()) {
            return true;
        }
        SimpleChunkLocation damagerChunk = SimpleChunkLocation.of(damager.getLocation());
        SimpleChunkLocation victimChunk = SimpleChunkLocation.of(victim.getLocation());
        Land damagerLand = damagerChunk.getLand();
        Land victimLand = victimChunk.getLand();
        boolean damagerUnclaimed = damagerLand == null || !damagerLand.isClaimed();
        boolean bl = victimUnclaimed = victimLand == null || !victimLand.isClaimed();
        if (pvpType == PvPType.TERRITORY) {
            if (damagerKingdom == null && victimKingdom == null) {
                return true;
            }
            if (damagerUnclaimed && victimUnclaimed) {
                return true;
            }
            if (!damagerUnclaimed && StandardRelationAttribute.CEASEFIRE.hasAttribute(damagerKingdom, damagerLand.getKingdom())) {
                return false;
            }
            return victimUnclaimed || !StandardRelationAttribute.CEASEFIRE.hasAttribute(victimKingdom, victimLand.getKingdom());
        }
        if (!damagerChunk.equalsIgnoreWorld(victimChunk) && damagerUnclaimed != (victimLand == null || !victimLand.isClaimed())) {
            return false;
        }
        return pvpType == (damagerUnclaimed ? PvPType.UNCLAIMED : PvPType.CLAIMED);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void bowChargeCheck(EntityShootBowEvent event) {
        float force = event.getForce();
        Entity projectile = event.getProjectile();
        projectile.setMetadata(ARROW_FORCE, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)Float.valueOf(force)));
    }

    public static Optional<Float> getChargedForce(Projectile arrow) {
        List forceMeta = arrow.getMetadata(ARROW_FORCE);
        if (forceMeta.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(((MetadataValue)forceMeta.get(0)).asFloat()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onFriendlyFire(EntityDamageByEntityEvent event) {
        UUID owner;
        PetInfo petInfo;
        Player victim;
        Player damager = PvPManager.getDamager(event.getDamager());
        if (damager == null) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)damager)) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Player) {
            victim = (Player)entity2;
        } else if (entity2 instanceof LivingEntity && (petInfo = ServiceHandler.getPetInfo(entity2)) != null && (owner = petInfo.getOwner()) != null) {
            victim = Bukkit.getPlayer((UUID)owner);
        } else {
            if (LandProtectionManager.onEntityBreakOrDamage(event, damager)) {
                return;
            }
            return;
        }
        if (!PvPManager.canFight(damager, victim)) {
            event.setCancelled(true);
        }
    }

    static {
        HANDLERS = new ArrayList<PvPHandler>();
        String pvp = KingdomsConfig.Relations.PVP.getManager().getString().toUpperCase(Locale.ENGLISH);
        PVP_TYPE = (PvPType)((Object)Enums.getIfPresent(PvPType.class, (String)pvp).or((Object)PvPType.NORMAL));
    }

    public static final class v1_13
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onLightning(LightningStrikeEvent event) {
            if (event.getCause() != LightningStrikeEvent.Cause.TRIDENT) {
                return;
            }
            for (Entity entity2 : event.getLightning().getNearbyEntities(2.0, 2.0, 2.0)) {
                Trident trident;
                if (!(entity2 instanceof Trident) || !((trident = (Trident)entity2).getShooter() instanceof Player)) continue;
                event.getLightning().setMetadata(PvPManager.TRIDENT_LIGHTNING_SHOOTER, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)trident.getShooter()));
                break;
            }
        }
    }

    public static enum PvPType {
        DISABLED,
        DISALLOWED,
        NORMAL,
        CLAIMED,
        UNCLAIMED,
        MASSWAR,
        TERRITORY,
        RELATIONAL,
        CONDITIONAL;

    }

    public static interface PvPHandler {
        public Boolean canFight(@NonNull Player var1, @NonNull Player var2);
    }
}

