/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.protectionsign;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.abstraction.processor.KingdomsProcess;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomBuildingTypeRegistry;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.OpenProtectedBlockEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.chat.ChatInputHandler;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.managers.land.InteractProcessor;
import org.kingdoms.managers.land.block.KingdomsBlockBreakContext;
import org.kingdoms.managers.land.block.KingdomsBlockInteractContext;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContext;
import org.kingdoms.managers.land.block.KingdomsBlockRepairContext;
import org.kingdoms.managers.land.block.KingdomsBlockUpgradeContext;
import org.kingdoms.managers.protectionsign.ProtectionSignGUIManager;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.cache.caffeine.ExpirableSet;
import org.kingdoms.utils.cache.caffeine.ExpirationStrategy;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class ProtectionSignManager
implements Listener,
KingdomBuildingHandler<ProtectionSign> {
    private static final ExpirableSet<UUID> PASSWORD_COOLDOWNS;
    private static final Map<UUID, Integer> PASSWORD_ATTEMPTS;
    public static ProtectionSignManager MANAGER;
    private static final Namespace NS;
    private static final Map<ProtectionSign, DelayedTask> PENDING_AUTOMATIC_STATE_CHANGE;

    public ProtectionSignManager(Kingdoms plugin) {
        if (ItemTransferFactory.DISALLOW_ALL || ItemTransferFactory.DISALLOW_CROSS_ORIGIN) {
            Bukkit.getPluginManager().registerEvents((Listener)new ItemTransferFactory(), (Plugin)plugin);
        }
        MANAGER = this;
    }

    protected static Block putSignOn(Block block, XMaterial signMaterial, BlockFace facing) {
        String name = Strings.replace(signMaterial.name(), "SIGN", "WALL_SIGN");
        signMaterial = (XMaterial)XMaterial.matchXMaterial((String)name).orElseThrow(() -> new IllegalArgumentException("Unexpected sign material for protection: " + name));
        block = block.getRelative(facing);
        block.setType(signMaterial.parseMaterial());
        VersionSupport.putSign(block, facing);
        return block;
    }

    private static boolean canBeDouble(Block block) {
        return block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST;
    }

    public static Messenger handleProtectedBlock(PlayerInteractEvent event, ProtectionSign protection, InteractProcessor processor) {
        Block block;
        KingdomsLang issue;
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        boolean admin = KingdomsDefaultPluginPermission.PROTECTION$SIGNS_OPEN.hasPermission((CommandSender)player, true);
        ProtectionSign.AccessPrivilege accessLevel = protection.canAccess((OfflinePlayer)player);
        boolean canOpen = admin || accessLevel == ProtectionSign.AccessPrivilege.ALLOWED || accessLevel == ProtectionSign.AccessPrivilege.OWNER;
        Land land = protection.getLand();
        if (accessLevel == ProtectionSign.AccessPrivilege.OWNER && (issue = processor.others(land, true)) != null) {
            return issue;
        }
        if (!canOpen) {
            Nation nation;
            Kingdom kingdom;
            boolean isClaimed = land.isClaimed();
            if (!isClaimed && !KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean()) {
                canOpen = true;
            }
            if (!canOpen && isClaimed) {
                boolean bl = canOpen = land.getKingdomId().equals(kp.getKingdomId()) && kp.hasPermission(StandardKingdomPermission.PROTECTION_SIGNS);
            }
            if (!canOpen && (kingdom = kp.getKingdom()) != null && (nation = kingdom.getNation()) != null && nation.isMember(land.getKingdomId())) {
                canOpen = kp.hasNationPermission(StandardKingdomPermission.PROTECTION_SIGNS);
            }
        }
        if (ProtectionSign.isSign(block = event.getClickedBlock()) && KingdomsConfig.ProtectionSigns.GUI.getManager().getBoolean()) {
            if (!admin && !protection.isOwner((OfflinePlayer)player)) {
                ProtectionSignManager.deniedSound(player);
                return KingdomsLang.PROTECTED_SIGNS_CANT_MODIFY;
            }
            new ProtectionSignGUIManager(player, protection).openMenu();
            event.setCancelled(true);
            return null;
        }
        if (!canOpen) {
            BlockState state;
            event.setCancelled(true);
            if (accessLevel == ProtectionSign.AccessPrivilege.PASSWORD && (state = block.getState()) instanceof Container) {
                return ProtectionSignManager.requestPassword(player, protection, (Container)state, processor);
            }
            ProtectionSignManager.deniedSound(player);
            return KingdomsLang.PROTECTED_SIGNS_PROTECTED;
        }
        OpenProtectedBlockEvent openEvent = new OpenProtectedBlockEvent(player, block, protection, canOpen);
        Bukkit.getPluginManager().callEvent((Event)openEvent);
        if (openEvent.isCancelled()) {
            event.setCancelled(true);
        }
        return null;
    }

    private static void handlePistons(BlockPistonEvent event, Collection<Block> blocks) {
        boolean protect = KingdomsConfig.ProtectionSigns.PROTECTIONS_PISTON.getManager().getBoolean();
        for (Block block : blocks) {
            Optional<ProtectionSign> protectionOpt = ProtectionSign.getProtection(block);
            if (!protectionOpt.isPresent()) continue;
            if (protect) {
                event.setCancelled(true);
                return;
            }
            ProtectionSign protection = protectionOpt.get();
            protection.getLand().unsafeGetProtectedBlocks().remove(protection.getOrigin().toBlockVector());
        }
    }

    private static boolean handleAlreadyProtected(Player player, Block block) {
        Optional<ProtectionSign> protectionOpt = ProtectionSign.getProtection(block);
        if (protectionOpt.isPresent()) {
            KingdomsLang.PROTECTED_SIGNS_ALREADY_PROTECTED.sendMessage((CommandSender)player, "owner", Bukkit.getOfflinePlayer((UUID)protectionOpt.get().getOwner()).getName());
            ProtectionSignManager.deniedSound(player);
            return true;
        }
        return false;
    }

    private static void deniedSound(Player player) {
        XSound.play((String)KingdomsConfig.ProtectionSigns.DENIED_SOUND.getManager().getString(), x -> x.forPlayers(new Player[]{player}));
    }

    public static Messenger requestPassword(Player player, ProtectionSign sign, Container container, InteractProcessor processor) {
        Duration cd = PASSWORD_COOLDOWNS.getTimeLeft(player.getUniqueId());
        if (!cd.isZero()) {
            processor.var("cooldown", TimeFormatter.of(cd));
            return KingdomsLang.PROTECTED_SIGNS_PASSWORD_IN_COOLDOWN;
        }
        if (!sign.hasPassword()) {
            return KingdomsLang.PROTECTED_SIGNS_PASSWORD_REQUIRED_NO_PASSWORD;
        }
        if (processor.getIntent() == KingdomsProcess.Intent.REALTIME) {
            ChatInputHandler handler = new ChatInputHandler();
            handler.onInput(event -> {
                if (sign.verifyPassword(event.getMessage())) {
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> player.openInventory(container.getInventory()));
                    sign.getTemporarilyTrusted().add(player.getUniqueId());
                    PASSWORD_ATTEMPTS.remove(player.getUniqueId());
                    return true;
                }
                int maxAttempts = KingdomsConfig.ProtectionSigns.PASSWORDS_MAX_ATTEMPTS.getManager().getInt();
                int attempts = PASSWORD_ATTEMPTS.getOrDefault(player.getUniqueId(), 0) + 1;
                if (attempts >= maxAttempts) {
                    KingdomsLang.PROTECTED_SIGNS_PASSWORD_ERROR_429.sendError((CommandSender)player, new Object[0]);
                    PASSWORD_COOLDOWNS.add(player.getUniqueId());
                    return true;
                }
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_INVALID.sendError((CommandSender)player, new Object[0]);
                PASSWORD_ATTEMPTS.put(player.getUniqueId(), attempts);
                return false;
            });
            handler.onAnyMove(event -> {
                KingdomsLang.PROTECTED_SIGNS_PASSWORD_CANT_MOVE.sendError((CommandSender)player, new Object[0]);
                return true;
            });
            ChatInputManager.startConversation(player, handler);
        }
        return KingdomsLang.PROTECTED_SIGNS_PASSWORD_REQUIRED;
    }

    public static List<String> getProtectionTypeSignLines(ProtectionSign.ProtectionType protectionType) {
        switch (protectionType) {
            case PROTECTED: {
                return KingdomsConfig.ProtectionSigns.LINES.getManager().getStringList();
            }
            case EVERYONE: {
                return KingdomsConfig.ProtectionSigns.EVERYONE_LINES.getManager().getStringList();
            }
            case EVERYONE_IN_KINGDOM: {
                return KingdomsConfig.ProtectionSigns.EVERYONE_IN_KINGDOM_LINES.getManager().getStringList();
            }
        }
        throw new AssertionError((Object)("Unknown sign protection type: " + (Object)((Object)protectionType)));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDoorOpen(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Optional<VersionSupport.Openable> openable = VersionSupport.openable(block);
        if (!openable.isPresent()) {
            return;
        }
        Optional<ProtectionSign> protectionOpt = ProtectionSign.getProtection(block);
        if (!protectionOpt.isPresent()) {
            return;
        }
        ProtectionSign protection = protectionOpt.get();
        if (protection.getAutomaticStateToggle() == null) {
            return;
        }
        DelayedTask previousPendingTask = PENDING_AUTOMATIC_STATE_CHANGE.get(protection);
        if (previousPendingTask != null) {
            previousPendingTask.cancel();
        }
        if (openable.get().isOpen()) {
            return;
        }
        DelayedTask task = Kingdoms.taskScheduler().sync().delayed(protection.getAutomaticStateToggle(), () -> {
            ((VersionSupport.Openable)openable.get()).setOpen(false);
            PENDING_AUTOMATIC_STATE_CHANGE.remove(protection);
            ParticleDisplay.of((XParticle)XParticle.CLOUD).offset(0.3, 0.7, 0.3).withCount(100).spawn(block.getLocation());
            ProtectionSignManager.getCloseSound(block).play(block.getLocation());
        });
        PENDING_AUTOMATIC_STATE_CHANGE.put(protection, task);
    }

    private static XSound getCloseSound(Block block) {
        XMaterial material = XMaterial.matchXMaterial((Material)block.getType());
        switch (material) {
            case OAK_DOOR: 
            case BIRCH_DOOR: 
            case SPRUCE_DOOR: 
            case ACACIA_DOOR: 
            case JUNGLE_DOOR: 
            case CRIMSON_DOOR: 
            case DARK_OAK_DOOR: 
            case MANGROVE_DOOR: {
                return XSound.BLOCK_WOODEN_DOOR_CLOSE;
            }
            case WARPED_DOOR: {
                return XSound.BLOCK_NETHER_WOOD_DOOR_CLOSE;
            }
            case CHERRY_DOOR: {
                return XSound.BLOCK_CHERRY_WOOD_DOOR_CLOSE;
            }
            case BAMBOO_DOOR: {
                return XSound.BLOCK_BAMBOO_WOOD_DOOR_CLOSE;
            }
            case COPPER_DOOR: 
            case WAXED_COPPER_DOOR: 
            case EXPOSED_COPPER_DOOR: 
            case OXIDIZED_COPPER_DOOR: 
            case WEATHERED_COPPER_DOOR: 
            case WAXED_EXPOSED_COPPER_DOOR: 
            case WAXED_OXIDIZED_COPPER_DOOR: 
            case WAXED_WEATHERED_COPPER_DOOR: {
                return XSound.BLOCK_COPPER_DOOR_CLOSE;
            }
            case IRON_DOOR: {
                return XSound.BLOCK_IRON_DOOR_CLOSE;
            }
            case ACACIA_TRAPDOOR: 
            case BAMBOO_TRAPDOOR: 
            case BIRCH_TRAPDOOR: 
            case CHERRY_TRAPDOOR: 
            case SPRUCE_TRAPDOOR: 
            case DARK_OAK_TRAPDOOR: 
            case CRIMSON_TRAPDOOR: 
            case JUNGLE_TRAPDOOR: 
            case MANGROVE_TRAPDOOR: 
            case OAK_TRAPDOOR: {
                return XSound.BLOCK_WOODEN_TRAPDOOR_CLOSE;
            }
            case COPPER_TRAPDOOR: 
            case EXPOSED_COPPER_TRAPDOOR: 
            case OXIDIZED_COPPER_TRAPDOOR: 
            case WAXED_COPPER_TRAPDOOR: 
            case WAXED_EXPOSED_COPPER_TRAPDOOR: 
            case WAXED_OXIDIZED_COPPER_TRAPDOOR: 
            case WAXED_WEATHERED_COPPER_TRAPDOOR: 
            case WEATHERED_COPPER_TRAPDOOR: {
                return XSound.BLOCK_COPPER_TRAPDOOR_CLOSE;
            }
            case IRON_TRAPDOOR: {
                return XSound.BLOCK_IRON_TRAPDOOR_CLOSE;
            }
            case WARPED_TRAPDOOR: {
                return XSound.BLOCK_NETHER_WOOD_TRAPDOOR_CLOSE;
            }
        }
        return XSound.BLOCK_WOODEN_DOOR_CLOSE;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onSignPut(SignChangeEvent event) {
        String line = event.getLine(0);
        ProtectionSign.ProtectionType protectionType = null;
        boolean caseSensitive = KingdomsConfig.ProtectionSigns.CASE_SENSITIVE_CODES.getManager().getBoolean();
        if (!caseSensitive) {
            line = line.toLowerCase();
        }
        if (KingdomsConfig.ProtectionSigns.CODES.getManager().getStringList().contains(line)) {
            protectionType = ProtectionSign.ProtectionType.PROTECTED;
        }
        if (protectionType == null && KingdomsConfig.ProtectionSigns.EVERYONE_IN_KINGDOM_ENABLED.getManager().getBoolean() && KingdomsConfig.ProtectionSigns.EVERYONE_IN_KINGDOM_CODES.getManager().getStringList().contains(line)) {
            protectionType = ProtectionSign.ProtectionType.EVERYONE_IN_KINGDOM;
        }
        if (protectionType == null && KingdomsConfig.ProtectionSigns.EVERYONE_ENABLED.getManager().getBoolean() && KingdomsConfig.ProtectionSigns.EVERYONE_CODES.getManager().getStringList().contains(line)) {
            protectionType = ProtectionSign.ProtectionType.EVERYONE;
        }
        if (protectionType == null) {
            return;
        }
        Block sign = event.getBlock();
        Block block = VersionSupport.getAttachedBlock(sign);
        Player player = event.getPlayer();
        if (block == null) {
            KingdomsLang.PROTECTED_SIGNS_NOT_ATTACHED.sendMessage((CommandSender)player);
            ProtectionSignManager.deniedSound(player);
            return;
        }
        if (!ProtectionSign.canBlockBeProtected(block)) {
            KingdomsLang.PROTECTED_SIGNS_INVALID_BLOCK.sendMessage((CommandSender)player);
            ProtectionSignManager.deniedSound(player);
            return;
        }
        List<String> signs = KingdomsConfig.ProtectionSigns.SIGNS.getManager().getStringList();
        if (!signs.isEmpty() && !XBlock.isOneOf((Block)block, signs)) {
            KingdomsLang.PROTECTED_SIGNS_INVALID_SIGN.sendMessage((CommandSender)player);
            ProtectionSignManager.deniedSound(player);
            return;
        }
        if (ProtectionSignManager.handleAlreadyProtected(player, block)) {
            return;
        }
        SimpleLocation location = SimpleLocation.of(block);
        Land land = Land.getLand(block);
        if (land == null || !land.isClaimed()) {
            if (!KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean()) {
                KingdomsLang.PROTECTED_SIGNS_UNCLAIMED.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (land == null) {
                land = new Land((UUID)null, location.toSimpleChunkLocation());
            }
        }
        if (land.isKingdomBlock(location.toBlockVector())) {
            KingdomsLang.PROTECTED_SIGNS_KINGDOM_ITEMS.sendError((CommandSender)player, new Object[0]);
            return;
        }
        List<String> lines = ProtectionSignManager.getProtectionTypeSignLines(protectionType);
        ProtectionSign.placeProtection(land, block, sign, player, protectionType);
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(player);
        for (int i = 0; i < lines.size(); ++i) {
            MessageObject messageObjectBuilder = MessageCompiler.compile(lines.get(i));
            event.setLine(i, messageObjectBuilder.buildPlain(settings));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        ProtectionSignManager.handlePistons((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        ProtectionSignManager.handlePistons((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void doubleChestProtectNotifier(BlockPlaceEvent event) {
        if (!ProtectionSignManager.canBeDouble(event.getBlockPlaced())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            Block block = event.getBlockPlaced();
            if (!(block.getState() instanceof Chest)) {
                return;
            }
            Chest chest = (Chest)block.getState();
            Inventory inventory = chest.getInventory();
            if (inventory instanceof DoubleChestInventory) {
                Optional<ProtectionSign> protection;
                DoubleChest doubleChest = (DoubleChest)inventory.getHolder();
                Chest leftChest = (Chest)doubleChest.getLeftSide();
                Chest rightChest = (Chest)doubleChest.getRightSide();
                Block target = rightChest.getBlock();
                if (LocationUtils.equalsIgnoreWorld(block, target)) {
                    target = leftChest.getBlock();
                }
                if ((protection = ProtectionSign.getProtection(target)).isPresent()) {
                    Land otherLand;
                    SimpleChunkLocation mainChunk;
                    SimpleChunkLocation otherChunk;
                    Player player = event.getPlayer();
                    if (!(KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean() || (otherChunk = SimpleChunkLocation.of(block)).equalsIgnoreWorld(mainChunk = SimpleChunkLocation.of(target)) || (otherLand = otherChunk.getLand()) != null && otherLand.isClaimed())) {
                        KingdomsLang.PROTECTED_SIGNS_CANT_PROTECT_DOUBLE_CHEST.sendError((CommandSender)player, new Object[0]);
                        return;
                    }
                    ProtectionSign.AccessPrivilege privilege = protection.get().canAccess((OfflinePlayer)player);
                    if (privilege != ProtectionSign.AccessPrivilege.OWNER) {
                        KingdomsLang.PROTECTED_SIGNS_CANT_PROTECT_DOUBLE_CHEST_PERMISSION.sendError((CommandSender)player, new Object[0]);
                        block.breakNaturally();
                        return;
                    }
                    KingdomsLang.PROTECTED_SIGNS_DOUBLE_CHEST_PROTECTED.sendMessage((CommandSender)player);
                }
            }
        }, 1L);
    }

    @EventHandler
    public void onQuickProtect(PlayerInteractEvent event) {
        Kingdom kingdom;
        SimpleLocation location;
        boolean isCreative;
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getBlockFace() == BlockFace.UP || event.getBlockFace() == BlockFace.DOWN) {
            return;
        }
        if (!KingdomsConfig.ProtectionSigns.QUICK_PROTECT_ENABLED.getManager().getBoolean()) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!KingdomsDefaultPluginPermission.PROTECTION$SIGNS_USE.hasPermission((CommandSender)player, true)) {
            return;
        }
        boolean bl = isCreative = player.getGameMode() == GameMode.CREATIVE;
        if (isCreative && !KingdomsDefaultPluginPermission.PROTECTION$SIGNS_USE_CREATIVE.hasPermission((CommandSender)player, true)) {
            return;
        }
        if (!player.isSneaking() && KingdomsConfig.ProtectionSigns.QUICK_PROTECT_SNEAK.getManager().getBoolean()) {
            return;
        }
        ItemStack itemSign = event.getItem();
        if (itemSign == null || !itemSign.getType().name().endsWith("SIGN")) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!ProtectionSign.canBlockBeProtected(block)) {
            return;
        }
        List<String> signs = KingdomsConfig.ProtectionSigns.SIGNS.getManager().getStringList();
        XMaterial material = XMaterial.matchXMaterial((ItemStack)itemSign);
        boolean contains = XTag.anyMatch((Object)material, (Collection)XTag.stringMatcher(signs, null));
        if (!signs.isEmpty() && !contains) {
            KingdomsLang.PROTECTED_SIGNS_INVALID_SIGN.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
            return;
        }
        SimpleChunkLocation chunk = SimpleChunkLocation.of(block);
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed()) {
            if (!KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean()) {
                KingdomsLang.PROTECTED_SIGNS_UNCLAIMED.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (land == null) {
                land = new Land((UUID)null, chunk);
            }
        }
        if (land.isKingdomBlock((location = SimpleLocation.of(block)).toBlockVector())) {
            KingdomsLang.PROTECTED_SIGNS_KINGDOM_ITEMS.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (!(kp.isAdmin() || !land.isClaimed() || (kingdom = kp.getKingdom()) != null && kingdom.hasAttribute(land.getKingdom(), (RelationAttribute)StandardRelationAttribute.BUILD))) {
            KingdomsLang.PROTECTED_SIGNS_OTHER_KINGDOMS.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (ProtectionSignManager.handleAlreadyProtected(player, block)) {
            event.setCancelled(true);
            return;
        }
        Block signBlock = block.getRelative(event.getBlockFace());
        if (!LocationUtils.blockCanBeReplaced(signBlock)) {
            KingdomsLang.PROTECTED_SIGNS_INVALID_SIGN_BLOCK.sendError((CommandSender)player, "block", XMaterial.matchXMaterial((Material)signBlock.getType()));
            event.setCancelled(true);
            return;
        }
        Block sign = ProtectionSignManager.putSignOn(block, material, event.getBlockFace());
        event.setCancelled(true);
        if (!isCreative) {
            itemSign.setAmount(itemSign.getAmount() - 1);
        }
        ProtectionSign.placeProtection(land, block, sign, player, ProtectionSign.ProtectionType.PROTECTED);
        List<String> lines = KingdomsConfig.ProtectionSigns.LINES.getManager().getStringList();
        Sign state = (Sign)sign.getState();
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(player);
        for (int i = 0; i < lines.size(); ++i) {
            MessageObject messageObjectBuilder = MessageCompiler.compile(lines.get(i));
            state.setLine(i, messageObjectBuilder.buildPlain(settings));
        }
        state.update(true);
    }

    @Override
    @NotNull
    public KingdomBuildingTypeRegistry<?, ?> getRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Messenger onPlace(@NotNull KingdomsBlockPlaceContext<ProtectionSign> context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Messenger onBreak(@NotNull KingdomsBlockBreakContext<ProtectionSign> context) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static KingdomsLang handleBreak(Player player, Block block, ProtectionSign protection, AtomicBoolean fail) {
        boolean canBreak;
        boolean isSign = protection.getSign().equals(SimpleLocation.of(block));
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        boolean admin = kp.isAdmin() || kp.hasKingdom() && kp.getKingdomId().equals(protection.getLand().getKingdomId()) && kp.hasPermission(StandardKingdomPermission.PROTECTION_SIGNS) || KingdomsDefaultPluginPermission.PROTECTION$SIGNS_BREAK.hasPermission((CommandSender)player, true);
        boolean bl = canBreak = admin || protection.getOwner().equals(player.getUniqueId()) || !KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean() && !Land.isClaimed(Land.getLand(block));
        if (canBreak || protection.canAccess((OfflinePlayer)player) == ProtectionSign.AccessPrivilege.ALLOWED) {
            if (canBreak) {
                if (isSign || protection.shouldRemoveProtectionAfterBreak(block)) {
                    protection.removeProtection();
                }
                fail.set(false);
                if (isSign) {
                    return KingdomsLang.PROTECTED_SIGNS_UNPROTECTED;
                }
                return KingdomsLang.PROTECTED_SIGNS_BROKE;
            }
            fail.set(true);
            return KingdomsLang.PROTECTED_SIGNS_CANT_BREAK;
        }
        fail.set(true);
        return KingdomsLang.PROTECTED_SIGNS_PROTECTED;
    }

    @Override
    @Nullable
    public Messenger onInteract(@NotNull KingdomsBlockInteractContext<ProtectionSign> context) {
        return null;
    }

    @Override
    @Nullable
    public Messenger onRepair(@NotNull KingdomsBlockRepairContext<ProtectionSign> context) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Messenger onUpgrade(@NotNull KingdomsBlockUpgradeContext<ProtectionSign> context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Namespace getNamespace() {
        return NS;
    }

    static {
        PASSWORD_ATTEMPTS = new NonNullMap<UUID, Integer>();
        NS = Namespace.kingdoms("PROTECTION_SIGN");
        PASSWORD_COOLDOWNS = new ExpirableSet(ExpirationStrategy.expireAfterCreate(KingdomsConfig.ProtectionSigns.PASSWORDS_MAX_ATTEMPTS_COOLDOWN.getManager().getTime()));
        PENDING_AUTOMATIC_STATE_CHANGE = new HashMap<ProtectionSign, DelayedTask>();
    }

    public static final class ItemTransferFactory
    implements Listener {
        private static final boolean DISALLOW_ALL = KingdomsConfig.ProtectionSigns.PROTECTIONS_CONTAINER_TRANSFERS_DISALLOW_ALL.getManager().getBoolean();
        private static final boolean DISALLOW_CROSS_ORIGIN = KingdomsConfig.ProtectionSigns.PROTECTIONS_CONTAINER_TRANSFERS_DISALLOW_CROSS_ORIGIN_CONTAINER_TRANSFERS.getManager().getBoolean();

        @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
        public void onProtectedTransfer(InventoryMoveItemEvent event) {
            Optional destOpt;
            Location srcLocaton = event.getSource().getLocation();
            Optional srcOpt = srcLocaton == null ? Optional.empty() : ProtectionSign.getProtection(srcLocaton.getBlock());
            Location destLocation = event.getDestination().getLocation();
            Optional<Object> optional = destOpt = destLocation == null ? Optional.empty() : ProtectionSign.getProtection(destLocation.getBlock());
            if (DISALLOW_ALL) {
                if (srcOpt.isPresent() || destOpt.isPresent()) {
                    event.setCancelled(true);
                }
                return;
            }
            if (srcOpt.isPresent() && destOpt.isPresent()) {
                boolean disallowTransfers;
                ProtectionSign src = (ProtectionSign)srcOpt.get();
                ProtectionSign dest = (ProtectionSign)destOpt.get();
                boolean bl = DISALLOW_CROSS_ORIGIN ? !src.getOwner().equals(dest.getOwner()) : (disallowTransfers = src.canAccess(dest.getOwner()) != ProtectionSign.AccessPrivilege.ALLOWED);
                if (disallowTransfers) {
                    event.setCancelled(true);
                }
                return;
            }
            if (srcOpt.isPresent() || destOpt.isPresent()) {
                event.setCancelled(true);
            }
        }
    }
}

