/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.network.socket;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.Namespaced;
import org.kingdoms.constants.namespace.NamespacedRegistry;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.network.socket.SocketHandler;
import org.kingdoms.utils.network.SocketJsonCommunicator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/managers/network/socket/SocketManager;", "Lorg/kingdoms/constants/namespace/NamespacedRegistry;", "Lorg/kingdoms/managers/network/socket/SocketHandler;", "logger", "Ljava/util/logging/Logger;", "<init>", "(Ljava/util/logging/Logger;)V", "getLogger", "()Ljava/util/logging/Logger;", "sendRequest", "", "request", "Ljava/util/function/Consumer;", "Lcom/google/gson/JsonObject;", "register", "value", "socket", "Lorg/kingdoms/utils/network/SocketJsonCommunicator;", "getSocket", "()Lorg/kingdoms/utils/network/SocketJsonCommunicator;", "Companion", "shared"})
public final class SocketManager
extends NamespacedRegistry<SocketHandler> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final SocketJsonCommunicator socket;
    @Nullable
    private static SocketManager INSTANCE;

    public SocketManager(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Logger logger2 = this.logger = logger;
        this.socket = new SocketJsonCommunicator(this, logger2){
            final /* synthetic */ SocketManager this$0;
            {
                this.this$0 = $receiver;
                super(4343, $super_call_param$1);
            }

            public void onReceive(JsonElement data) {
                String requestId;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (!(data instanceof JsonObject)) {
                    boolean $i$a$-require-SocketManager$socket$1$onReceive$22 = false;
                    String $i$a$-require-SocketManager$socket$1$onReceive$22 = "Cannot deserialize non-object socket";
                    throw new IllegalArgumentException($i$a$-require-SocketManager$socket$1$onReceive$22.toString());
                }
                JsonElement jsonElement = ((JsonObject)data).get("namespace");
                if (jsonElement == null) {
                    throw new NullPointerException("Namespace element not available");
                }
                JsonElement nsElement = jsonElement;
                Namespace namespace = Namespace.fromString(nsElement.getAsString());
                Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
                Namespace ns = namespace;
                SocketHandler socketHandler = (SocketHandler)SocketManager.access$getRegistry$p$s2142175386(this.this$0).get(ns);
                if (socketHandler == null) {
                    throw new IllegalArgumentException("Unknown socket handler: " + ns);
                }
                SocketHandler handler = socketHandler;
                JsonElement jsonElement2 = ((JsonObject)data).get("data");
                if (jsonElement2 == null) {
                    throw new NullPointerException("Missing data element for: " + ns);
                }
                JsonElement dataElement = jsonElement2;
                JsonElement jsonElement3 = ((JsonObject)data).get("id");
                String string = requestId = jsonElement3 != null ? jsonElement3.getAsString() : null;
                if (handler.getNeedsRequestId() && requestId == null) {
                    throw new NullPointerException("Missing request ID for: " + ns);
                }
                handler.onReceive(handler.new SocketHandler.SocketSession(this.this$0, dataElement, requestId));
            }
        };
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void sendRequest(@NotNull Consumer<JsonObject> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        JsonObject jsonObject = new JsonObject();
        request.accept(jsonObject);
        this.socket.send((JsonElement)jsonObject);
    }

    @Override
    public void register(@NotNull SocketHandler value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.register((Namespaced)value);
        this.socket.log("Registered handler: " + value.getNamespace());
    }

    @NotNull
    public final SocketJsonCommunicator getSocket() {
        return this.socket;
    }

    @JvmStatic
    public static final void initMainManager(@NotNull Logger logger) {
        Companion.initMainManager(logger);
    }

    @JvmStatic
    @NotNull
    public static final SocketManager getMain() {
        return Companion.getMain();
    }

    public static final /* synthetic */ Map access$getRegistry$p$s2142175386(SocketManager $this) {
        return $this.registry;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0007R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\f"}, d2={"Lorg/kingdoms/managers/network/socket/SocketManager$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/kingdoms/managers/network/socket/SocketManager;", "getINSTANCE$annotations", "initMainManager", "", "logger", "Ljava/util/logging/Logger;", "getMain", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getINSTANCE$annotations() {
        }

        @JvmStatic
        public final void initMainManager(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            INSTANCE = new SocketManager(logger);
        }

        @JvmStatic
        @NotNull
        public final SocketManager getMain() {
            SocketManager socketManager = INSTANCE;
            Intrinsics.checkNotNull((Object)socketManager);
            return socketManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

