/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.mails;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.GroupResolver;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.mails.CachedMail;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.mails.MailRecipientType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.buildings.structures.NexusManager;
import org.kingdoms.managers.mails.DraftMail;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.item.ItemNBT;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cooldown.BiCooldown;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.MapUtil;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.internal.uuid.FastUUID;
import org.kingdoms.utils.nms.XBook;
import org.kingdoms.utils.time.TimeFormatter;

public final class MailUserAgent
implements Listener {
    private static final String MAILS_NBT = "Mail";
    private static final Cooldown<UUID> TOTAL_COOLDOWN = new Cooldown();
    private static final BiCooldown<UUID, UUID> KINGDOM_TO_KINGDOM_COOLDOWN = new BiCooldown();

    @EventHandler
    public void onMailProperties(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (XMaterial.matchXMaterial((ItemStack)item) != XMaterial.WRITABLE_BOOK) {
            return;
        }
        DraftMail mail = MailUserAgent.getDraftMail(item);
        if (mail == null) {
            return;
        }
        player.getInventory().setItemInMainHand(null);
        MailUserAgent.openMailProperties(player, mail);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSign(PlayerEditBookEvent event) {
        if (!event.isSigning()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = PlayerUtils.getHotbarItem(player, event.getSlot());
        DraftMail draft = MailUserAgent.getDraftMail(item);
        if (draft == null) {
            return;
        }
        if (draft.getSubject() == null || draft.getSubject().isEmpty()) {
            KingdomsLang.MAILS_SEND_MISSING_SUBJECT.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (draft.getRecipientsOfType(MailRecipientType.PRIMARY).isEmpty()) {
            KingdomsLang.MAILS_SEND_MISSING_PRIMARY_RECIPIENT.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    static String buildCCOf(List<Group> cc) {
        if (cc.isEmpty()) {
            return KingdomsLang.MAILS_CC_NONE.parse(new Object[0]);
        }
        StringBuilder builder = new StringBuilder();
        String sep = KingdomsLang.MAILS_CC_SEPARATOR.parse(new Object[0]);
        int index = 0;
        int len = cc.size();
        for (Group group : cc) {
            builder.append(KingdomsLang.MAILS_CC_EACH.parse("cc", group == null ? KingdomsLang.UNKNOWN : group.getName()));
            if (++index == len) continue;
            builder.append(sep);
        }
        return builder.toString();
    }

    public static InteractiveGUI openMailProperties(Player player, DraftMail mail) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.MAILS_EDITOR, MailUserAgent.getMailEdits(mail));
        if (gui == null) {
            return null;
        }
        gui.push("subject", () -> {
            KingdomsLang.MAILS_SUBJECT_ENTER.sendMessage((CommandSender)player);
            gui.startConversation("subject");
        }, input -> {
            String compiled;
            int limit = KingdomsConfig.MAILS_SUBJECT_LIMIT.getManager().getInt();
            boolean ignoreColors = KingdomsConfig.MAILS_SUBJECT_IGNORE_COLORS.getManager().getBoolean();
            if (ignoreColors) {
                MessageObject messageObjectBuilder = MessageCompiler.compile(input, new MessageCompilerSettings(false, true, true, false, false, null));
                MessagePlaceholderProvider settings = new MessagePlaceholderProvider().ignoreColors();
                compiled = messageObjectBuilder.buildPlain(settings);
            } else {
                compiled = input;
            }
            int len = compiled.length();
            if (len > limit) {
                KingdomsLang.MAILS_SUBJECT_LIMIT.sendError((CommandSender)player, "limit", limit);
                return;
            }
            if (compiled.toLowerCase(Locale.ENGLISH).contains("erratas")) {
                XSound.AMBIENT_CAVE.record().soundPlayer().forPlayers(new Player[]{player}).play();
                MessageHandler.sendPluginMessage((CommandSender)player, "&6O Fortuna, ky2khlqdf7qdznac.\u2591, bipolar interneuron yields&4 17&0-13-55-1 &6because of trees with wings.");
                gui.endConversation();
                return;
            }
            mail.setSubject((String)input);
            KingdomsLang.MAILS_SUBJECT_CHANGED.sendMessage((CommandSender)player, "subject", input);
            gui.endConversation();
            MailUserAgent.openMailProperties(player, mail);
        }, new Object[0]);
        gui.push("recipients", () -> MailUserAgent.openRecipients(player, mail, () -> MailUserAgent.openMailProperties(player, mail)), new Object[0]);
        gui.push("reset", () -> {
            mail.setSubject(null);
            mail.getMessage().clear();
            mail.getRecipientsRaw().clear();
            MailUserAgent.openMailProperties(player, mail);
            KingdomsLang.MAILS_CLEARED_PROPERTIES.sendMessage((CommandSender)player);
        }, new Object[0]);
        gui.push("preview", () -> {
            player.closeInventory();
            ItemStack book = MailUserAgent.preview(player, mail);
            XBook.openBook(book, player);
        }, new Object[0]);
        gui.onClose(() -> {
            if (gui.wasSwitched()) {
                return;
            }
            ItemStack item = MailUserAgent.generateEnvelope(player, mail);
            XItemStack.addItems((Inventory)player.getInventory(), (boolean)false, (ItemStack[])new ItemStack[]{item});
        });
        gui.open();
        return gui;
    }

    public static InteractiveGUI openRecipients(Player player, DraftMail mail, Runnable back) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.MAILS_RECIPIENTS, MailUserAgent.getMailEdits(mail));
        if (gui == null) {
            return null;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        gui.push("to", () -> {
            KingdomsLang.MAILS_TO_ENTER.sendMessage((CommandSender)player);
            gui.startConversation("to");
        }, input -> {
            Kingdom toKingdom = Kingdom.getKingdom(input);
            if (toKingdom == null) {
                KingdomsLang.NOT_FOUND_KINGDOM.sendError((CommandSender)player, "kingdom", input);
                return;
            }
            if (toKingdom.getId().equals(kp.getKingdomId())) {
                KingdomsLang.MAILS_TO_YOURSELF.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (mail.getRecipientsRaw().containsKey(toKingdom.getId())) {
                KingdomsLang.MAILS_ALREADY_RECIPIENT.sendError((CommandSender)player, new Object[0]);
                return;
            }
            MailUserAgent.removeLastPrimaryRecipient(mail);
            mail.getRecipientsRaw().put(toKingdom.getId(), MailRecipientType.PRIMARY);
            gui.endConversation();
            MailUserAgent.openRecipients(player, mail, back);
        }, new Object[0]);
        ReusableOptionHandler ccOpt = gui.getReusableOption("cc");
        List<Group> cc = mail.getRecipientsOfType(MailRecipientType.CC);
        for (Group group : cc) {
            ccOpt.setEdits("singular-cc", group.getName()).onNormalClicks(() -> {
                KingdomsLang.MAILS_CC_REMOVED.sendMessage((CommandSender)player, "recipient", group.getName());
                mail.getRecipientsRaw().remove(group.getId());
                MailUserAgent.openRecipients(player, mail, back);
            }).done();
            if (ccOpt.hasNext()) continue;
            break;
        }
        gui.option("cc-add").onNormalClicks(context -> {
            KingdomsLang.MAILS_CC_ENTER.sendMessage((CommandSender)player);
            context.startConversation();
        }).setConversation(input -> {
            Kingdom toKingdom = Kingdom.getKingdom(input);
            if (toKingdom == null) {
                KingdomsLang.NOT_FOUND_KINGDOM.sendError((CommandSender)player, "kingdom", input);
                return;
            }
            if (toKingdom.getId().equals(kp.getKingdomId())) {
                KingdomsLang.MAILS_TO_YOURSELF.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (mail.getRecipientsRaw().containsKey(toKingdom.getId())) {
                KingdomsLang.MAILS_ALREADY_RECIPIENT.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (mail.getRecipientsOfType(MailRecipientType.CC).size() >= 5) {
                KingdomsLang.MAILS_CC_MAX.sendError((CommandSender)player, "limit", 5);
                return;
            }
            mail.getRecipientsRaw().put(toKingdom.getId(), MailRecipientType.CC);
            MailUserAgent.openRecipients(player, mail, back);
        }).done();
        gui.onClose(() -> {
            if (gui.wasSwitched()) {
                return;
            }
            ItemStack item = MailUserAgent.generateEnvelope(player, mail);
            XItemStack.addItems((Inventory)player.getInventory(), (boolean)false, (ItemStack[])new ItemStack[]{item});
        });
        gui.push("back", back, new Object[0]);
        gui.open();
        return gui;
    }

    static void removeLastPrimaryRecipient(DraftMail mail) {
        Iterator<MailRecipientType> it = mail.getRecipientsRaw().values().iterator();
        while (it.hasNext()) {
            MailRecipientType type = it.next();
            if (type != MailRecipientType.PRIMARY) continue;
            it.remove();
            return;
        }
    }

    static MessagePlaceholderProvider getMailEdits(DraftMail mail) {
        Group to = mail.getTo();
        return new MessagePlaceholderProvider().parse("subject", Strings.isNullOrEmpty((String)mail.getSubject()) ? KingdomsLang.MAILS_SUBJECT_EMPTY.parse(new Object[0]) : mail.getSubject()).raw("to", to == null ? KingdomsLang.MAILS_PRIMARY_NONE.parse(new Object[0]) : to.getName()).parse("cc", MailUserAgent.buildCCOf(mail.getRecipientsOfType(MailRecipientType.CC))).raw("replied-id", mail.getInReplyTo()).parse("summary", MailUserAgent.getSummaryOf(mail.getMessage()));
    }

    static MessagePlaceholderProvider createSettings(Player sender, DraftMail mail) {
        return MailUserAgent.getMailEdits(mail).withContext(sender);
    }

    static String getSummaryOf(List<String> message) {
        if (org.kingdoms.utils.string.Strings.areElementsEmpty(message)) {
            return KingdomsLang.MAILS_CONTENT_EMPTY.parse(new Object[0]);
        }
        int summaryLimit = KingdomsConfig.MAILS_SUMMARY_LIMIT.getManager().getInt();
        String summary = message.get(0);
        return summary.substring(0, Math.min(summaryLimit, summary.length())) + "...";
    }

    public static InteractiveGUI getMailbox(Player player, Kingdom kingdom, Consumer<InteractiveGUI> modifications) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!NexusManager.hasPermission(StandardKingdomPermission.READ_MAILS, kp, kingdom, true) && !NexusManager.hasPermission(StandardKingdomPermission.MANAGE_MAILS, kp, kingdom, true)) {
            StandardKingdomPermission.READ_MAILS.sendDeniedMessage(player);
            return null;
        }
        long envelopeRpCost = (long)MathUtils.eval(KingdomsConfig.MAILS_ENVELOPE_RESOURCE_POINTS.getManager().getString(), kingdom, new Object[0]);
        double moneyCost = MathUtils.eval(KingdomsConfig.MAILS_ENVELOPE_MONEY.getManager().getString(), kingdom, new Object[0]);
        InventoryInteractiveGUI gui = (InventoryInteractiveGUI)new GUIBuilder(KingdomsGUI.MAILS_MAILBOX).withSettings(new MessagePlaceholderProvider().raw("envelope-cost-resource-points", Numbers.toFancyNumber(envelopeRpCost)).raw("envelope-cost-money", Numbers.toFancyNumber(moneyCost)).raw("page", 1).raw("pages", 1)).inventoryGUIOnly().forPlayer(player).build();
        if (gui == null) {
            return null;
        }
        gui.push("get-envelope", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.MANAGE_MAILS)) {
                StandardKingdomPermission.MANAGE_MAILS.sendDeniedMessage(player);
                return;
            }
            int slot = player.getInventory().firstEmpty();
            if (slot < 0) {
                KingdomsLang.MAILS_ENVELOPE_NO_FREE_SLOT.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (!kp.isAdmin()) {
                Object[] costEdits = new Object[]{"rp", Numbers.toFancyNumber(envelopeRpCost), "money", Numbers.toFancyNumber(moneyCost)};
                if (!kingdom.getResourcePoints().has(envelopeRpCost)) {
                    KingdomsLang.MAILS_ENVELOPE_NOT_ENOUGH_RESOURCES.sendError((CommandSender)player, costEdits);
                    return;
                }
                if (SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.ECO) && !kingdom.getBank().has(moneyCost)) {
                    KingdomsLang.MAILS_ENVELOPE_NOT_ENOUGH_RESOURCES.sendError((CommandSender)player, costEdits);
                    return;
                }
                kingdom.getResourcePoints().add(-envelopeRpCost);
                kingdom.getBank().add(-moneyCost);
            }
            player.getInventory().setItem(slot, MailUserAgent.generateEnvelope(player, new DraftMail(kingdom)));
            KingdomsLang.MAILS_ENVELOPE_GIVE.sendMessage((CommandSender)player);
            player.closeInventory();
        }, new Object[0]);
        ReusableOptionHandler sentOption = gui.getReusableOption("sent");
        for (Mail mail : kingdom.getSentMails()) {
            OfflinePlayer sender = mail.getPlayerSender();
            MailUserAgent.getEditsForMail(sentOption.getMessageContext(), mail);
            sentOption.getMessageContext().raw("read", !kp.isUnreadMail(mail));
            sentOption.onNormalClicks(() -> MailUserAgent.openMail(kingdom, player, mail)).pushHead(sender);
            if (sentOption.hasNext()) continue;
            break;
        }
        ReusableOptionHandler inboxOption = gui.getReusableOption("inbox");
        for (Mail mail : kingdom.getReceivedMails()) {
            OfflinePlayer sender = mail.getPlayerSender();
            MailUserAgent.getEditsForMail(inboxOption.getMessageContext(), mail);
            sentOption.getMessageContext().raw("read", !kp.isUnreadMail(mail));
            inboxOption.onNormalClicks(() -> MailUserAgent.openMail(kingdom, player, mail)).pushHead(sender);
            if (inboxOption.hasNext()) continue;
            break;
        }
        gui.onDelayedInteractableSlot(event -> {
            List<ItemStack> items = gui.getInteractableItems();
            if (items.isEmpty()) {
                return;
            }
            ItemStack item = items.get(0);
            DraftMail mail = MailUserAgent.getDraftMail(item);
            if (mail == null) {
                KingdomsLang.MAILS_NOT_AN_ENVELOPE.sendError((CommandSender)player, new Object[0]);
                gui.returnItems();
                return;
            }
            if (mail.getSubject() == null) {
                KingdomsLang.MAILS_SEND_MISSING_SUBJECT.sendError((CommandSender)player, new Object[0]);
                gui.returnItems();
                return;
            }
            if (mail.getRecipientsOfType(MailRecipientType.PRIMARY).isEmpty()) {
                KingdomsLang.MAILS_SEND_MISSING_PRIMARY_RECIPIENT.sendError((CommandSender)player, new Object[0]);
                gui.returnItems();
                return;
            }
            if (!kp.hasPermission(StandardKingdomPermission.MANAGE_MAILS)) {
                StandardKingdomPermission.MANAGE_MAILS.sendDeniedMessage(player);
                gui.returnItems();
                return;
            }
            if (org.kingdoms.utils.string.Strings.areElementsEmpty(mail.getMessage())) {
                KingdomsLang.MAILS_SEND_MISSING_CONTENT.sendError((CommandSender)player, new Object[0]);
                gui.returnItems();
                return;
            }
            long totalCd = TOTAL_COOLDOWN.getTimeLeft(kingdom.getId());
            if (totalCd > 0L) {
                KingdomsLang.MAILS_SEND_TOTAL_COOLDOWN.sendError((CommandSender)player, "cooldown", TimeFormatter.of(totalCd));
                gui.returnItems();
                return;
            }
            Group toGroup = mail.getRecipientsOfType(MailRecipientType.PRIMARY).get(0);
            long perKingdomCd = KINGDOM_TO_KINGDOM_COOLDOWN.getTimeLeft(kingdom.getId(), toGroup.getId());
            if (perKingdomCd > 0L) {
                KingdomsLang.MAILS_SEND_PER_GROUP_COOLDOWN.sendError((CommandSender)player, "kingdom", toGroup.getName(), "cooldown", TimeFormatter.of(perKingdomCd));
                gui.returnItems();
                return;
            }
            MailUserAgent.sendMail(player, mail);
            InteractiveGUI mailbox = MailUserAgent.getMailbox(player, kingdom, modifications);
            if (mailbox != null) {
                mailbox.open();
            }
        });
        modifications.accept(gui);
        return gui;
    }

    public static void sendMail(Player sender, DraftMail draft) {
        Mail mail = draft.getFromGroup().sendMail(sender, draft);
        if (mail == null) {
            return;
        }
        MessagePlaceholderProvider settings = MailUserAgent.getEditsForMail(mail).withContext(sender);
        for (Group group : draft.getRecipients().keySet()) {
            for (Player onlineMember : group.getOnlineMembers()) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)onlineMember);
                if (!kp.hasPermission(StandardKingdomPermission.READ_MAILS)) continue;
                KingdomsLang.MAILS_NOTIFICATIONS_RECEIVERS.sendMessage((CommandSender)onlineMember, settings);
            }
        }
    }

    public static MessagePlaceholderProvider getEditsForMail(Mail mail) {
        return MailUserAgent.getEditsForMail(new MessagePlaceholderProvider(), mail);
    }

    public static MessagePlaceholderProvider getEditsForMail(MessagePlaceholderProvider builder, Mail mail) {
        UUID to = mail.getRecipientsOfType(MailRecipientType.PRIMARY).get(0);
        Kingdom fromGroup = Kingdom.getKingdom(mail.getFromGroup());
        Kingdom toGroup = Kingdom.getKingdom(to);
        List<UUID> cc = mail.getRecipientsOfType(MailRecipientType.CC);
        List<Group> parsedCC = cc.stream().map(Kingdom::getKingdom).filter(Objects::nonNull).collect(Collectors.toList());
        return builder.raw("id", mail.getId()).raw("sender", mail.getPlayerSender().getName()).raw("from", fromGroup == null ? KingdomsLang.UNKNOWN : fromGroup.getName()).parse("subject", mail.getSubject()).parse("summary", MailUserAgent.getSummaryOf(mail.getMessage())).raw("to", toGroup == null ? KingdomsLang.UNKNOWN : toGroup.getName()).parse("cc", MailUserAgent.buildCCOf(parsedCC)).raw("sent", mail.getTime());
    }

    static ItemMeta setEnvelopeDescription(ItemStack item, boolean replying, MessagePlaceholderProvider settings) {
        XItemStack.edit((ItemStack)item, (ConfigurationSection)(replying ? KingdomsConfig.MAILS_ENVELOPE_REPLY_ITEM : KingdomsConfig.MAILS_ENVELOPE_ITEM).getManager().getSection().toBukkitConfigurationSection(), Function.identity(), null);
        ItemMeta meta = item.getItemMeta();
        ItemUtil.translate(meta, settings);
        return meta;
    }

    public static ItemStack generateEnvelopeInReplyTo(Player sender, Group fromGroup, Mail replyingMail, Class<? extends Group> communicationProtocol) {
        String subject = KingdomsLang.MAILS_REPLY_SUBJECT_FORMATTER.parse("subject", replyingMail.getSubject());
        Map<UUID, MailRecipientType> recipients = MapUtil.clone(replyingMail.getRecipients(), (k, v) -> v);
        DraftMail draft = new DraftMail(fromGroup, new ArrayList<String>(), subject, recipients, replyingMail.getId(), communicationProtocol);
        return MailUserAgent.generateEnvelope(sender, draft);
    }

    public static ItemStack generateEnvelope(Player sender, DraftMail draft) {
        ItemStack mail = XMaterial.WRITTEN_BOOK.parseItem();
        BookMeta meta = (BookMeta)MailUserAgent.setEnvelopeDescription(mail, draft.getInReplyTo() != null, MailUserAgent.createSettings(sender, draft));
        meta.setAuthor(sender.getName());
        if (!draft.getMessage().isEmpty()) {
            meta.setPages(draft.getMessage());
        }
        mail.setItemMeta((ItemMeta)meta);
        NBTTagCompound nbt = ItemNBT.getTag(mail);
        NBTTagCompound mailsContainer = NBTTagCompound.empty();
        NBTTagCompound nbtContainer = NBTTagCompound.empty();
        nbtContainer.set("FromGroup", FastUUID.toString(draft.getFromGroup().getId()));
        nbtContainer.set("GroupType", draft.getFromGroup().getClass().getName());
        nbtContainer.set("Created", System.currentTimeMillis());
        nbtContainer.set("Recipients", NBTTagCompound.empty());
        if (draft.getSubject() != null) {
            nbtContainer.set("Subject", draft.getSubject());
        }
        if (!draft.getRecipientsRaw().isEmpty()) {
            NBTTagCompound recipientsNbt = NBTTagCompound.empty();
            for (Map.Entry<UUID, MailRecipientType> recipient : draft.getRecipientsRaw().entrySet()) {
                recipientsNbt.set(FastUUID.toString(recipient.getKey()), recipient.getValue().name());
            }
            nbtContainer.set("Recipients", recipientsNbt);
        }
        mailsContainer.set(MAILS_NBT, nbtContainer);
        nbt.set("Kingdoms", mailsContainer);
        return ItemNBT.setTag(mail, nbt);
    }

    private static DraftMail getDraftMail(ItemStack mail) {
        Class<?> groupType;
        NBTTagCompound nbt = ItemNBT.getTag(mail);
        NBTTagCompound kingdomsCompound = nbt.tryGetTag("Kingdoms", NBTTagType.COMPOUND);
        if (kingdomsCompound == null) {
            return null;
        }
        NBTTagCompound mailCompound = kingdomsCompound.tryGetTag(MAILS_NBT, NBTTagType.COMPOUND);
        if (mailCompound == null) {
            return null;
        }
        UUID fromGroup = FastUUID.fromString((CharSequence)mailCompound.get("FromGroup", NBTTagType.STRING));
        String groupTypeName = (String)mailCompound.get("GroupType", NBTTagType.STRING);
        try {
            groupType = Class.forName(groupTypeName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        boolean isKingdoms = groupType == Kingdom.class;
        Group group = isKingdoms ? Kingdom.getKingdom(fromGroup) : Nation.getNation(fromGroup);
        String subject = mailCompound.getString("Subject");
        String replyTo = mailCompound.getString("ReplyTo");
        UUID inReplyTo = replyTo == null ? null : FastUUID.fromString(replyTo);
        ArrayList<String> message = new ArrayList<String>(((BookMeta)mail.getItemMeta()).getPages());
        HashMap<UUID, MailRecipientType> recipients = new HashMap<UUID, MailRecipientType>();
        NBTTagCompound recipientsNbt = mailCompound.getTag("Recipients", NBTTagType.COMPOUND);
        for (Map.Entry recipient : recipientsNbt.value().entrySet()) {
            UUID recipientId = FastUUID.fromString((CharSequence)recipient.getKey());
            MailRecipientType recipientType = MailRecipientType.valueOf(String.valueOf(((NBTTag)recipient.getValue()).value()));
            recipients.put(recipientId, recipientType);
        }
        return new DraftMail(group, message, subject, recipients, inReplyTo, groupType);
    }

    public static ItemStack getMailItem(CachedMail mail, boolean sent) {
        ItemStack draftItem = XMaterial.WRITTEN_BOOK.parseItem();
        BookMeta meta = (BookMeta)draftItem.getItemMeta();
        meta.setTitle(mail.getSubject());
        meta.setAuthor(mail.getSender().getName());
        @NonNull List<Group> to = mail.getRecipientsOfType(MailRecipientType.PRIMARY);
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().raw("id", mail.getId() == null ? "none" : FastUUID.toString(mail.getId())).parse("subject", mail.getSubject()).raw("sent", mail.getSent()).raw("sender", mail.getSender().getName()).raw("from", mail.getFromGroup().getName()).raw("to", to.isEmpty() ? KingdomsLang.NONE : (to.get(0) == null ? KingdomsLang.UNKNOWN : to.get(0).getName())).parse("cc", MailUserAgent.buildCCOf(mail.getRecipientsOfType(MailRecipientType.CC)));
        ArrayList<BaseComponent[]> pages = new ArrayList<BaseComponent[]>(meta.getPageCount());
        BaseComponent[] header = (sent ? KingdomsLang.MAILS_HEADER_FORMAT_SENT : KingdomsLang.MAILS_HEADER_FORMAT_RECEIVED).getProvider(Language.getDefault()).getMessage().buildComplex(settings).createSingular();
        pages.add(header);
        for (String page : mail.getMessage()) {
            BaseComponent[] msg = MessageCompiler.compile(page, new MessageCompilerSettings(false, true, true, false, true, null)).buildComplex(new MessagePlaceholderProvider()).createSingular();
            pages.add(msg);
        }
        meta.spigot().setPages(pages);
        draftItem.setItemMeta((ItemMeta)meta);
        return draftItem;
    }

    public static void openMail(Group fromGroup, Player player, Mail mail) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        kp.readMail(mail);
        ItemStack book = MailUserAgent.getMailItem(mail.toCached(GroupResolver.KINGDOMS_RESOLVER), mail.getFromGroup().equals(fromGroup.getId()));
        XBook.openBook(book, player);
    }

    public static ItemStack preview(Player sender, DraftMail draft) {
        return MailUserAgent.getMailItem(new CachedMail(null, draft.getFromGroup(), (OfflinePlayer)sender, draft.getMessage(), System.currentTimeMillis(), draft.getSubject(), draft.getRecipients(), draft.getInReplyTo() == null ? null : Mail.getMail(draft.getInReplyTo())), true);
    }
}

