/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.mails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.mails.MailRecipientType;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public class DraftMail {
    private final Group fromGroup;
    private final List<String> message;
    private String subject;
    private final Map<UUID, MailRecipientType> recipients;
    private UUID inReplyTo;
    private final Class<? extends Group> communicatonProtocol;

    public DraftMail(Group fromGroup, List<String> message, String subject, Map<UUID, MailRecipientType> recipients, UUID inReplyTo, Class<? extends Group> communicatonProtocol) {
        this.fromGroup = fromGroup;
        this.message = message;
        this.subject = subject;
        this.recipients = recipients;
        this.inReplyTo = inReplyTo;
        this.communicatonProtocol = communicatonProtocol;
    }

    public DraftMail(Group fromGroup) {
        this(fromGroup, new ArrayList<String>(), null, new HashMap<UUID, MailRecipientType>(), null, fromGroup.getClass());
    }

    public Group getTo() {
        List<Group> primary = this.getRecipientsOfType(MailRecipientType.PRIMARY);
        if (primary.isEmpty()) {
            return null;
        }
        return primary.get(0);
    }

    public Group getFromGroup() {
        return this.fromGroup;
    }

    public Mail getRepliedMail() {
        return this.inReplyTo == null ? null : Mail.getMail(this.inReplyTo);
    }

    public @NonNull Map<UUID, MailRecipientType> getRecipientsRaw() {
        return this.recipients;
    }

    public @NonNull Map<Group, MailRecipientType> getRecipients() {
        if (this.recipients == null) {
            return new HashMap<Group, MailRecipientType>();
        }
        NonNullMap<Group, MailRecipientType> recipients = new NonNullMap<Group, MailRecipientType>(this.recipients.size());
        Iterator<Map.Entry<UUID, MailRecipientType>> iter = this.recipients.entrySet().iterator();
        while (iter.hasNext()) {
            Group group;
            Map.Entry<UUID, MailRecipientType> recipient = iter.next();
            UUID id = recipient.getKey();
            Group group2 = group = this.communicatonProtocol == Kingdom.class ? Kingdom.getKingdom(id) : Nation.getNation(id);
            if (group == null) {
                iter.remove();
                continue;
            }
            recipients.put(group, recipient.getValue());
        }
        return recipients;
    }

    public Class<? extends Group> getCommunicatonProtocol() {
        return this.communicatonProtocol;
    }

    public @NonNull List<Group> getRecipientsOfType(MailRecipientType type) {
        ArrayList<Group> ids = new ArrayList<Group>(type == MailRecipientType.PRIMARY ? 1 : 5);
        for (Map.Entry<Group, MailRecipientType> recipient : this.getRecipients().entrySet()) {
            if (recipient.getValue() != type) continue;
            ids.add(recipient.getKey());
        }
        return ids;
    }

    public @Nullable UUID getInReplyTo() {
        return this.inReplyTo;
    }

    public void setInReplyTo(UUID inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public @NonNull List<String> getMessage() {
        return this.message;
    }
}

