/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.logger.gui;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.logger.gui.AuditLogFilter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/managers/logger/gui/AuditLogPlayerFilter;", "Lorg/kingdoms/managers/logger/gui/AuditLogFilter;", "player", "Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "getPlayer", "()Ljava/util/UUID;", "include", "", "log", "Lorg/kingdoms/constants/group/model/logs/AuditLog;", "addEdits", "", "builder", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "core"})
public final class AuditLogPlayerFilter
implements AuditLogFilter {
    @NotNull
    private final UUID player;

    public AuditLogPlayerFilter(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
    }

    @NotNull
    public final UUID getPlayer() {
        return this.player;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean include(@NotNull AuditLog log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        if (!(log instanceof PlayerOperator)) return false;
        KingdomPlayer kingdomPlayer = ((PlayerOperator)((Object)log)).getPlayer();
        if (!Intrinsics.areEqual((Object)(kingdomPlayer != null ? kingdomPlayer.getId() : null), (Object)this.player)) return false;
        return true;
    }

    @Override
    public void addEdits(@NotNull MessagePlaceholderProvider builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.raw("filters_player_name", Bukkit.getOfflinePlayer((UUID)this.player).getName());
    }
}

