/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.logger;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.lands.LogKingdomClaim;
import org.kingdoms.constants.group.model.logs.lands.LogKingdomInvaded;
import org.kingdoms.constants.group.model.logs.lands.LogKingdomInvader;
import org.kingdoms.constants.group.model.logs.lands.LogKingdomUnclaim;
import org.kingdoms.constants.group.model.logs.misc.LogGroupServerTaxPay;
import org.kingdoms.constants.group.model.logs.misc.LogGroupShieldPurchaseEvent;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomChampionChange;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomInvite;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomJoin;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomKick;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomKingChange;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomLeave;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomPacifismStateChange;
import org.kingdoms.constants.group.model.logs.misc.LogKingdomResourcePointsConvert;
import org.kingdoms.constants.group.model.logs.misc.LogNexusMove;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogPlayerRankChange;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankChangeColor;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankChangeMaterial;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankChangeMaxClaims;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankChangeName;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankChangePriority;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankChangeSymbol;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankCreate;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankDelete;
import org.kingdoms.constants.group.model.logs.misc.relations.LogKingdomRelationshipChangeEvent;
import org.kingdoms.constants.group.model.logs.misc.renames.LogKingdomChangeLore;
import org.kingdoms.constants.group.model.logs.misc.renames.LogKingdomChangeTag;
import org.kingdoms.constants.group.model.logs.misc.renames.LogKingdomRename;
import org.kingdoms.constants.group.model.logs.nations.LogKingdomNationJoin;
import org.kingdoms.constants.group.model.logs.nations.LogKingdomNationLeave;
import org.kingdoms.constants.group.model.logs.purchases.LogExtractorCollect;
import org.kingdoms.constants.group.model.logs.purchases.LogKingdomUpgrade;
import org.kingdoms.constants.group.model.logs.purchases.LogKingdomUpgradeChampion;
import org.kingdoms.constants.group.model.logs.purchases.LogKingdomUpgradeMisc;
import org.kingdoms.constants.group.model.logs.purchases.LogKingdomUpgradePowerup;
import org.kingdoms.constants.group.model.logs.purchases.LogOutpostItemPurchase;
import org.kingdoms.constants.group.model.logs.purchases.LogWarppadTeleport;
import org.kingdoms.constants.group.model.logs.purchases.kingdomitem.LogKingdomItemPurchase;
import org.kingdoms.constants.group.model.logs.purchases.kingdomitem.LogTurretPurchaseAmmo;
import org.kingdoms.constants.group.model.logs.purchases.kingdomitem.LogUpgradeStructure;
import org.kingdoms.constants.group.model.logs.purchases.kingdomitem.LogUpgradeTurret;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.Extractor;
import org.kingdoms.constants.land.structures.objects.WarpPad;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.stats.DefaultStats;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.events.general.ChampionChangeEvent;
import org.kingdoms.events.general.GroupRelationshipChangeEvent;
import org.kingdoms.events.general.GroupRenameEvent;
import org.kingdoms.events.general.GroupRenameTagEvent;
import org.kingdoms.events.general.GroupResourcePointConvertEvent;
import org.kingdoms.events.general.GroupServerTaxPayEvent;
import org.kingdoms.events.general.GroupShieldPurchaseEvent;
import org.kingdoms.events.general.KingdomCreateEvent;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.general.KingdomInviteEvent;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.events.general.KingdomLoreChangeEvent;
import org.kingdoms.events.general.KingdomPacifismStateChangeEvent;
import org.kingdoms.events.general.nation.NationCreateEvent;
import org.kingdoms.events.general.nation.NationDisbandEvent;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.general.ranks.RankColorChangeEvent;
import org.kingdoms.events.general.ranks.RankCreateEvent;
import org.kingdoms.events.general.ranks.RankDeleteEvent;
import org.kingdoms.events.general.ranks.RankMaterialChangeEvent;
import org.kingdoms.events.general.ranks.RankMaxClaimsChangeEvent;
import org.kingdoms.events.general.ranks.RankNameChangeEvent;
import org.kingdoms.events.general.ranks.RankPriorityChangeEvent;
import org.kingdoms.events.general.ranks.RankSymbolChangeEvent;
import org.kingdoms.events.general.upgrade.KingdomChampionUpgradeUpgradeEvent;
import org.kingdoms.events.general.upgrade.KingdomMiscUpgradeUpgradeEvent;
import org.kingdoms.events.general.upgrade.KingdomPowerupUpgradeEvent;
import org.kingdoms.events.general.upgrade.KingdomUpgradeUpgradeEvent;
import org.kingdoms.events.general.upgrade.UpgradeEvent;
import org.kingdoms.events.invasion.KingdomInvadeEndEvent;
import org.kingdoms.events.invasion.KingdomInvadeEvent;
import org.kingdoms.events.items.KingdomBuildingUpgradeEvent;
import org.kingdoms.events.items.structures.ExtractorCollectEvent;
import org.kingdoms.events.items.structures.OutpostPurchaseItemEvent;
import org.kingdoms.events.items.structures.WarpPadTeleportEvent;
import org.kingdoms.events.items.turrets.TurretAmmoFillEvent;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.events.masswar.MassWarEndEvent;
import org.kingdoms.events.masswar.MassWarStartEvent;
import org.kingdoms.events.members.KingdomJoinEvent;
import org.kingdoms.events.members.KingdomKickEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.events.members.NationJoinEvent;
import org.kingdoms.events.members.NationLeaveEvent;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.logger.BulkKingdomItemPurchaseLogCollector;
import org.kingdoms.managers.logger.BulkLogCollector;
import org.kingdoms.managers.logger.BulkOutpostItemPurchaseLogCollector;
import org.kingdoms.managers.logger.BulkUpgradeLogCollector;
import org.kingdoms.managers.logger.KingdomsLogger;
import org.kingdoms.utils.time.TimeUtils;

public final class LogAndStatsManager
implements Listener {
    public static final Namespace DONT_LOG_NAMESPACE = Namespace.kingdoms("DONT_LOG");
    private static final Map<UUID, Map<Class<?>, Map<Object, BulkLogCollector>>> BULK_COLLECTOR = new HashMap();
    private static final long COLLECTOR_TIME_LIMIT = TimeUtils.millisToTicks(Duration.ofSeconds(5L).toMillis());

    public static void dontLog(KingdomsEvent event) {
        event.getMetadata().put(DONT_LOG_NAMESPACE, (Object)true);
    }

    public static boolean log(KingdomsEvent event) {
        Object obj = event.getMetadata(DONT_LOG_NAMESPACE);
        if (obj == null) {
            return true;
        }
        if (!(obj instanceof Boolean)) {
            return true;
        }
        return (Boolean)obj == false;
    }

    private static void log(String log) {
        KingdomsLogger.getMain().log(log);
    }

    @EventHandler
    public void onKingdomCreate(KingdomCreateEvent event) {
        KingdomPlayer owner = event.getKingdom().getKing();
        if (owner == null) {
            LogAndStatsManager.log("A server-managed kingdom named " + event.getKingdom().getName() + " was created.");
        } else {
            LogAndStatsManager.log("A kingdom named " + event.getKingdom().getName() + " has been created for " + owner.getOfflinePlayer().getName());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomCreate(KingdomDisbandEvent event) {
        LogAndStatsManager.log(event.getKingdom().getName() + " has been disbanded for " + event.getReason().name());
    }

    @EventHandler
    public void onNationCreate(NationCreateEvent event) {
        LogAndStatsManager.log("A nation named " + event.getNation().getName() + " has been created with capital " + event.getNation().getCapital().getName());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onNationDisband(NationDisbandEvent event) {
        LogAndStatsManager.log(event.getNation().getName() + " has been disbanded for " + event.getReason().name());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomMemberJoin(KingdomJoinEvent event) {
        OfflinePlayer player = event.getPlayer().getOfflinePlayer();
        KingdomInvite invite = (KingdomInvite)event.getMetadata(KingdomInvite.NAMESPACE);
        Kingdom kingdom = event.getKingdom();
        LogAndStatsManager.log(player.getName() + " has joined " + kingdom.getName() + " kingdom.");
        kingdom.getStatistics().inc(DefaultStats.Kingdom.MEMBERS_TOTAL);
        if (LogAndStatsManager.log(event)) {
            kingdom.log(new LogKingdomJoin(player.getUniqueId(), invite == null ? null : invite.getSender()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomMemberLeave(KingdomLeaveEvent event) {
        if (event.getReason() == LeaveReason.KICKED) {
            return;
        }
        OfflinePlayer player = event.getPlayer().getOfflinePlayer();
        Kingdom kingdom = event.getPlayer().getKingdom();
        LogAndStatsManager.log(player.getName() + " has left " + kingdom.getName() + " kingdom for " + event.getReason().name());
        if (LogAndStatsManager.log(event)) {
            kingdom.log(new LogKingdomLeave(player.getUniqueId(), event.getReason()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomMemberLeave(KingdomKickEvent event) {
        OfflinePlayer player = event.getPlayer().getOfflinePlayer();
        Kingdom kingdom = event.getPlayer().getKingdom();
        if (LogAndStatsManager.log(event)) {
            kingdom.log(new LogKingdomKick(player.getUniqueId(), event.getReason(), event.getKicker().getUniqueId()));
        }
        LogAndStatsManager.log(player.getName() + " has been kicked out of " + kingdom.getName() + " kingdom by " + event.getKicker().getName());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onClaimEvent(ClaimLandEvent event) {
        if (event.getReason() == ClaimLandEvent.Reason.INVASION) {
            return;
        }
        UUID player = event.getPlayer() == null ? null : event.getPlayer().getId();
        Kingdom kingdom = event.getKingdom();
        kingdom.getStatistics().inc(DefaultStats.Kingdom.LANDS_TOTAL, event.getLandLocations().size());
        if (LogAndStatsManager.log(event)) {
            kingdom.log(new LogKingdomClaim(player, event.getLandLocations()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onunClaimEvent(UnclaimLandEvent event) {
        if (event.getReason() == UnclaimLandEvent.Reason.INVASION) {
            return;
        }
        UUID player = event.getPlayer() == null ? null : event.getPlayer().getId();
        Kingdom kingdom = event.getKingdom();
        if (LogAndStatsManager.log(event)) {
            kingdom.log(new LogKingdomUnclaim(player, event.getLandLocations()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomJoinNation(NationJoinEvent event) {
        Kingdom kingdom = event.getKingdom();
        if (LogAndStatsManager.log(event)) {
            kingdom.log(new LogKingdomNationJoin(event.getNation().getId()));
        }
        LogAndStatsManager.log(event.getKingdom().getName() + " kingdom has joined " + event.getNation().getName() + " nation.");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomLeaveNation(NationLeaveEvent event) {
        Kingdom kingdom = event.getKingdom();
        if (LogAndStatsManager.log(event)) {
            kingdom.log(new LogKingdomNationLeave(event.getNation().getId()));
        }
        LogAndStatsManager.log(event.getKingdom().getName() + " kingdm has left " + event.getNation().getName() + " nation for " + event.getReason().name());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void masswarStart(MassWarStartEvent event) {
        LogAndStatsManager.log("Masswar has started");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void masswarEnd(MassWarEndEvent event) {
        LogAndStatsManager.log("Masswar has ended");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInvade(KingdomInvadeEvent event) {
        Invasion invasion = event.getInvasion();
        SimpleChunkLocation origin = SimpleChunkLocation.of(invasion.getStartLocation());
        LogAndStatsManager.log(invasion.getInvaderPlayer().getName() + " from " + invasion.getAttacker().getName() + " kingdom has started invading " + invasion.getDefender().getName() + " kingdom at " + origin.getWorld() + ", " + origin.getX() + origin.getZ());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRpDonate(GroupResourcePointConvertEvent event) {
        Group group = event.getGroup();
        if (!(group instanceof Kingdom)) {
            return;
        }
        if (LogAndStatsManager.log(event)) {
            group.log(new LogKingdomResourcePointsConvert(event.getKingdomPlayer().getId(), group.getResourcePoints().get(), group.getResourcePoints().get() + event.getAmount()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomRename(GroupRenameEvent event) {
        Group group = event.getGroup();
        if (!(group instanceof Kingdom)) {
            return;
        }
        if (LogAndStatsManager.log(event)) {
            group.log(new LogKingdomRename(event.getPlayer().getId(), event.getOldName(), event.getNewName()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLoreChange(KingdomLoreChangeEvent event) {
        Group group = event.getGroup();
        if (!(group instanceof Kingdom)) {
            return;
        }
        if (LogAndStatsManager.log(event)) {
            group.log(new LogKingdomChangeLore(event.getPlayer().getId(), event.getOldLore(), event.getNewLore()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLoreChange(GroupRenameTagEvent event) {
        Group group = event.getGroup();
        if (!(group instanceof Kingdom)) {
            return;
        }
        if (LogAndStatsManager.log(event)) {
            group.log(new LogKingdomChangeTag(event.getPlayer().getId(), event.getOldTag(), event.getNewTag()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onNexusMove(NexusMoveEvent event) {
        if (((StructureType)((StructureStyle)event.getNewStructure().getStyle()).getType()).isNationalNexus()) {
            return;
        }
        KingdomPlayer kp = event.getPlayer();
        if (kp == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (LogAndStatsManager.log(event)) {
            kingdom.log(new LogNexusMove(kp.getId(), event.getFrom(), event.getTo()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMiscUpgradeUpgrade(KingdomMiscUpgradeUpgradeEvent event) {
        LogAndStatsManager.handleUpgrade(event, collector -> new LogKingdomUpgradeMisc(collector.getResourcePointsCost(), event.getUpgrade(), event.getPlayer().getId(), collector.getOldLevel(), collector.getNewLevel()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPacifismStateChange(KingdomPacifismStateChangeEvent event) {
        Kingdom kingdom = event.getKingdom();
        KingdomPlayer kp = event.getPlayer();
        if (kp == null) {
            return;
        }
        kingdom.log(new LogKingdomPacifismStateChange(kp.getId(), event.isPacifist()));
        LogAndStatsManager.log(kp.getOfflinePlayer().getName() + " has changed their kingdom " + kingdom.getName() + " pacifism state: " + event.isPacifist());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPacifismStateChange(GroupRelationshipChangeEvent event) {
        if (event.getFirst() instanceof Kingdom) {
            Kingdom first = (Kingdom)event.getFirst();
            Kingdom second = (Kingdom)event.getSecond();
            KingdomRelation oldRelation = first.getRelationWith(second);
            first.log(new LogKingdomRelationshipChangeEvent(second, oldRelation, event.getNewRelation()));
            second.log(new LogKingdomRelationshipChangeEvent(first, oldRelation, event.getNewRelation()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onShieldPurchase(GroupShieldPurchaseEvent event) {
        if (!(event.getGroup() instanceof Kingdom)) {
            return;
        }
        Kingdom kingdom = (Kingdom)event.getGroup();
        kingdom.log(new LogGroupShieldPurchaseEvent(event.getPlayer().getId(), kingdom.getShield().getTimeLeft().toMillis(), kingdom.getShield().getTimeLeft().toMillis() + event.getShieldDuration(), event.getResourcePointsCost()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingChange(KingdomKingChangeEvent event) {
        Kingdom kingdom = event.getKingdom();
        kingdom.log(new LogKingdomKingChange(kingdom.getKingId(), event.getNewKing().getId(), event.getReason()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankChange(PlayerRankChangeEvent event) {
        Group group = event.getGroup();
        KingdomPlayer byPlayer = event.getByPlayer();
        if (byPlayer == null) {
            return;
        }
        group.log(new LogPlayerRankChange(event.getPlayer(), event.getOldRank(), event.getRank(), byPlayer.getId()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInvite(KingdomInviteEvent event) {
        event.getKingdom().log(new LogKingdomInvite(event.getPlayer().getId(), event.getInviter().getId(), event.getAcceptTime()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankCreate(RankCreateEvent event) {
        event.getGroup().log(new LogRankCreate(event.getPlayer(), event.getRank()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankDelete(RankDeleteEvent event) {
        event.getGroup().log(new LogRankDelete(event.getPlayer(), event.getRank()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankNameChange(RankNameChangeEvent event) {
        event.getGroup().log(new LogRankChangeName(event.getPlayer(), event.getRank(), event.getNewName()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankSymbolChange(RankSymbolChangeEvent event) {
        event.getGroup().log(new LogRankChangeSymbol(event.getPlayer(), event.getRank(), event.getNewSymbol()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankColorChange(RankColorChangeEvent event) {
        event.getGroup().log(new LogRankChangeColor(event.getPlayer(), event.getRank(), event.getNewColor()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankPriorityChange(RankPriorityChangeEvent event) {
        event.getGroup().log(new LogRankChangePriority(event.getPlayer(), event.getRank(), event.getNewPriority()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankMaxClaimsChange(RankMaxClaimsChangeEvent event) {
        event.getGroup().log(new LogRankChangeMaxClaims(event.getPlayer(), event.getRank(), event.getNewMaxClaims()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankMaterialChange(RankMaterialChangeEvent event) {
        event.getGroup().log(new LogRankChangeMaterial(event.getPlayer(), event.getRank(), event.getNewMaterial()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onChampionUpgradeUpgrade(KingdomChampionUpgradeUpgradeEvent event) {
        LogAndStatsManager.handleUpgrade(event, collector -> new LogKingdomUpgradeChampion(collector.getResourcePointsCost(), event.getUpgrade(), event.getPlayer().getId(), collector.getOldLevel(), collector.getNewLevel()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPowerupUpgradeUpgrade(KingdomPowerupUpgradeEvent event) {
        LogAndStatsManager.handleUpgrade(event, collector -> new LogKingdomUpgradePowerup(collector.getResourcePointsCost(), event.getUpgrade(), event.getPlayer().getId(), collector.getOldLevel(), collector.getNewLevel()));
    }

    private static void handleUpgrade(KingdomUpgradeUpgradeEvent event, Function<BulkUpgradeLogCollector, LogKingdomUpgrade> logger) {
        LogAndStatsManager.handleUpgrade(event.getGroup(), event, event.getUpgrade(), logger);
    }

    private static void handleUpgrade(Group group, UpgradeEvent event, Object upgradeIdentifier, Function<BulkUpgradeLogCollector, LogKingdomUpgrade> logger) {
        if (!LogAndStatsManager.log(event)) {
            return;
        }
        Map playerCollectors = BULK_COLLECTOR.computeIfAbsent(event.getPlayer().getId(), k -> new HashMap());
        Map classCollectors = playerCollectors.computeIfAbsent(event.getClass(), k -> new HashMap());
        BulkUpgradeLogCollector collector = (BulkUpgradeLogCollector)classCollectors.computeIfAbsent(upgradeIdentifier, k -> new BulkUpgradeLogCollector(event.getOldLevel()));
        collector.setNewLevel(event.getNewLevel());
        collector.addResourcePointCost(event.getResourcePointsCost());
        collector.setTask(COLLECTOR_TIME_LIMIT, () -> {
            classCollectors.remove(upgradeIdentifier);
            group.log((AuditLog)logger.apply(collector));
        });
    }

    public static void handlePurchase(Group group, LogKingdomItemPurchase event, Function<BulkKingdomItemPurchaseLogCollector, LogKingdomItemPurchase> logger) {
        String identifier = event.getStyle().getName();
        Map playerCollectors = BULK_COLLECTOR.computeIfAbsent(event.getPlayerId(), k -> new HashMap());
        Map classCollectors = playerCollectors.computeIfAbsent(event.getClass(), k -> new HashMap());
        BulkKingdomItemPurchaseLogCollector collector = (BulkKingdomItemPurchaseLogCollector)classCollectors.computeIfAbsent(identifier, k -> new BulkKingdomItemPurchaseLogCollector());
        collector.addAmount(event.getAmount());
        collector.addResourcePointCost(event.getResourcePoints());
        collector.setTask(COLLECTOR_TIME_LIMIT, () -> {
            classCollectors.remove(identifier);
            group.log((AuditLog)logger.apply(collector));
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurretUpgrade(KingdomBuildingUpgradeEvent event) {
        Function<BulkUpgradeLogCollector, LogKingdomUpgrade> logger;
        KingdomBuilding<?> item = event.getBuilding();
        if (item instanceof Turret) {
            logger = collector -> new LogUpgradeTurret(collector.getResourcePointsCost(), event.getPlayer().getId(), collector.getOldLevel(), collector.getNewLevel(), item.getOrigin(), null, (KingdomBuildingStyle<?, ?, ?>)item.getStyle());
        } else if (item instanceof Structure) {
            logger = collector -> new LogUpgradeStructure(collector.getResourcePointsCost(), event.getPlayer().getId(), collector.getOldLevel(), collector.getNewLevel(), item.getOrigin(), ((Structure)item).getDisplayName(), (KingdomBuildingStyle<?, ?, ?>)item.getStyle());
        } else {
            return;
        }
        LogAndStatsManager.handleUpgrade(item.getLand().getKingdom(), event, item.getOrigin(), logger);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurretAmmo(TurretAmmoFillEvent event) {
        if (!LogAndStatsManager.log(event)) {
            return;
        }
        Kingdom kingdom = event.getBuilding().getLand().getKingdom();
        RangedTurret turret = (RangedTurret)event.getBuilding();
        kingdom.log(new LogTurretPurchaseAmmo(event.getCost(), event.getPlayer() == null ? null : event.getPlayer().getId(), event.getFillType(), turret.getOrigin(), (TurretStyle)turret.getStyle(), turret.getAmmo(), event.getAmount()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onChampionTypeChange(ChampionChangeEvent event) {
        if (!LogAndStatsManager.log(event)) {
            return;
        }
        event.getKingdom().log(new LogKingdomChampionChange(event.getPlayer() == null ? null : event.getPlayer().getId(), event.getOldType(), event.getOldType()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onServerTax(GroupServerTaxPayEvent event) {
        if (!LogAndStatsManager.log(event)) {
            return;
        }
        Group group = event.getGroup();
        if (!(group instanceof Kingdom)) {
            return;
        }
        group.log(new LogGroupServerTaxPay(event.getAmount()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onWarpPadTeleport(WarpPadTeleportEvent event) {
        if (!LogAndStatsManager.log(event)) {
            return;
        }
        WarpPad warpPad = event.getBuilding();
        Land land = warpPad.getLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        kingdom.log(new LogWarppadTeleport(event.getPlayer().getId(), warpPad.getOrigin(), event.getToItem().getOrigin(), event.getLocation(), event.getFuelCost()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onOutpostItemPurchase(OutpostPurchaseItemEvent event) {
        if (!LogAndStatsManager.log(event)) {
            return;
        }
        KingdomBuilding<?> item = event.getItem();
        KingdomPlayer kp = event.getPlayer();
        SimpleLocation identifier = item.getOrigin();
        Map playerCollectors = BULK_COLLECTOR.computeIfAbsent(kp.getId(), k -> new HashMap());
        Map classCollectors = playerCollectors.computeIfAbsent(event.getClass(), k -> new HashMap());
        BulkOutpostItemPurchaseLogCollector collector = (BulkOutpostItemPurchaseLogCollector)classCollectors.computeIfAbsent(identifier, k -> new BulkOutpostItemPurchaseLogCollector());
        collector.add(event.getPurchase());
        collector.setTask(COLLECTOR_TIME_LIMIT, () -> {
            classCollectors.remove(identifier);
            Kingdom kingdom = item.getLand().getKingdom();
            double totalResourcePoints = 0.0;
            for (LogOutpostItemPurchase.Purchase purchase : collector.purchases.values()) {
                totalResourcePoints += purchase.getResourcePointsCost();
            }
            kingdom.log(new LogOutpostItemPurchase(item.getOrigin(), totalResourcePoints, event.getPlayer().getId(), collector.purchases));
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onExtractorCollect(ExtractorCollectEvent event) {
        if (!LogAndStatsManager.log(event)) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        Extractor extractor = event.getItem();
        Land land = extractor.getLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        kingdom.log(new LogExtractorCollect(extractor.getCollectedResourcePoints(), event.getPlayer().getId(), extractor.getOrigin()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInvade(KingdomInvadeEndEvent event) {
        if (!LogAndStatsManager.log(event)) {
            return;
        }
        Invasion invasion = event.getInvasion();
        SimpleChunkLocation origin = SimpleChunkLocation.of(invasion.getStartLocation());
        boolean successful = invasion.getResult().isSuccessful();
        Kingdom defender = invasion.getDefender();
        Kingdom attacker = invasion.getAttacker();
        defender.getStatistics().inc(DefaultStats.Kingdom.INVASIONS_GOT_INVADED);
        attacker.getStatistics().inc(DefaultStats.Kingdom.INVASIONS_INVADED);
        if (successful) {
            defender.getStatistics().inc(DefaultStats.Kingdom.INVASIONS_GOT_INVADED_LOST);
            attacker.getStatistics().inc(DefaultStats.Kingdom.INVASIONS_INVADED_WON);
        }
        defender.log(new LogKingdomInvaded(invasion));
        attacker.log(new LogKingdomInvader(invasion));
        LogAndStatsManager.log(invasion.getInvaderPlayer().getName() + " from " + attacker.getName() + " invasion with " + defender.getName() + " kingdom at " + origin.getWorld() + ", " + origin.getX() + origin.getZ() + " result: " + invasion.getResult().name());
    }
}

