/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.server.inventory.InventorySlot;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.string.StringMatcher;

public interface PlayerInventoryMatcher {
    public void match(PlayerInventory var1, Map<Integer, ItemStack> var2);

    public static Map<Integer, ItemStack> getMatchedItems(PlayerInventory inventory, PlayerInventoryMatcher matcher) {
        HashMap<Integer, ItemStack> matched = new HashMap<Integer, ItemStack>(10);
        matcher.match(inventory, matched);
        return matched;
    }

    public static PlayerInventoryMatcher parse(ConfigSection section) {
        List<String> items;
        int random;
        ArrayList<PlayerInventoryMatcher> matchers = new ArrayList<PlayerInventoryMatcher>(5);
        if (section.getBoolean("armor")) {
            matchers.add(MappedSlots.ARMOR);
        }
        if (section.getBoolean("off-hand")) {
            matchers.add(MappedSlots.OFF_HAND);
        }
        if (section.getBoolean("main-hand")) {
            matchers.add(Hand.MAIN_HAND);
        }
        if (section.getBoolean("hotbar")) {
            matchers.add(MappedSlots.HOTBAR);
        }
        if ((random = section.getInt("random")) > 0) {
            matchers.add(new Random(random));
        }
        if (!(items = section.getStringList("items")).isEmpty()) {
            matchers.add(new Items(StringMatcher.parseAndGroup(items)));
        }
        return new Aggregate(matchers.toArray(new PlayerInventoryMatcher[0]));
    }

    public static final class MappedSlots
    implements PlayerInventoryMatcher {
        private static final PlayerInventoryMatcher ARMOR = new MappedSlots(InventorySlot.Player.ARMOR);
        private static final PlayerInventoryMatcher HOTBAR = new MappedSlots(InventorySlot.Player.HOTBAR);
        private static final PlayerInventoryMatcher OFF_HAND = new MappedSlots(InventorySlot.Player.OFFHAND);
        private final InventorySlot slots;

        public MappedSlots(InventorySlot slots) {
            this.slots = slots;
        }

        @Override
        public void match(PlayerInventory inventory, Map<Integer, ItemStack> matchedItems) {
            for (int slot : this.slots.getSlots()) {
                ItemStack item = inventory.getItem(slot);
                if (!ItemUtil.notNull(item)) continue;
                matchedItems.put(slot, item.clone());
            }
        }
    }

    public static final class Hand
    implements PlayerInventoryMatcher {
        private static final PlayerInventoryMatcher MAIN_HAND = new Hand();

        @Override
        public void match(PlayerInventory inventory, Map<Integer, ItemStack> matchedItems) {
            matchedItems.put(inventory.getHeldItemSlot(), inventory.getItemInMainHand().clone());
        }
    }

    public static final class Random
    implements PlayerInventoryMatcher {
        private final int slotAmount;

        public Random(int slotAmount) {
            this.slotAmount = slotAmount;
        }

        @Override
        public void match(PlayerInventory inventory, Map<Integer, ItemStack> matchedItems) {
            ItemStack[] contents = inventory.getContents();
            ArrayList<Pair<Integer, ItemStack>> itemsToKeep = new ArrayList<Pair<Integer, ItemStack>>(contents.length);
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item2 = contents[i];
                if (!ItemUtil.notNull(item2)) continue;
                itemsToKeep.add(Pair.of(i, item2));
            }
            Collections.shuffle(itemsToKeep);
            itemsToKeep.stream().limit(this.slotAmount).forEach(item -> matchedItems.put((Integer)item.getKey(), ((ItemStack)item.getValue()).clone()));
        }
    }

    public static final class Items
    implements PlayerInventoryMatcher {
        private final StringMatcher matcher;

        public Items(StringMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public void match(PlayerInventory inventory, Map<Integer, ItemStack> matchedItems) {
            ItemStack[] contents = inventory.getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (ItemUtil.isNull(item) || !this.matcher.matches(XMaterial.matchXMaterial((ItemStack)item).name())) continue;
                matchedItems.put(i, item.clone());
            }
        }
    }

    public static final class Aggregate
    implements PlayerInventoryMatcher {
        private final PlayerInventoryMatcher[] matchers;

        public Aggregate(PlayerInventoryMatcher[] matchers) {
            this.matchers = matchers;
        }

        @Override
        public void match(PlayerInventory inventory, Map<Integer, ItemStack> matchedItems) {
            for (PlayerInventoryMatcher matcher : this.matchers) {
                matcher.match(inventory, matchedItems);
            }
        }
    }
}

