/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.managers.land.protection.PlayerInventoryMatcher;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.cooldown.BiCooldown;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.internal.string.StringMatcher;
import org.kingdoms.utils.time.TimeUtils;

public final class MiscUpgradeManager
implements Listener {
    private static final Material SOIL = XMaterial.FARMLAND.parseMaterial();
    private static final Map<UUID, Integer> INVASION_COOLDOWN = new HashMap<UUID, Integer>();
    private static final Map<UUID, Cooldown<UUID>> GLORY_COOLDOWN = new HashMap<UUID, Cooldown<UUID>>();
    private static final BiCooldown<UUID, UUID> ALERTS = new BiCooldown();

    private static void addGloryCooldown(Player killer, Player victim) {
        Cooldown killerCooldowns = GLORY_COOLDOWN.computeIfAbsent(killer.getUniqueId(), k -> new Cooldown());
        killerCooldowns.add(victim.getUniqueId(), Duration.ofMinutes(5L));
    }

    private static boolean isInGloryCooldown(Player killer, Player victim) {
        Cooldown<UUID> killerCooldowns = GLORY_COOLDOWN.get(killer.getUniqueId());
        if (killerCooldowns == null) {
            return false;
        }
        return killerCooldowns.isInCooldown(victim.getUniqueId());
    }

    public static long getInvadeRefreshCd(Kingdom kingdom) {
        String eqn = MiscUpgrade.INVASIONS.getConfig().getString("refresh-cooldown");
        return (long)MathUtils.eval(eqn, kingdom, "lvl", kingdom.getUpgradeLevel(MiscUpgrade.INVASIONS));
    }

    public static boolean canPlaceItemInKingdomChest(ItemStack item) {
        ConfigSection config = MiscUpgrade.CHEST_SIZE.getConfig().getSection().getSection("items");
        if (config == null) {
            return true;
        }
        boolean blacklist = config.getBoolean("blacklist");
        for (ConfigSection itemConfig : config.getSection("list").getSections().values()) {
            ItemMatcher matcher = new ItemMatcher(itemConfig);
            if (matcher.matches(item) != blacklist) continue;
            return false;
        }
        return true;
    }

    public static void invaded(Kingdom attacker) {
        if (!MiscUpgrade.INVASIONS.isEnabled()) {
            return;
        }
        INVASION_COOLDOWN.compute(attacker.getId(), (k, v) -> v == null ? 1 : v + 1);
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> INVASION_COOLDOWN.computeIfPresent(attacker.getId(), (k, v) -> v - 1), TimeUtils.millisToTicks(MiscUpgradeManager.getInvadeRefreshCd(attacker)));
    }

    public static Map<UUID, Integer> getInvasionCooldown() {
        return INVASION_COOLDOWN;
    }

    public static boolean canInvade(Kingdom attacker) {
        if (!MiscUpgrade.INVASIONS.isEnabled()) {
            return true;
        }
        Integer count = INVASION_COOLDOWN.get(attacker.getId());
        if (count == null) {
            return true;
        }
        return (double)count.intValue() < MiscUpgrade.INVASIONS.getScaling(attacker);
    }

    public static void onEnemyEnterAlert(LandChangeEvent event) {
        Player player = event.getPlayer();
        if (ServiceHandler.isVanished(player)) {
            return;
        }
        KingdomPlayer kp = event.getKingdomPlayer();
        if (kp.isAdmin()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        Land to = event.getToLand();
        if (to == null || !to.isClaimed()) {
            return;
        }
        Kingdom toKingdom = to.getKingdom();
        if (kingdom.getRelationWith(toKingdom) != KingdomRelation.ENEMY) {
            return;
        }
        if (toKingdom.isClaimed(event.getFromChunk())) {
            return;
        }
        if (ALERTS.isInCooldown(toKingdom.getId(), kp.getId())) {
            return;
        }
        ALERTS.add(toKingdom.getId(), kp.getId(), 1L, TimeUnit.MINUTES);
        Location loc = player.getLocation();
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().raws("world", loc.getWorld().getName(), "x", loc.getBlockX(), "y", loc.getBlockY(), "z", loc.getBlockZ());
        for (Player member : toKingdom.getOnlineMembers()) {
            KingdomsLang.MISC_UPGRADES_ALERTS_NOTIFY_MEMBERS.sendMessage((CommandSender)member, settings.withContext(player));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCropTrample(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block.getType() != SOIL) {
            return;
        }
        if (!MiscUpgrade.ANTI_TRAMPLE.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        Land land = Land.getLand(block);
        if (land == null || !land.isClaimed()) {
            return;
        }
        if (land.getKingdom().getUpgradeLevel(MiscUpgrade.ANTI_TRAMPLE) > 0) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onGlory(EntityDeathEvent event) {
        if (!MiscUpgrade.GLORY.isEnabled()) {
            return;
        }
        LivingEntity victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer == null) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)killer)) {
            return;
        }
        Land land = Land.getLand(victim.getLocation());
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        int lvl = kingdom.getUpgradeLevel(MiscUpgrade.GLORY);
        if (lvl <= 0) {
            return;
        }
        int drop = event.getDroppedExp();
        if (victim instanceof Player && MiscUpgradeManager.isInGloryCooldown(killer, (Player)victim)) {
            return;
        }
        ConfigSection xpSection = MiscUpgrade.GLORY.getConfig().gotoSection("xp").getSection();
        MessagePlaceholderProvider context = new MessagePlaceholderProvider().withContext(killer).raw("xp", event.getDroppedExp()).raw("lvl", lvl);
        if (victim instanceof Player) {
            context.other((Player)victim);
        }
        for (String cond : xpSection.getKeys()) {
            context.raw("type", victim.getType().name());
            if (!ConditionProcessor.process(ConditionalCompiler.compile(cond).evaluate(), context)) continue;
            drop = (int)MathUtils.eval(xpSection.getMathExpression(cond), (PlaceholderProvider)context);
        }
        if (victim instanceof Player) {
            MiscUpgradeManager.addGloryCooldown(killer, (Player)victim);
        }
        event.setDroppedExp(drop);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPearlTeleport(PlayerTeleportEvent event) {
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Land toLand = Land.getLand(event.getTo());
        if (toLand == null || !toLand.isClaimed()) {
            return;
        }
        Kingdom toLandKingdom = toLand.getKingdom();
        if (toLandKingdom.getUpgradeLevel(MiscUpgrade.ANTI_TRAMPLE) < 3) {
            return;
        }
        Kingdom playerKingdom = kp.getKingdom();
        if (!StandardRelationAttribute.CEASEFIRE.hasAttribute(toLandKingdom, playerKingdom) || !StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(toLandKingdom, playerKingdom)) {
            event.setCancelled(true);
            ParticleDisplay.of((XParticle)XParticle.CLOUD).withCount(10).spawn(event.getTo());
            KingdomsLang.LANDS_ENDER_PEARL_PROTECTION.sendError((CommandSender)player, new Object[0]);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        MiscUpgradeManager.keepInventoryUpgrade(event);
        MiscUpgradeManager.resourcePointPenalty(player);
    }

    private static void keepInventoryUpgrade(PlayerDeathEvent event) {
        if (event.getKeepInventory()) {
            return;
        }
        if (!MiscUpgrade.KEEP_INVENTORY.isEnabled()) {
            return;
        }
        Player player = event.getEntity();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (!kingdom.isClaimed(SimpleChunkLocation.of(player.getLocation()))) {
            return;
        }
        int keepInv = kingdom.getUpgradeLevel(MiscUpgrade.KEEP_INVENTORY);
        if (keepInv <= 0) {
            return;
        }
        ConfigSection levelSection = MiscUpgrade.KEEP_INVENTORY.getConfig().getSection().getSection("levels", String.valueOf(keepInv));
        EntityDamageEvent lastDmg = player.getLastDamageCause();
        if (lastDmg != null) {
            String deathCause = lastDmg.getCause().name();
            if (StringMatcher.parseAndGroup(levelSection.getStringList("blacklisted-causes")).matches(deathCause)) {
                return;
            }
        }
        PlayerInventoryMatcher matcher = PlayerInventoryMatcher.parse(levelSection);
        Map<Integer, ItemStack> keptItems = PlayerInventoryMatcher.getMatchedItems(player.getInventory(), matcher);
        Iterator dropIter = event.getDrops().iterator();
        Collection<ItemStack> keptItemVal = keptItems.values();
        while (dropIter.hasNext()) {
            ItemStack drop = (ItemStack)dropIter.next();
            if (!keptItemVal.stream().anyMatch(x -> x.isSimilar(drop))) continue;
            dropIter.remove();
        }
        if (event.getDrops().isEmpty()) {
            event.setKeepInventory(true);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
                PlayerInventory inv = player.getInventory();
                for (Map.Entry item : keptItems.entrySet()) {
                    inv.setItem(((Integer)item.getKey()).intValue(), (ItemStack)item.getValue());
                }
            }, 1L);
        }
    }

    private static void resourcePointPenalty(Player player) {
        if (!KingdomsConfig.ResourcePoints.DEATH_PENALTY_DISABLED_WORLDS.getManager().isInDisabledWorld((Entity)player)) {
            EntityDamageEvent lastDamageCause = player.getLastDamageCause();
            if (lastDamageCause != null && KingdomsConfig.ResourcePoints.DEATH_PENALTY_DISABLED_CAUSES.getManager().getStringList().contains(lastDamageCause.getCause().name())) {
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return;
            }
            long penalty = (long)MathUtils.eval(KingdomsConfig.ResourcePoints.DEATH_PENALTY_AMOUNT.getManager().getString(), (OfflinePlayer)player, new Object[0]);
            if (penalty == 0L) {
                return;
            }
            if (kingdom.getResourcePoints().has(penalty)) {
                kingdom.getResourcePoints().add(-penalty);
                Object[] edits = new Object[]{"penalty", Numbers.toFancyNumber(penalty), "name", player.getName()};
                for (Player member : kingdom.getOnlineMembers()) {
                    KingdomsLang.DEATH_PENALTY.sendMessage((CommandSender)member, (OfflinePlayer)player, edits);
                }
            }
        }
    }
}

