/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;

public final class LandPistonManager
implements Listener {
    private static void handlePiston(BlockPistonEvent event, List<Block> blocks) {
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(event.getBlock())) {
            return;
        }
        boolean disabled = !MiscUpgrade.ANTI_TRAMPLE.isEnabled();
        Block piston = event.getBlock();
        SimpleChunkLocation pistonChunk = SimpleChunkLocation.of(piston);
        Land pistonLand = pistonChunk.getLand();
        Kingdom pistonKingdom = pistonLand == null ? null : pistonLand.getKingdom();
        for (Block block : blocks) {
            Kingdom kingdom;
            SimpleLocation location = SimpleLocation.of(block);
            SimpleChunkLocation chunk = location.toSimpleChunkLocation();
            Land land = Land.getLand(chunk);
            if (land == null) continue;
            if (land.isKingdomBlock(location.toBlockVector())) {
                event.setCancelled(true);
                return;
            }
            if (disabled || pistonChunk.equalsIgnoreWorld(chunk) || (kingdom = land.getKingdom()) == null || StandardRelationAttribute.BUILD.hasAttribute(pistonKingdom, kingdom) || kingdom.getUpgradeLevel(MiscUpgrade.ANTI_TRAMPLE) <= 1) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        LandPistonManager.handlePiston((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        ArrayList<Block> blocks = new ArrayList<Block>(event.getBlocks());
        blocks.add(event.getBlock().getRelative(event.getDirection(), blocks.size() + 1));
        LandPistonManager.handlePiston((BlockPistonEvent)event, blocks);
    }
}

