/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import java.time.Duration;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.KingdomsInventory;
import org.kingdoms.constants.group.model.logs.lands.inventory.LogKingdomVaultInventoryChange;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.inventory.IndividualInventoryWatcher;
import org.kingdoms.managers.inventory.InventoryItemAction;
import org.kingdoms.managers.inventory.InventoryWatcher;
import org.kingdoms.managers.inventory.InventoryWatcherListener;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.server.inventory.InventoryView;

public final class KingdomVaultManager
implements Listener {
    public static final Namespace KINGDOM_VAULT_NS = Namespace.kingdoms("KINGDOMS_VAULT");

    public static KingdomsInventory createKingdomVault(Kingdom sourceKingdom, Inventory inventory) {
        return new KingdomsInventory(KINGDOM_VAULT_NS, sourceKingdom.getId(), inventory);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory openInv = InventoryView.of(player.getOpenInventory()).getTopInventory();
        if (event.getClickedInventory() == openInv) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        KingdomsInventory kOpenInv = KingdomsInventory.getKingdomInvenotry(openInv);
        if (kOpenInv == null) {
            return;
        }
        if (!kOpenInv.getNamespace().equals(KINGDOM_VAULT_NS)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        if (!MiscUpgradeManager.canPlaceItemInKingdomChest(clicked)) {
            KingdomsLang.VAULT_BLACKLISTED_ITEM.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    static {
        InventoryWatcher.registerListener(new VaultLogListener());
    }

    private static final class VaultLogListener
    extends InventoryWatcherListener {
        public VaultLogListener() {
            super(Duration.ofMinutes(1L));
        }

        @Override
        public void onExpire(@NotNull IndividualInventoryWatcher watcher) {
            List<InventoryItemAction> changes = watcher.evaluateEvents();
            if (changes.isEmpty()) {
                return;
            }
            LogKingdomVaultInventoryChange log = new LogKingdomVaultInventoryChange(watcher.getPlayer().getUniqueId(), changes);
            KingdomsInventory kInv = KingdomsInventory.getKingdomInvenotry(watcher.getInventory());
            Kingdom owner = Kingdom.getKingdom((UUID)kInv.getSourceObject());
            if (owner == null) {
                return;
            }
            owner.log(log);
        }

        @Override
        public boolean shouldWatchGUI(@NotNull Inventory watcher) {
            return KingdomsInventory.isKingdomInvenotry(watcher);
        }
    }
}

