/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.map;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.map.ClipboardKingdomsMapElement;
import org.kingdoms.managers.land.map.KingdomsMapElement;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.utils.Compass;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.display.scoreboard.XScoreboard;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.kingdoms.NationZone;

public class KingdomsMap {
    public static final Map<UUID, XScoreboard> SCOREBOARDS = NonNullMap.of(new ConcurrentHashMap());
    private Player player;
    private KingdomPlayer kp;
    private Kingdom kpKingdom;
    private int height = 5;
    private int width = 5;
    private final String beginMain = KingdomsConfig.Map.BEGIN.getManager().getString();
    private final String distanceMain = KingdomsConfig.Map.DISTANCE.getManager().getString();
    private SimpleChunkLocation center;
    public String property;
    public SimpleChunkLocation chunk;
    public Structure structure;
    public Land land;
    public Kingdom kingdom;
    public NationZone nationZone;
    private boolean showHidden;
    private final MessagePlaceholderProvider settings = new MessagePlaceholderProvider();
    private static final List<KingdomsMapElement> REGISTERED_ELEMENTS = new ArrayList<KingdomsMapElement>();
    private final List<KingdomsMapElement> elements = new ArrayList<KingdomsMapElement>();
    private static final Namespace SCOREBOARD_ID = Namespace.kingdoms("MAP");

    public static void registerElement(KingdomsMapElement handler) {
        Objects.requireNonNull(handler);
        REGISTERED_ELEMENTS.add(handler);
    }

    public KingdomsMap() {
        this.elements.addAll(REGISTERED_ELEMENTS);
    }

    public MessagePlaceholderProvider getSettings() {
        return this.settings;
    }

    public KingdomsMap setSize(int height, int width) {
        this.height = height;
        this.width = width;
        return this;
    }

    private void setSizeByPlayer(Player player) {
        int width;
        int height;
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Pair<Integer, Integer> mapSize = kp.getMapSize();
        if (mapSize == null) {
            height = KingdomsConfig.Map.HEIGHT.getManager().getInt();
            width = KingdomsConfig.Map.WIDTH.getManager().getInt();
        } else {
            height = mapSize.getKey();
            width = mapSize.getValue();
        }
        this.setSize(height, width);
    }

    public KingdomsMap clipboardMode() {
        this.elements.add(new ClipboardKingdomsMapElement(this.player));
        return this;
    }

    public KingdomsMap addElement(String propertyName, Set<SimpleChunkLocation> chunks) {
        this.elements.add(map -> chunks.contains(map.chunk) ? propertyName : null);
        return this;
    }

    public KingdomsMap forPlayer(Player player) {
        this.player = Objects.requireNonNull(player, "Cannot show map to null player");
        this.kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        this.kpKingdom = this.kp.getKingdom();
        this.center = SimpleChunkLocation.of(player.getLocation());
        this.showHidden = KingdomsDefaultPluginPermission.SHOW_HIDDEN_GROUPS.hasPermission((CommandSender)player);
        this.settings.raw("compass", Compass.translateCardinalDirection(player));
        this.settings.raw("translated-world", LocationUtils.translateWorld(player.getWorld().getName()));
        this.settings.withContext(player);
        this.setSizeByPlayer(player);
        return this;
    }

    void setCurrentState(SimpleChunkLocation chunk) {
        this.chunk = chunk;
        this.land = chunk.getLand();
        this.kingdom = this.land == null || !this.land.isClaimed() ? null : this.land.getKingdom();
    }

    void resetCurrentState() {
        this.chunk = null;
        this.land = null;
        this.kingdom = null;
        this.nationZone = null;
        this.structure = null;
        this.property = null;
    }

    private String processChunk() {
        this.structure = null;
        for (KingdomsMapElement element : this.elements) {
            String prop = element.getElement(this);
            if (prop == null) continue;
            return prop;
        }
        if (this.chunk.equalsIgnoreWorld(this.center)) {
            return "you";
        }
        if (this.kingdom == null || !this.showHidden && this.kingdom.isHidden() && !this.kingdom.isMember(this.kp)) {
            this.nationZone = Land.getNationZone(this.chunk);
            if (!(this.nationZone == null || this.showHidden && this.nationZone.getNation().isHidden() && this.nationZone.getNation().isMember(this.kp))) {
                KingdomRelation relation;
                if (this.kpKingdom == null) {
                    relation = KingdomRelation.NEUTRAL;
                } else {
                    relation = this.nationZone.getKingdom().getRelationWith(this.kpKingdom);
                    if (relation == KingdomRelation.NATION) {
                        relation = KingdomRelation.SELF;
                    }
                }
                return "nation-zone." + relation.name().toLowerCase(Locale.ENGLISH);
            }
            return "wilderness";
        }
        if (this.land.isBeingInvaded()) {
            return "invasion";
        }
        String property = null;
        if (this.land.getStructures().isEmpty()) {
            property = "land";
        } else {
            int lastPriority = Integer.MAX_VALUE;
            for (Structure struct : this.land.getStructures().values()) {
                StructureType type = (StructureType)((StructureStyle)struct.getStyle()).getType();
                String tempProp = type.getName().toLowerCase(Locale.ENGLISH);
                ConfigSection section = KingdomsConfig.MAP.getConfig().getSection("elements", tempProp);
                int priority = section.getInt("priority");
                if (priority < lastPriority) {
                    property = tempProp;
                    this.structure = struct;
                    lastPriority = priority;
                }
                if (priority != 1) continue;
                break;
            }
            Objects.requireNonNull(property);
        }
        KingdomRelation relation = this.kpKingdom == null ? KingdomRelation.NEUTRAL : this.kingdom.getRelationWith(this.kpKingdom);
        return property + '.' + relation.name().toLowerCase(Locale.ENGLISH);
    }

    public void displayAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), this::display);
    }

    public void display() {
        this.displayHeader();
        this.process();
        this.displayFooter();
    }

    private static MessageObject getHeaderMessage(KingdomsConfig.Map config) {
        return MessageCompiler.compile(config.getManager().getString());
    }

    public static boolean isUsingScoreboard(Player player) {
        return SCOREBOARDS.containsKey(player.getUniqueId());
    }

    private void currentChunkSettings() {
        BlockVector2 xz = this.chunk.toLocationXZ();
        this.settings.raw("loc_x", xz.getX()).raw("loc_z", xz.getZ()).raw("X", this.chunk.getX()).raw("Z", this.chunk.getZ());
        if (this.kingdom != null) {
            this.settings.other(this.kingdom);
        } else if (this.nationZone != null) {
            this.settings.other(PlaceholderTarget.of(this.nationZone.getNation()));
        }
    }

    public void displayAsScoreboard() {
        XScoreboard scoreboard = SCOREBOARDS.get(this.player.getUniqueId());
        if (scoreboard == null) {
            scoreboard = new XScoreboard(SCOREBOARD_ID, new StaticMessenger(KingdomsMap.getHeaderMessage(KingdomsConfig.Map.SCOREBOARD_HEADER)), this.settings);
            scoreboard.setAlignRight(KingdomsConfig.Map.SCOREBOARD_BEGIN.getManager().getString());
        } else {
            scoreboard.clearAll();
        }
        int height = Math.min(this.height, 7);
        for (int y = -height; y <= height; ++y) {
            StringBuilder row = new StringBuilder();
            for (int x = -this.width; x <= this.width; ++x) {
                ConfigSection section = this.handleCurrentChunk(x, y);
                String icon = section.getString("icon");
                if (icon == null) {
                    throw new IllegalStateException("Cannot find map icon section for property: " + this.property);
                }
                row.append(icon);
            }
            scoreboard.addLine(new StaticMessenger(row.toString()));
        }
        scoreboard.addPlayer(this.player);
        SCOREBOARDS.put(this.player.getUniqueId(), scoreboard);
    }

    private void error(String message) {
        throw new IllegalStateException(message + " for property: " + this.property);
    }

    private ConfigSection handleCurrentChunk(int x, int y) {
        this.resetCurrentState();
        this.setCurrentState(this.center.getRelative(x, y));
        this.property = this.processChunk();
        ConfigSection section = KingdomsConfig.MAP.getConfig().getSection(ConfigPath.buildRaw("elements." + this.property));
        if (section == null) {
            this.error("Cannot find map section");
        }
        this.currentChunkSettings();
        return section;
    }

    public void displayAsGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.MAP);
        ReusableOptionHandler elementOption = gui.getReusableOption("element");
        block0: for (int y = -3; y <= 2; ++y) {
            for (int x = -4; x <= 4; ++x) {
                ConfigSection section = this.handleCurrentChunk(x, y);
                List<String> hovers = section.getStringList("hover");
                String icon = section.getString("icon");
                if (icon == null) {
                    this.error("Cannot find map icon");
                }
                elementOption.editItem(item -> {
                    ConfigSection itemSection = section.getSection("item");
                    if (itemSection != null) {
                        item = XItemStack.edit((ItemStack)item, (ConfigurationSection)itemSection.toBukkitConfigurationSection(), Function.identity(), null);
                    }
                    if (this.structure != null) {
                        item.setType(this.structure.getBlock().getType());
                    }
                    ItemMeta meta = item.getItemMeta();
                    meta.setDisplayName(icon + ' ' + (hovers.isEmpty() ? "" : (String)hovers.get(0)));
                    meta.setLore(hovers.stream().skip(1L).collect(Collectors.toList()));
                    ItemUtil.translate(meta, this.settings);
                    item.setItemMeta(meta);
                    return item;
                });
                String action = section.getString("action");
                if (!(Strings.isNullOrEmpty((String)action) || action.startsWith("url:") || action.startsWith("|"))) {
                    String cmd = MessageCompiler.compile(action).buildPlain(this.settings);
                    elementOption.onNormalClicks(() -> {
                        org.kingdoms.utils.string.Strings.performCommands((OfflinePlayer)this.player, Collections.singletonList(cmd));
                        this.displayAsGUI();
                    });
                }
                elementOption.done();
                if (!elementOption.hasNext()) break block0;
            }
        }
        gui.open();
    }

    void displayHeader() {
        KingdomsMap.getHeaderMessage(KingdomsConfig.Map.HEADER).getSimpleProvider().send((CommandSender)this.player, this.settings);
    }

    void displayFooter() {
        MessageCompiler.compile(KingdomsConfig.Map.FOOTER.getManager().getString()).getSimpleProvider().send((CommandSender)this.player, this.settings);
    }

    public void process() {
        ArrayList<TextComponent> rows = new ArrayList<TextComponent>();
        for (int y = -this.height; y <= this.height; ++y) {
            TextComponent rowComponent = new TextComponent();
            rowComponent.addExtra(this.beginMain);
            boolean first = true;
            for (int x = -this.width; x <= this.width; ++x) {
                String icon;
                String action;
                ConfigSection section = this.handleCurrentChunk(x, y);
                TextComponent element = new TextComponent();
                TextComponent hover = new TextComponent();
                List<String> hovers = section.getStringList("hover");
                if (!hovers.isEmpty()) {
                    int i = 1;
                    String lastColors = "";
                    for (String hoverMsg : hovers) {
                        MessageObject compile = MessageCompiler.compile(hoverMsg);
                        hoverMsg = lastColors + compile.buildPlain(this.settings);
                        if (i++ != hovers.size()) {
                            hoverMsg = hoverMsg + '\n';
                        }
                        hover.addExtra(hoverMsg);
                        MessageObject currentLastColors = compile.findLastColors();
                        if (currentLastColors == null) continue;
                        lastColors = currentLastColors.buildPlain(this.settings);
                    }
                    HoverEvent hoverEvent = MessageCompiler.constructHoverEvent((BaseComponent[])new TextComponent[]{hover});
                    element.setHoverEvent(hoverEvent);
                }
                if (!Strings.isNullOrEmpty((String)(action = section.getString("action")))) {
                    ClickEvent.Action eventAction = ClickEvent.Action.RUN_COMMAND;
                    if (action.startsWith("url:")) {
                        eventAction = ClickEvent.Action.OPEN_FILE;
                        action = action.substring(4);
                    } else if (action.startsWith("|")) {
                        eventAction = ClickEvent.Action.SUGGEST_COMMAND;
                        action = action.substring(1);
                    }
                    action = MessageCompiler.compile(action).buildPlain(this.settings);
                    ClickEvent clickEvent = new ClickEvent(eventAction, action);
                    element.setClickEvent(clickEvent);
                }
                if ((icon = section.getString("icon")) == null) {
                    this.error("Cannot find map icon");
                }
                icon = MessageCompiler.compile(icon).buildPlain(this.settings);
                String distance = first ? "" : MessageCompiler.compile(this.distanceMain).buildPlain(this.settings);
                element.addExtra(distance + icon);
                rowComponent.addExtra((BaseComponent)element);
                if (y == 0 && x == this.width) {
                    String comp = MessageCompiler.compile(KingdomsConfig.Map.COMPASS.getManager().getString()).buildPlain(this.settings);
                    rowComponent.addExtra(comp);
                }
                first = false;
            }
            rows.add(rowComponent);
        }
        rows.forEach(component -> this.player.spigot().sendMessage((BaseComponent)component));
    }

    public SimpleChunkLocation getCenter() {
        return this.center;
    }

    public SimpleChunkLocation getChunk() {
        return this.chunk;
    }

    public Land getLand() {
        return this.land;
    }

    public Kingdom getKingdom() {
        return this.kpKingdom;
    }
}

