/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.indicator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.managers.land.indicator.LandIndicator;
import org.kingdoms.managers.land.indicator.LandVisualizer;
import org.kingdoms.utils.PlayerUtils;

public class MultiLandBlockIndicator
extends LandIndicator {
    private final Collection<Collection<Block>> blocks = new ArrayList<Collection<Block>>();

    public MultiLandBlockIndicator(Player player, BukkitTask task) {
        super(player, task);
    }

    public Collection<Collection<Block>> getBlocks() {
        return Collections.unmodifiableCollection(this.blocks);
    }

    public MultiLandBlockIndicator append(Collection<Block> blocks) {
        Objects.requireNonNull(blocks, "Cannot add null blocks collection");
        this.blocks.add(blocks);
        return this;
    }

    public MultiLandBlockIndicator append(SimpleChunkLocation chunk, String relation) {
        Collection<Block> blocks = LandVisualizer.build(this.player, chunk.toChunk(), relation);
        this.append(blocks);
        return this;
    }

    @Override
    public void end() {
        super.end();
        for (Collection<Block> blocks : this.blocks) {
            for (Block block : blocks) {
                if (block == null) break;
                PlayerUtils.sendBlockChange(this.player, block);
            }
        }
    }
}

