/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.indicator;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.NumberConversions;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.indicator.BlockVisualizerBuilder;
import org.kingdoms.managers.land.indicator.LandIndicator;
import org.kingdoms.managers.land.indicator.SinglularLandBlockIndicator;
import org.kingdoms.utils.hash.EntityHashMap;
import org.kingdoms.utils.hash.EntityWeakHashMap;
import org.kingdoms.utils.kingdoms.NationZone;
import org.kingdoms.utils.versionsupport.VersionSupport;

public class LandVisualizer {
    private static final Set<UUID> PERMANENT = new HashSet<UUID>();
    private static final EntityWeakHashMap<Player, LandIndicator> VISUALIZER = ((EntityHashMap.WeakBuilder)((EntityHashMap.WeakBuilder)EntityHashMap.weakBuilder(Player.class).onDeath(EntityWeakHashMap::remove)).onLeave(EntityWeakHashMap::remove)).build();
    private static final int MAX_PLAYER_ACCESSIBILITY_VIEW_DISTANCE = 160;
    private Player player;
    private KingdomPlayer kp;
    private Kingdom landKingdom;
    private Chunk chunk;
    private String relation;

    public static Set<UUID> getPermanent() {
        return PERMANENT;
    }

    public static EntityWeakHashMap<Player, LandIndicator> getVisualizer() {
        return VISUALIZER;
    }

    private static boolean canSeeBlockVertically(World world, int y) {
        int adjustedY;
        int maxHeight = world.getMaxHeight();
        int minHeight = VersionSupport.getMinWorldHeight(world);
        if (y > maxHeight) {
            adjustedY = maxHeight;
        } else if (y < minHeight) {
            adjustedY = minHeight;
        } else {
            return true;
        }
        int diff = Math.abs(Math.abs(adjustedY) - Math.abs(y));
        return diff <= 160;
    }

    public static @NonNull Collection<Block> build(Player player, Chunk chunk, String relation) {
        int y = NumberConversions.floor((double)player.getLocation().getY()) - 1;
        if (!LandVisualizer.canSeeBlockVertically(player.getWorld(), y)) {
            return null;
        }
        int max = KingdomsConfig.Claims.INDICATOR_VISUALIZER_FLOOR_CHECK_HEIGHT.getManager().getInt();
        String cornerBlockStr = KingdomsConfig.Claims.INDICATOR_CORNER_BLOCK.getManager().withOption("relation", relation).getString();
        String twoBlockStr = KingdomsConfig.Claims.INDICATOR_TWO_BLOCK.getManager().withOption("relation", relation).getString();
        XMaterial cornerBlock = Strings.isNullOrEmpty((String)cornerBlockStr) ? null : (XMaterial)XMaterial.matchXMaterial((String)cornerBlockStr).orElse(null);
        XMaterial twoBlock = Strings.isNullOrEmpty((String)twoBlockStr) ? null : (XMaterial)XMaterial.matchXMaterial((String)twoBlockStr).orElse(null);
        BlockVisualizerBuilder blockVisualizer = new BlockVisualizerBuilder(player, chunk, y, max, cornerBlock, twoBlock);
        if (cornerBlock != null) {
            blockVisualizer.visualize(0, 0, true);
            blockVisualizer.visualize(0, 15, true);
            blockVisualizer.visualize(15, 15, true);
            blockVisualizer.visualize(15, 0, true);
        }
        if (twoBlock != null) {
            if (KingdomsConfig.Claims.INDICATOR_VISUALIZER_BORDER.getManager().getBoolean()) {
                for (int i = 1; i < 15; ++i) {
                    blockVisualizer.visualize(i, 0, false);
                    blockVisualizer.visualize(i, 15, false);
                    blockVisualizer.visualize(0, i, false);
                    blockVisualizer.visualize(15, i, false);
                }
            } else {
                blockVisualizer.visualize(1, 0, false);
                blockVisualizer.visualize(0, 1, false);
                blockVisualizer.visualize(0, 14, false);
                blockVisualizer.visualize(1, 15, false);
                blockVisualizer.visualize(15, 14, false);
                blockVisualizer.visualize(14, 15, false);
                blockVisualizer.visualize(14, 0, false);
                blockVisualizer.visualize(15, 1, false);
            }
        }
        return blockVisualizer.blocks;
    }

    public static void removeVisualizers(Player player, boolean updateBlocks) {
        LandIndicator previousBlocks = VISUALIZER.remove(player);
        if (updateBlocks && previousBlocks != null) {
            previousBlocks.end();
        }
    }

    public LandVisualizer forPlayer(Player player, KingdomPlayer kp) {
        this.player = Objects.requireNonNull(player, "Cannot show land visualizers for null player");
        this.kp = kp;
        return this;
    }

    public LandVisualizer forKingdom(Kingdom kingdom) {
        this.landKingdom = kingdom;
        return this;
    }

    public LandVisualizer forLand(SimpleChunkLocation chunk) {
        return this.forLand(chunk.getLand(), chunk.toChunk());
    }

    public LandVisualizer forLand(Land land, Chunk chunk) {
        this.landKingdom = land == null ? null : land.getKingdom();
        this.chunk = chunk;
        return this;
    }

    public LandVisualizer display(boolean force) {
        if (force || this.kp.isUsingMarkers()) {
            this.displayIndicators();
        }
        return this.displayMessages();
    }

    private void setRelation() {
        this.relation = LandVisualizer.getRelationOf(SimpleChunkLocation.of(this.chunk), this.landKingdom, this.kp.getKingdom());
    }

    public static String getRelationOf(SimpleChunkLocation land, Kingdom landKingdom, Kingdom playersKingdom) {
        NationZone zone = Land.getNationZone(land);
        if (landKingdom == null) {
            if (zone == null) {
                return "wilderness";
            }
            return "nation-zone";
        }
        KingdomRelation relation = playersKingdom == null ? KingdomRelation.NEUTRAL : playersKingdom.getRelationWith(landKingdom);
        return org.kingdoms.utils.string.Strings.configOption(relation);
    }

    public LandVisualizer displayIndicators() {
        String markers;
        if (this.relation == null) {
            this.setRelation();
        }
        if ((markers = this.kp.getMarkersType()) == null) {
            markers = KingdomsConfig.Claims.INDICATOR_DEFAULT_METHOD.getManager().getString();
        }
        if (markers.equalsIgnoreCase("blocks")) {
            this.visualizeBlocks();
        } else {
            this.visualizeParticle(markers);
        }
        return this;
    }

    public LandVisualizer displayMessages() {
        if (this.relation == null) {
            this.setRelation();
        }
        KingdomsLang.valueOf("LANDS_VISUALIZER_" + org.kingdoms.utils.string.Strings.configOptionToEnum(this.relation)).sendMessage((CommandSender)this.player, new MessagePlaceholderProvider().withContext(this.player).other(this.landKingdom));
        return this;
    }

    public void visualizeBlocks() {
        new BukkitRunnable(){

            public void run() {
                LandVisualizer.removeVisualizers(LandVisualizer.this.player, true);
                Collection<Block> blocks = LandVisualizer.build(LandVisualizer.this.player, LandVisualizer.this.chunk, LandVisualizer.this.relation);
                if (blocks.isEmpty()) {
                    return;
                }
                BukkitTask task = null;
                if (!PERMANENT.contains(LandVisualizer.this.player.getUniqueId())) {
                    task = new BukkitRunnable(){

                        public void run() {
                            LandIndicator blocks = (LandIndicator)VISUALIZER.remove(LandVisualizer.this.player);
                            if (blocks != null) {
                                blocks.end();
                            }
                        }
                    }.runTaskLater((Plugin)Kingdoms.get(), (long)KingdomsConfig.Claims.INDICATOR_VISUALIZER_STAY.getManager().getInt() * 20L);
                }
                VISUALIZER.put(LandVisualizer.this.player, new SinglularLandBlockIndicator(LandVisualizer.this.player, blocks, task));
            }
        }.runTaskAsynchronously((Plugin)Kingdoms.get());
    }

    public void visualizeParticle(@NonNull String marker) {
        if (Strings.isNullOrEmpty((String)marker)) {
            throw new IllegalArgumentException("Marker is null or empty: " + marker);
        }
        final YamlConfigAccessor config = KingdomsConfig.Claims.INDICATOR_PARTICLES.getManager().withProperty(marker).getSection();
        final YamlConfigAccessor editMarkerSection = KingdomsConfig.Claims.INDICATOR_PARTICLE.getManager().withOption("relation", this.relation).withProperty(marker).getSection();
        BukkitTask task = new BukkitRunnable(){
            final ParticleDisplay display;
            final World world;
            final int cornerX;
            final int cornerZ;
            final double height;
            final double verticalRate;
            final double horizontalRate;
            int duration;
            {
                this.display = ParticleDisplay.edit((ParticleDisplay)ParticleDisplay.fromConfig((ConfigurationSection)config.toBukkitConfigurationSection()), (ConfigurationSection)editMarkerSection.toBukkitConfigurationSection());
                this.world = LandVisualizer.this.chunk.getWorld();
                this.cornerX = LandVisualizer.this.chunk.getX() << 4;
                this.cornerZ = LandVisualizer.this.chunk.getZ() << 4;
                this.height = config.getInt("height");
                this.verticalRate = this.height / config.getDouble("rates", "vertical");
                this.horizontalRate = 16.0 / config.getDouble("rates", "horizontal");
                this.duration = PERMANENT.contains(LandVisualizer.this.player.getUniqueId()) ? Integer.MAX_VALUE : config.getInt("duration");
            }

            public void run() {
                int startHeight = LandVisualizer.this.player.getLocation().getBlockY();
                double maxY = (double)startHeight + this.height;
                for (double y = (double)startHeight; y < maxY; y += this.verticalRate) {
                    for (double x = (double)this.cornerX; x <= (double)(this.cornerX + 16); x += this.horizontalRate) {
                        this.display.spawn(new Location(this.world, x, y, (double)this.cornerZ));
                        this.display.spawn(new Location(this.world, x, y, (double)(this.cornerZ + 16)));
                    }
                    for (double z = (double)this.cornerZ; z <= (double)(this.cornerZ + 16); z += this.horizontalRate) {
                        this.display.spawn(new Location(this.world, (double)this.cornerX, y, z));
                        this.display.spawn(new Location(this.world, (double)(this.cornerX + 16), y, z));
                    }
                }
                if (--this.duration <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, config.getLong("delay"));
        LandIndicator previous = VISUALIZER.put(this.player, new LandIndicator(this.player, task));
        if (previous != null) {
            previous.end();
        }
    }
}

