/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.holograms;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.internals.KingdomsTimings;
import org.kingdoms.scheduler.DelayedTask;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/managers/land/holograms/TemporaryBuildingVisuals;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/kingdoms/constants/land/abstraction/KingdomBuilding;", "duration", "Ljava/time/Duration;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/kingdoms/constants/land/abstraction/KingdomBuilding;Ljava/time/Duration;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getItem", "()Lorg/kingdoms/constants/land/abstraction/KingdomBuilding;", "getDuration", "()Ljava/time/Duration;", "removalTask", "Lorg/kingdoms/scheduler/DelayedTask;", "renewRemovalTask", "", "removeHolograms", "Companion", "core"})
public final class TemporaryBuildingVisuals {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Player player;
    @NotNull
    private final KingdomBuilding<?> item;
    @NotNull
    private final Duration duration;
    @Nullable
    private DelayedTask removalTask;
    @JvmField
    @NotNull
    public static final Map<UUID, Map<SimpleLocation, TemporaryBuildingVisuals>> TEMPORARY_HOLOGRAMS = new HashMap();

    public TemporaryBuildingVisuals(@NotNull Player player, @NotNull KingdomBuilding<?> item, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.player = player;
        this.item = item;
        this.duration = duration;
        this.renewRemovalTask();
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final KingdomBuilding<?> getItem() {
        return this.item;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final void renewRemovalTask() {
        KingdomsTimings.time();
        DelayedTask delayedTask = this.removalTask;
        if (delayedTask != null) {
            delayedTask.cancel();
        }
        this.removalTask = Kingdoms.taskScheduler().sync().delayed(this.duration, this::removeHolograms);
    }

    private final void removeHolograms() {
        if (this.item.hasObjectExpired()) {
            return;
        }
        this.item.getVisualsManager().onPlayerRemove(this.player);
    }

    @JvmStatic
    public static final void removeAll(@NotNull Player player) {
        Companion.removeAll(player);
    }

    @JvmStatic
    public static final void spawn(@NotNull Player player, @NotNull KingdomBuilding<?> building) {
        Companion.spawn(player, building);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001c\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0007R(\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00050\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/managers/land/holograms/TemporaryBuildingVisuals$Companion;", "", "<init>", "()V", "TEMPORARY_HOLOGRAMS", "", "Ljava/util/UUID;", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "Lorg/kingdoms/managers/land/holograms/TemporaryBuildingVisuals;", "removeAll", "", "player", "Lorg/bukkit/entity/Player;", "spawn", "building", "Lorg/kingdoms/constants/land/abstraction/KingdomBuilding;", "core"})
    @SourceDebugExtension(value={"SMAP\nTemporaryBuildingVisuals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryBuildingVisuals.kt\norg/kingdoms/managers/land/holograms/TemporaryBuildingVisuals$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1863#2,2:74\n*S KotlinDebug\n*F\n+ 1 TemporaryBuildingVisuals.kt\norg/kingdoms/managers/land/holograms/TemporaryBuildingVisuals$Companion\n*L\n43#1:74,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void removeAll(@NotNull Player player) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Map<SimpleLocation, TemporaryBuildingVisuals> map = TEMPORARY_HOLOGRAMS.remove(player.getUniqueId());
                if (map == null) break block1;
                Map<SimpleLocation, TemporaryBuildingVisuals> it = map;
                boolean bl = false;
                Iterable $this$forEach$iv = it.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TemporaryBuildingVisuals x = (TemporaryBuildingVisuals)element$iv;
                    boolean bl2 = false;
                    DelayedTask delayedTask = x.removalTask;
                    Intrinsics.checkNotNull((Object)delayedTask);
                    delayedTask.cancel();
                    x.removeHolograms();
                }
            }
        }

        @JvmStatic
        public final void spawn(@NotNull Player player, @NotNull KingdomBuilding<?> building) {
            Map itemHologramList;
            TemporaryBuildingVisuals holograms;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(building, (String)"building");
            if (!((KingdomBuildingStyle)building.getStyle()).hideHolograms()) {
                return;
            }
            Duration duration = KingdomsConfig.Turrets.TEMPORARY_HOLOGRAM_DISPLAY.getManager().getTime(new PlaceholderContextBuilder().withContext(player));
            if (duration == null) {
                return;
            }
            Duration time = duration;
            Map map = TEMPORARY_HOLOGRAMS.get(player.getUniqueId());
            if (map == null) {
                Companion $this$spawn_u24lambda_u242 = this;
                boolean bl = false;
                HashMap newMap = new HashMap();
                TEMPORARY_HOLOGRAMS.put(player.getUniqueId(), newMap);
                map = newMap;
            }
            if ((holograms = (itemHologramList = map).get(building.getOrigin())) == null) {
                building.getVisualsManager().onPlayerAdd(player);
                itemHologramList.put(building.getOrigin(), new TemporaryBuildingVisuals(player, building, time));
            } else {
                holograms.renewRemovalTask();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

