/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.holograms;

import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;

@ApiStatus.Internal
public final class KingdomBuildingHologramProcessor {
    private final Collection<Pair<SimpleChunkLocation, Collection<KingdomBuilding<?>>>> kingdomItems = new ArrayList(10);
    private final boolean checkWorlds;
    private final boolean isUpdating;
    private final boolean addMissingOnly;

    @Deprecated
    public KingdomBuildingHologramProcessor(boolean checkWorlds, boolean isUpdating, boolean addMissingOnly) {
        this.checkWorlds = checkWorlds;
        this.isUpdating = isUpdating;
        this.addMissingOnly = addMissingOnly;
    }

    public static boolean shouldShowHolograms(KingdomBuilding<?> building, Player player) {
        if (!((KingdomBuildingStyle)building.getStyle()).hideHolograms()) {
            return true;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom playerKingdom = kp.getKingdom();
        return kp.isAdmin() || KingdomsDefaultPluginPermission.SEE_OTHERS_HOLOGRAMS.hasPermission((CommandSender)player, false) || StandardRelationAttribute.SHOW_HOLOGRAMS.hasAttribute(playerKingdom, building.getLand().getKingdom());
    }

    private Collection<? extends Player> filterPlayers(Collection<? extends Player> players, KingdomBuilding<?> kingdomItem, Kingdom itemKingdom) {
        ArrayList<Player> chosenPlayers = new ArrayList<Player>(players.size());
        for (Player player : players) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom playerKingdom = kp.getKingdom();
            if (!kp.isAdmin() && !KingdomsDefaultPluginPermission.SEE_OTHERS_HOLOGRAMS.hasPermission((CommandSender)player, false) && !StandardRelationAttribute.SHOW_HOLOGRAMS.hasAttribute(playerKingdom, itemKingdom)) continue;
            chosenPlayers.add(player);
        }
        return chosenPlayers;
    }

    public void process(Collection<? extends Player> players) {
        for (Pair<SimpleChunkLocation, Collection<KingdomBuilding<?>>> kingdomItemPair : this.kingdomItems) {
            Collection<? extends Player> chosenPlayersForWorld = players;
            if (this.checkWorlds) {
                ArrayList<? extends Player> playersInWorld = new ArrayList<Player>(players.size());
                chosenPlayersForWorld = playersInWorld;
                for (Player player : players) {
                    if (!player.getWorld().getName().equals(kingdomItemPair.getKey().getWorld())) continue;
                    playersInWorld.add((Player)player);
                }
            }
            for (KingdomBuilding<?> item : kingdomItemPair.getValue()) {
                if (this.isUpdating && ((KingdomBuildingStyle)item.getStyle()).getOption("dont-update-holograms").getBoolean()) continue;
                Kingdom kingdom = item.getLand().getKingdom();
                Collection<? extends Player> chosenPlayers = chosenPlayersForWorld;
                if (!((KingdomBuildingStyle)item.getStyle()).hideHolograms()) continue;
                chosenPlayers = this.filterPlayers(chosenPlayers, item, kingdom);
            }
        }
    }
}

