/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.distance;

import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.distance.BasePlayerLocationListener;
import org.kingdoms.managers.land.distance.DistanceChangeReason;
import org.kingdoms.scheduler.TaskThreadType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J%\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/managers/land/distance/PlayerDistanceListener;", "Lorg/kingdoms/managers/land/distance/BasePlayerLocationListener;", "ignoreGettingFar", "", "location", "Lorg/bukkit/Location;", "triggerDistanceInBlocks", "", "<init>", "(ZLorg/bukkit/Location;D)V", "getIgnoreGettingFar$core", "()Z", "getLocation$core", "()Lorg/bukkit/Location;", "getTriggerDistanceInBlocks$core", "()D", "updateSurroundings", "", "checkActions", "player", "Lorg/bukkit/entity/Player;", "reason", "Lorg/kingdoms/managers/land/distance/DistanceChangeReason;", "checkActions$core", "core"})
public abstract class PlayerDistanceListener
extends BasePlayerLocationListener {
    private final boolean ignoreGettingFar;
    @NotNull
    private final Location location;
    private final double triggerDistanceInBlocks;

    public PlayerDistanceListener(boolean ignoreGettingFar, @NotNull Location location, double triggerDistanceInBlocks) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.ignoreGettingFar = ignoreGettingFar;
        this.location = location;
        this.triggerDistanceInBlocks = triggerDistanceInBlocks;
    }

    public final boolean getIgnoreGettingFar$core() {
        return this.ignoreGettingFar;
    }

    @NotNull
    public final Location getLocation$core() {
        return this.location;
    }

    public final double getTriggerDistanceInBlocks$core() {
        return this.triggerDistanceInBlocks;
    }

    @Override
    public void updateSurroundings() {
        World world = this.location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        if (world.getPlayers().isEmpty()) {
            return;
        }
        Kingdoms.taskScheduler().run(TaskThreadType.SYNC, () -> PlayerDistanceListener.updateSurroundings$lambda$1(this));
    }

    @Override
    public final void checkActions$core(@NotNull Player player, @NotNull Location location, @NotNull DistanceChangeReason reason) {
        double distance;
        boolean isInRange;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        boolean wasInRange = reason != DistanceChangeReason.JOINED && this.getPlayersInRange().contains(player);
        switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
            case 1: {
                if (wasInRange) {
                    this.onGettingFar$core(player, reason);
                    this.getPlayersInRange().remove(player);
                }
                return;
            }
            case 2: {
                if (!wasInRange || !this.ignoreGettingFar) break;
                return;
            }
        }
        boolean bl = !Intrinsics.areEqual((Object)location.getWorld(), (Object)location.getWorld()) ? false : (isInRange = (distance = location.distance(location)) <= this.triggerDistanceInBlocks);
        if (wasInRange) {
            if (!isInRange && this.onGettingFar$core(player, reason)) {
                this.getPlayersInRange().remove(player);
            }
        } else if (isInRange && this.onGettingClose$core(player, reason)) {
            this.getPlayersInRange().add(player);
        }
    }

    private static final void updateSurroundings$lambda$1$lambda$0(Collection $nearbyEntities, PlayerDistanceListener this$0) {
        for (Entity entity2 : $nearbyEntities) {
            if (!(entity2 instanceof Player)) continue;
            this$0.onGettingClose$core((Player)entity2, DistanceChangeReason.INIT);
            this$0.getPlayersInRange().add((Player)entity2);
        }
    }

    private static final void updateSurroundings$lambda$1(PlayerDistanceListener this$0) {
        World world = this$0.location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        Collection collection = world.getNearbyEntities(this$0.location, this$0.triggerDistanceInBlocks, this$0.triggerDistanceInBlocks, this$0.triggerDistanceInBlocks);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNearbyEntities(...)");
        Collection nearbyEntities = collection;
        Kingdoms.taskScheduler().async().execute(() -> PlayerDistanceListener.updateSurroundings$lambda$1$lambda$0(nearbyEntities, this$0));
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DistanceChangeReason.values().length];
            try {
                nArray[DistanceChangeReason.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistanceChangeReason.MOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

