/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.distance;

import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.general.admin.CommandAbout;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingConstruction;
import org.kingdoms.constants.land.building.BuildingConstructionListener;
import org.kingdoms.constants.land.building.BuildingConstructionState;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.holograms.GroupedHologram;
import org.kingdoms.managers.internals.KingdomsTimings;
import org.kingdoms.managers.land.holograms.KingdomBuildingHologramProcessor;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.display.components.HologramModelVisualComponent;
import org.kingdoms.utils.display.components.ParticleVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.AbstractVisualizer;
import org.kingdoms.utils.display.visualizer.Visualizer;
import org.kingdoms.utils.display.visualizer.visibility.ControllingVisibilityListener;
import org.kingdoms.utils.display.visualizer.visibility.DistancedVisibilityStrategy;
import org.kingdoms.utils.display.visualizer.visibility.VisibilityFilter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001,B\u0013\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0014\u0010\"\u001a\u00020\u00132\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0002J\b\u0010%\u001a\u00020\u000eH\u0002J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0013H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0013H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006-"}, d2={"Lorg/kingdoms/managers/land/distance/KingdomBuildingVisualizer;", "Lorg/kingdoms/utils/display/visualizer/AbstractVisualizer;", "Lorg/kingdoms/constants/land/building/BuildingConstructionListener;", "Lorg/kingdoms/utils/display/visualizer/visibility/ControllingVisibilityListener;", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "building", "Lorg/kingdoms/constants/land/abstraction/KingdomBuilding;", "<init>", "(Lorg/kingdoms/constants/land/abstraction/KingdomBuilding;)V", "messageContext", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "getMessageContext", "()Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "updateVisuals", "", "addOrUpdateParticleComponent", "addOrUpdateHolograms", "visualizePhase", "path", "Lorg/kingdoms/utils/config/ConfigPath;", "onBlockChange", "block", "Lorg/bukkit/block/Block;", "getHolograms", "Lorg/kingdoms/utils/display/components/HologramModelVisualComponent;", "onPlayerRemove", "player", "Lorg/bukkit/entity/Player;", "onStateChange", "lastState", "Lorg/kingdoms/constants/land/building/BuildingConstructionState;", "newState", "getNamespace", "Lorg/kingdoms/constants/namespace/Namespace;", "getCurrentStateName", "customStateName", "", "ensureValid", "playSoundAtOrigin", "soundPath", "poof", "particleName", "shouldExcludePlayer", "Lorg/kingdoms/utils/display/visualizer/visibility/VisibilityFilter;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nKingdomBuildingVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KingdomBuildingVisualizer.kt\norg/kingdoms/managers/land/distance/KingdomBuildingVisualizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1#2:213\n1863#3,2:214\n*S KotlinDebug\n*F\n+ 1 KingdomBuildingVisualizer.kt\norg/kingdoms/managers/land/distance/KingdomBuildingVisualizer\n*L\n134#1:214,2\n*E\n"})
public final class KingdomBuildingVisualizer
extends AbstractVisualizer
implements BuildingConstructionListener,
ControllingVisibilityListener,
Visualizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KingdomBuilding<?> building;
    @JvmField
    @NotNull
    public static final Namespace NS;
    public static final short PRIORITY = 20000;

    public KingdomBuildingVisualizer(@NotNull KingdomBuilding<?> building) {
        Intrinsics.checkNotNullParameter(building, (String)"building");
        Location location = building.getOrigin().toBukkitLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toBukkitLocation(...)");
        super(new DistancedVisibilityStrategy(false, location, 100.0));
        this.building = building;
    }

    @Override
    @NotNull
    public MessagePlaceholderProvider getMessageContext() {
        return this.building.getMessageContext();
    }

    public final void updateVisuals() {
        this.enqueueOperation(() -> KingdomBuildingVisualizer.updateVisuals$lambda$0(this));
    }

    private final void addOrUpdateParticleComponent() {
        if (!(this.building.getBuilding() instanceof BuildingConstruction)) {
            return;
        }
        ParticleDisplay particleDisplay = this.building.getParticleDisplay(this.getCurrentStateName("progress"));
        if (particleDisplay == null) {
            return;
        }
        ParticleDisplay display = particleDisplay;
        World world = this.building.getOrigin().getBukkitWorld();
        Intrinsics.checkNotNull((Object)world);
        Location min = BukkitAdapter.adapt(world, Vector3.Companion.of(this.building.getBuilding().getRegion().getMinimumPoint()));
        World world2 = this.building.getOrigin().getBukkitWorld();
        Intrinsics.checkNotNull((Object)world2);
        Location location = BukkitAdapter.adapt(world2, Vector3.Companion.of(this.building.getBuilding().getRegion().getMaximumPoint())).add(1.1, 1.1, 1.1);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        Location max = location;
        this.addComponent(new ParticleVisualComponent(this, CommandAbout.Fa\u00e7ade, display, arg_0 -> KingdomBuildingVisualizer.addOrUpdateParticleComponent$lambda$1(min, max, arg_0)));
    }

    private final void addOrUpdateHolograms() {
        String string;
        if (this.building.getBuilding() instanceof BuildingConstruction) {
            Building building = this.building.getBuilding();
            Intrinsics.checkNotNull((Object)building, (String)"null cannot be cast to non-null type org.kingdoms.constants.land.building.BuildingConstruction");
            String string2 = ((BuildingConstruction)building).getType().name();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string3 = string2.toLowerCase(locale);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = "main";
        }
        String hologramType = string;
        Map<String, GroupedHologram> map = this.building.getBuilding().getSettings().getHolograms().get(hologramType);
        if (map == null) {
            throw new IllegalArgumentException("Cannot find holograms for '" + ((KingdomBuildingStyle)this.building.getStyle()).getName() + "' named '" + hologramType + '\'');
        }
        Map<String, GroupedHologram> groupedHolograms = map;
        Visualizer visualizer = this;
        Duration duration = KingdomsConfig.HOLOGRAMS_UPDATE.getManager().getTime();
        Intrinsics.checkNotNull((Object)duration);
        SimpleLocation simpleLocation = this.building.getOrigin();
        Intrinsics.checkNotNullExpressionValue((Object)simpleLocation, (String)"getOrigin(...)");
        Vector3 vector3 = Vector3.Companion.of(simpleLocation).add(0.5, 0.0, 0.5);
        World world = this.building.getOrigin().getBukkitWorld();
        Intrinsics.checkNotNull((Object)world);
        this.addComponent(new HologramModelVisualComponent(visualizer, duration, vector3.inWorld(BukkitAdapter.adapt(world)), groupedHolograms.values()));
    }

    private final void visualizePhase(ConfigPath path) {
        this.poof(path);
        this.playSoundAtOrigin(path);
    }

    @Override
    public void onBlockChange(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ParticleDisplay particleDisplay = this.building.getParticleDisplay(this.getCurrentStateName("block-place"));
        if (particleDisplay != null) {
            particleDisplay.spawn(block.getLocation());
        }
        World world = block.getLocation().getWorld();
        Intrinsics.checkNotNull((Object)world);
        world.playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
    }

    @NotNull
    public final HologramModelVisualComponent getHolograms() {
        Object v0;
        block1: {
            Iterable iterable = this.getComponents();
            for (Object t : iterable) {
                VisualComponent it = (VisualComponent)t;
                boolean bl = false;
                if (!(it instanceof HologramModelVisualComponent)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type org.kingdoms.utils.display.components.HologramModelVisualComponent");
        return v0;
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Visualizer.super.onPlayerRemove(player);
        KingdomsTimings.time();
    }

    @Override
    public void onStateChange(@NotNull BuildingConstructionState lastState, @NotNull BuildingConstructionState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)lastState), (String)"lastState");
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        switch (WhenMappings.$EnumSwitchMapping$1[newState.ordinal()]) {
            case 1: 
            case 2: {
                String string;
                this.visualizePhase(KingdomBuildingVisualizer.getCurrentStateName$default(this, null, 1, null));
                this.clearVisualComponents();
                Building building = this.building.getBuilding();
                Intrinsics.checkNotNull((Object)building, (String)"null cannot be cast to non-null type org.kingdoms.constants.land.building.BuildingConstruction");
                switch (WhenMappings.$EnumSwitchMapping$0[((BuildingConstruction)building).getType().ordinal()]) {
                    case 1: {
                        string = "finished";
                        break;
                    }
                    case 2: {
                        string = "upgraded";
                        break;
                    }
                    case 3: {
                        string = "repaired";
                        break;
                    }
                    case 4: {
                        string = null;
                        break;
                    }
                    case 5: {
                        throw new IllegalStateException("Unexpected building consturction type: PREVIEW");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String msgPath = string;
                if (msgPath != null) {
                    Object object = this.building.getLand().getKingdom();
                    if (object != null && (object = ((Kingdom)object).getOnlineMembers()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Player it = (Player)element$iv;
                            boolean bl = false;
                            String[] stringArray = new String[]{"building", msgPath};
                            ((KingdomBuildingType)((KingdomBuildingStyle)this.building.getStyle()).getType()).getLang(stringArray).sendMessage((CommandSender)it, this.building.getMessageContext().raw("location", LocationUtils.locationMessenger(this.building.getOrigin())));
                        }
                    }
                }
                this.building.onBuildFinish();
                if (this.building.getBuilding() == null) break;
                this.updateVisuals();
                break;
            }
            case 3: 
            case 4: {
                this.updateVisuals();
                this.visualizePhase(KingdomBuildingVisualizer.getCurrentStateName$default(this, null, 1, null));
                break;
            }
            case 5: {
                this.stop();
            }
        }
    }

    @Override
    @NotNull
    public Namespace getNamespace() {
        return NS;
    }

    private final ConfigPath getCurrentStateName(String customStateName) {
        this.ensureValid();
        Building building = this.building.getBuilding();
        Intrinsics.checkNotNull((Object)building, (String)"null cannot be cast to non-null type org.kingdoms.constants.land.building.BuildingConstruction");
        BuildingConstruction ctor = (BuildingConstruction)building;
        BuildingConstructionType type = ctor.getType();
        BuildingConstructionState state = ctor.getState();
        String string = customStateName;
        if (string == null) {
            switch (WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
                case 1: 
                case 2: {
                    string = "finished";
                    break;
                }
                case 3: {
                    string = "started";
                    break;
                }
                case 4: 
                case 5: {
                    string = "stopped";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected building state: " + (Object)((Object)state));
                }
            }
        }
        String stateName = string;
        String string2 = type.name();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String typeName = string3;
        String[] stringArray = new String[]{typeName, stateName};
        ConfigPath configPath = ConfigPath.of(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)configPath, (String)"of(...)");
        return configPath;
    }

    static /* synthetic */ ConfigPath getCurrentStateName$default(KingdomBuildingVisualizer kingdomBuildingVisualizer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return kingdomBuildingVisualizer.getCurrentStateName(string);
    }

    private final void ensureValid() {
        if (this.building.getBuilding() == null) {
            throw new IllegalArgumentException("Building of " + this.building + " is null ");
        }
    }

    private final void playSoundAtOrigin(ConfigPath soundPath) {
        this.building.playSound(this.building.getOrigin().toBukkitLocation(), soundPath);
    }

    private final void poof(ConfigPath particleName) {
        ParticleDisplay particleDisplay = this.building.getParticleDisplay(particleName);
        if (particleDisplay == null) {
            return;
        }
        ParticleDisplay display = particleDisplay;
        for (BlockVector3 block : this.building.getBuilding().getRegion().getBlocks()) {
            World world = this.building.getOrigin().getBukkitWorld();
            Intrinsics.checkNotNull((Object)world);
            Location loc = BukkitAdapter.adapt(world, Vector3.Companion.of(block).add(0.5, 0.0, 0.5));
            display.spawn(loc);
        }
    }

    @Override
    @Nullable
    public VisibilityFilter shouldExcludePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!KingdomBuildingHologramProcessor.shouldShowHolograms(this.building, player)) {
            return VisibilityFilter.Companion.hide(NS, (short)20000);
        }
        return null;
    }

    private static final void updateVisuals$lambda$0(KingdomBuildingVisualizer this$0) {
        this$0.ensureValid();
        this$0.clearVisualComponents();
        this$0.addOrUpdateParticleComponent();
        this$0.addOrUpdateHolograms();
        if (this$0.getState() != VisualComponent.State.STARTED) {
            this$0.start();
        }
    }

    private static final void addOrUpdateParticleComponent$lambda$1(Location $min, Location $max, ParticleDisplay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Particles.structuredCube((Location)$min, (Location)$max, (double)0.3, (ParticleDisplay)it);
    }

    static {
        Namespace namespace = Namespace.kingdoms("VISUAL_MANAGER");
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
        NS = namespace;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kingdoms/managers/land/distance/KingdomBuildingVisualizer$Companion;", "", "<init>", "()V", "NS", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "PRIORITY", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BuildingConstructionType.values().length];
            try {
                nArray[BuildingConstructionType.OPENING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionType.UPGRADING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionType.REPAIRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionType.DEMOLISHING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionType.PREVIEW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BuildingConstructionState.values().length];
            try {
                nArray[BuildingConstructionState.FINISHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.FINISHED_AWAITING_CHUNK_UPDATES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.BUILDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.PAUSED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.CANCELLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

