/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming;

import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.objects.Outpost;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.libs.xseries.XBiome;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshotManager;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotPath;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.BiomeClaimResult;
import org.kingdoms.managers.land.claiming.ClaimProcessorBuilder;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.tasks.TaskRegistry;
import org.kingdoms.tasks.TaskState;
import org.kingdoms.tasks.annotations.After;
import org.kingdoms.tasks.annotations.Priority;
import org.kingdoms.tasks.annotations.ReturnTaskState;
import org.kingdoms.tasks.annotations.Task;
import org.kingdoms.tasks.container.LocalTaskSession;
import org.kingdoms.tasks.context.InputTaskContext;
import org.kingdoms.tasks.priority.PriorityPhase;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.chunks.ChunkConnections;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.kingdoms.NationZone;
import org.kingdoms.utils.versionsupport.VersionSupport;

public class ClaimProcessor
extends AbstractClaimProcessor
implements LocalTaskSession {
    protected boolean dontCheckConnections;
    protected boolean ignoreClaimed;
    protected boolean ignoreAdmin;
    private int phantomClaimCount = 1;
    protected BiomeClaimResult biome;
    private static final TaskRegistry<InputTaskContext<ClaimProcessor>, org.kingdoms.tasks.Task<InputTaskContext<ClaimProcessor>>> TASKS = new TaskRegistry();
    private static ClaimProcessorBuilder<ClaimProcessor> builder = ClaimProcessor::new;
    private boolean shouldOverclaim = false;

    public static ClaimProcessorBuilder<ClaimProcessor> getBuilder() {
        return builder;
    }

    public static ClaimProcessor build(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom) {
        return builder.build(chunk, kp, kingdom);
    }

    public static ClaimProcessor createSession(InputTaskContext<ClaimProcessor> context) {
        return context.getInput();
    }

    public static TaskRegistry<InputTaskContext<ClaimProcessor>, org.kingdoms.tasks.Task<InputTaskContext<ClaimProcessor>>> getTasks() {
        return TASKS;
    }

    public static void setBuilder(ClaimProcessorBuilder<ClaimProcessor> builder) {
        ClaimProcessor.builder = Objects.requireNonNull(builder, "ClaimProcessor builder cannot be null");
    }

    protected ClaimProcessor(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom) {
        super(chunk, kp, kingdom);
    }

    public ClaimProcessor dontCheckConnections() {
        this.dontCheckConnections = true;
        return this;
    }

    public ClaimProcessor ignoreAdmin() {
        this.ignoreAdmin = true;
        return this;
    }

    public ClaimProcessor phantomClaimCount(int phantomClaimCount) {
        this.phantomClaimCount = phantomClaimCount;
        return this;
    }

    public ClaimProcessor ignoreClaimed() {
        this.ignoreClaimed = true;
        return this;
    }

    @Override
    public AbstractClaimProcessor reprocess() {
        return this.clone().process();
    }

    @Override
    public ClaimProcessor clone() {
        ClaimProcessor processor = ClaimProcessor.build(this.chunk, this.kp, this.kingdom);
        return this.edit(processor);
    }

    public ClaimProcessor edit(ClaimProcessor processor) {
        if (this.dontCheckConnections) {
            processor.dontCheckConnections();
        }
        if (this.ignoreAdmin) {
            processor.ignoreAdmin = this.ignoreAdmin;
        }
        if (this.ignoreClaimed) {
            processor.ignoreClaimed = this.ignoreClaimed;
        }
        if (this.specialChunks != null) {
            processor.specialChunks = this.specialChunks;
        }
        processor.phantomClaimCount = this.phantomClaimCount;
        return processor;
    }

    @Override
    public long getResourcePoints() {
        return -this.rp;
    }

    @Override
    public double getMoney() {
        return -this.money;
    }

    @Override
    public boolean finalizeProcess() {
        ChunkSnapshotPath path;
        super.finalizeProcess();
        Duration cd = KingdomsConfig.Claims.UNCLAIM_COOLDOWN.getManager().getTime(this.getMessageContext());
        if (cd != null) {
            UnclaimProcessor.getUnclaimCooldown().add(this.chunk, cd.toMillis());
        }
        if (KingdomsConfig.Claims.RESTORATION_ENABLED.getManager().getBoolean() && !ChunkSnapshotManager.hasSnapshot(path = new ChunkSnapshotPath(this.chunk, ChunkSnapshotPath.TYPE_UNCLAIM))) {
            ChunkSnapshotManager.queueSnapshotGeneration(path);
        }
        return true;
    }

    public KingdomsLang isConnected(@IntRange(from=1L) int radius) {
        Outpost outpost;
        Land land = this.getLand();
        Outpost outpost2 = outpost = land == null ? null : land.getStructure(Outpost.class);
        if (outpost != null) {
            return null;
        }
        String world = this.chunk.getWorld();
        if (this.chunk.anySurroundingChunks(radius, x -> {
            AbstractClaimProcessor.ChunkHandling specialNeeds;
            if (this.specialChunks != null && (specialNeeds = (AbstractClaimProcessor.ChunkHandling)((Object)((Object)this.specialChunks.get(x)))) != null) {
                return specialNeeds == AbstractClaimProcessor.ChunkHandling.CLAIMED;
            }
            return this.kingdom.isClaimed((SimpleChunkLocation)x);
        })) {
            return null;
        }
        boolean firstClaimInWorld = this.kingdom.getLandLocations().stream().noneMatch(x -> x.getWorld().equals(world));
        if (firstClaimInWorld && KingdomsConfig.Claims.REQUIRES_OUTPOST_FOR_OTHER_WORLDS.getManager().getBoolean()) {
            return KingdomsLang.COMMAND_CLAIM_REQUIRES_OUTPOST;
        }
        return KingdomsLang.COMMAND_CLAIM_NOT_CONNECTED;
    }

    public boolean hasCosts() {
        return this.rp > 0L || this.money > 0.0;
    }

    public boolean shouldOverclaim() {
        return this.shouldOverclaim;
    }

    protected BiomeClaimResult processBiome(SimpleChunkLocation chunkLocation) {
        YamlConfigAccessor worldSettings = KingdomsConfig.Claims.BIOMES.getManager().withProperty(chunkLocation.getWorld()).getSection();
        if (worldSettings == null) {
            return new BiomeClaimResult(null, 0L, false);
        }
        boolean whitelist = worldSettings.getBoolean("whitelist");
        List<String> biomes = worldSettings.getStringList("biomes");
        ConfigSection costFactorSection = worldSettings.getSection().getSection("cost-factor");
        World world = chunkLocation.getBukkitWorld();
        Location center = chunkLocation.getCenterLocation();
        double highestY = world.getMaxHeight();
        XBiome xBiome = null;
        long costFactor = 0L;
        for (double lowestY = (double)VersionSupport.getMinWorldHeight(world); lowestY < highestY; lowestY += 50.0) {
            Location loc = center.clone();
            loc.setY(lowestY);
            Biome biome = loc.getBlock().getBiome();
            xBiome = XBiome.of((Biome)biome);
            costFactor = costFactorSection.getLong(xBiome.name());
            boolean contains = biomes.contains(xBiome.name().toUpperCase(Locale.ENGLISH));
            if (contains == whitelist) continue;
            return new BiomeClaimResult(xBiome, costFactor, true);
        }
        return new BiomeClaimResult(xBiome, costFactor, false);
    }

    @Override
    @Task(key="WORLD_AND_PERMISSION")
    @ReturnTaskState(state=TaskState.SHOULD_STOP)
    @Priority(priority=PriorityPhase.LOWEST)
    public Messenger checkWorldAndPermission() {
        String world = this.chunk.getWorld();
        if (KingdomsConfig.DISABLED_WORLDS.getStringList().contains(world)) {
            return KingdomsLang.DISABLED_WORLD;
        }
        if (KingdomsConfig.Claims.DISABLED_WORLDS.getManager().getStringList().contains(world)) {
            return KingdomsLang.COMMAND_CLAIM_DISABLED_WORLD;
        }
        if (this.isAdminMode()) {
            return null;
        }
        if (!this.kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            return StandardKingdomPermission.CLAIM.getDeniedMessage();
        }
        return null;
    }

    @Task(key="CLAIMS")
    @After(other="WORLD_AND_PERMISSION")
    @ReturnTaskState(state=TaskState.SHOULD_STOP)
    protected Messenger checkClaims() {
        if (this.ignoreClaimed) {
            return null;
        }
        Land land = this.getLand();
        if (land != null && land.isClaimed()) {
            if (this.kingdom.isClaimed(this.chunk)) {
                return KingdomsLang.COMMAND_CLAIM_ALREADY_OWNED;
            }
            if (!KingdomsConfig.Powers.POWER_ENABLED.getManager().getBoolean()) {
                KingdomRelation relation;
                Kingdom occupiedKingdom = land.getKingdom();
                KingdomRelation kingdomRelation = relation = occupiedKingdom != null ? this.kingdom.getRelationWith(occupiedKingdom) : null;
                if (relation == KingdomRelation.TRUCE || relation == KingdomRelation.ALLY) {
                    return KingdomsLang.COMMAND_CLAIM_OCCUPIED_FRIENDLY_LAND;
                }
                return KingdomsLang.COMMAND_CLAIM_OCCUPIED_LAND;
            }
            Kingdom other = land.getKingdom();
            if (!other.canBeOverclaimed()) {
                return KingdomsLang.COMMAND_CLAIM_CANT_OVERCLAIM;
            }
            this.shouldOverclaim = true;
        }
        return null;
    }

    @Task(key="MAX_CLAIMS")
    @ReturnTaskState(state=TaskState.SHOULD_STOP)
    @After(other="CLAIMS")
    protected Messenger checkMaxClaims() {
        if (this.isAdminMode()) {
            return null;
        }
        int maxKingdomClaim = this.kingdom.getMaxClaims(this.chunk.getWorld());
        if (this.kingdom.getLandLocations().size() + this.phantomClaimCount > maxKingdomClaim) {
            this.var("limit", maxKingdomClaim);
            return KingdomsLang.COMMAND_CLAIM_MAX_CLAIMS;
        }
        int maxClaims = this.kp.getRank().getMaxClaims();
        if (maxClaims >= 0 && this.kp.getClaims().size() + this.phantomClaimCount > maxClaims) {
            this.var("limit", maxClaims);
            return maxClaims == 0 ? KingdomsLang.COMMAND_CLAIM_NO_CLAIMS_PLAYER : KingdomsLang.COMMAND_CLAIM_MAX_CLAIMS_PLAYER;
        }
        return null;
    }

    @Task(key="BIOMES")
    @ReturnTaskState(state=TaskState.SHOULD_STOP)
    @After(other="MAX_CLAIMS")
    protected Messenger checkBiomes() {
        if (this.isAdminMode()) {
            return null;
        }
        this.biome = this.processBiome(this.chunk);
        if (this.biome.isDisallowed()) {
            this.var("biome", this.biome.getBiome().name().toLowerCase(Locale.ENGLISH));
            return KingdomsLang.COMMAND_CLAIM_DISALLOWED_BIOME;
        }
        return null;
    }

    @Task(key="CAN_AFFORD")
    @ReturnTaskState(state=TaskState.SHOULD_STOP)
    @After(other="BIOMES")
    public Messenger canAfford() {
        if (this.isAdminMode()) {
            return null;
        }
        Pair<Long, Double> costs = ClaimProcessor.calculateCosts(this.kingdom, 1, this.auto, this.biome.getCostFactor());
        if (costs == null) {
            return null;
        }
        this.rp = costs.getKey();
        this.money = costs.getValue();
        this.var("rp", this.rp);
        this.var("money", this.money);
        this.var("biome_cost_factor", this.biome.getCostFactor());
        if (!this.kingdom.getResourcePoints().has(this.rp)) {
            return KingdomsLang.COMMAND_CLAIM_NEED_RP;
        }
        if (!this.kingdom.getBank().has(this.money)) {
            return KingdomsLang.COMMAND_CLAIM_NEED_MONEY;
        }
        this.rp = -this.rp;
        this.money = -this.money;
        return null;
    }

    @Task(key="CHUNK_CONNECTIONS")
    @ReturnTaskState(state=TaskState.SHOULD_STOP)
    @After(other="CAN_AFFORD")
    public Messenger checkChunkConnections() {
        if (this.isAdminMode()) {
            return null;
        }
        if (this.dontCheckConnections) {
            return null;
        }
        int radius = ChunkConnections.getConnectionRadius();
        if (radius > 0) {
            if (this.kingdom.getLandLocations().isEmpty()) {
                return null;
            }
            return this.isConnected(radius);
        }
        return null;
    }

    @Task(key="CHUNK_DISTANCE")
    @ReturnTaskState(state=TaskState.SHOULD_STOP)
    @After(other="CHUNK_CONNECTIONS")
    public Messenger checkDistance() {
        if (this.isAdminMode()) {
            return null;
        }
        if (this.dontCheckConnections) {
            return null;
        }
        if (ChunkConnections.validateDistance(this.chunk, this.kingdom.getId()) != null) {
            return KingdomsLang.COMMAND_CLAIM_NOT_DISTANCED;
        }
        return null;
    }

    @Task(key="NATION_ZONE")
    @ReturnTaskState(state=TaskState.SHOULD_STOP)
    @After(other="CHUNK_DISTANCE")
    protected Messenger checkNationZone() {
        Nation nation;
        if (this.isAdminMode()) {
            return null;
        }
        NationZone nationZone = Land.getNationZone(this.chunk);
        if (nationZone != null && !(nation = nationZone.getNation()).isMember(this.kp.getKingdomId())) {
            this.var("nation", nation.getName());
            return KingdomsLang.COMMAND_CLAIM_NATION_ZONE;
        }
        return null;
    }

    @Override
    public Messenger processIssue() {
        TASKS.executeTasks(this, this::fail);
        return null;
    }

    @Override
    public ClaimProcessor process() {
        this.processIssue();
        return this;
    }

    public static Pair<Long, Double> calculateCosts(Kingdom kingdom, int lands, boolean auto, long biomeFactor) {
        int currentLands;
        int starterPack = KingdomsConfig.Claims.STARTER_FREE.getManager().getInt();
        int freeLands = starterPack - ((currentLands = kingdom.getLandLocations().size()) + lands);
        if (freeLands >= 0) {
            return null;
        }
        if (starterPack > currentLands && (lands -= starterPack - currentLands) <= 0) {
            return null;
        }
        PlaceholderContextBuilder ctx = new PlaceholderContextBuilder().withContext(kingdom);
        ctx.raw("biome_cost_factor", biomeFactor);
        KingdomsConfig.Claims rpOpt = auto ? KingdomsConfig.Claims.RESOURCE_POINTS_AUTO_CLAIMS : KingdomsConfig.Claims.RESOURCE_POINTS_CLAIMS;
        long rp = (long)MathUtils.eval(rpOpt.getManager().getMathExpression(), (PlaceholderProvider)ctx);
        double money = 0.0;
        if (ServiceHandler.bankServiceAvailable()) {
            KingdomsConfig.Claims moneyOpt = auto ? KingdomsConfig.Claims.MONEY_AUTO_CLAIMS : KingdomsConfig.Claims.MONEY_CLAIMS;
            money = MathUtils.eval(moneyOpt.getManager().getMathExpression(), (PlaceholderProvider)ctx);
        }
        return Pair.of(rp * (long)lands, money * (double)lands);
    }

    static {
        TASKS.register(ClaimProcessor.class, InputTaskContext::getInput);
    }
}

