/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BulkClaimProcessor;

public class ClaimClipboard {
    private static final Map<UUID, ClaimClipboard> CLIPBOARD = new HashMap<UUID, ClaimClipboard>();
    private final long started = System.currentTimeMillis();
    private final BulkClaimProcessor claims;
    private final World world;

    public ClaimClipboard(World world, BulkClaimProcessor claims) {
        this.world = Objects.requireNonNull(world, "Clipboard world cannot be null");
        this.claims = Objects.requireNonNull(claims, "Clipboard claims cannot be null");
    }

    public static void addClipboard(Player player, ClaimClipboard clipboard) {
        CLIPBOARD.put(player.getUniqueId(), clipboard);
    }

    public static Map<UUID, ClaimClipboard> getClipboards() {
        return CLIPBOARD;
    }

    public BulkClaimProcessor getClaims() {
        return this.claims;
    }

    public long getStarted() {
        return this.started;
    }

    public Pair<Long, Double> getTotalCost() {
        long rp = 0L;
        double money = 0.0;
        for (AbstractClaimProcessor processor : this.claims.getProcessedClaims().values()) {
            if (!processor.isSuccessful()) continue;
            rp += processor.getResourcePoints();
            money += processor.getMoney();
        }
        return Pair.of(rp, money);
    }

    public World getWorld() {
        return this.world;
    }

    public static final class ClaimProcessor
    extends org.kingdoms.managers.land.claiming.ClaimProcessor {
        public ClaimProcessor(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom) {
            super(chunk, kp, kingdom);
        }
    }
}

