/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.chests;

import java.time.Duration;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.holograms.GroupedHologram;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.land.chests.GeneratedChest;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.display.components.AudibleVisualComponent;
import org.kingdoms.utils.display.components.HologramModelVisualComponent;
import org.kingdoms.utils.display.components.ParticleVisualComponent;
import org.kingdoms.utils.display.visualizer.TemporaryVisualizer;
import org.kingdoms.utils.display.visualizer.visibility.ControllingVisibilityListener;
import org.kingdoms.utils.display.visualizer.visibility.DistancedVisibilityStrategy;
import org.kingdoms.utils.display.visualizer.visibility.VisibilityFilter;

public final class ChestVisualizer
extends TemporaryVisualizer
implements ControllingVisibilityListener {
    private final Invasion invasion;
    private final GeneratedChest chest;
    private final BooleanSupplier blackHole;
    private static final Namespace FILTER_NS = Namespace.kingdoms("GENERATED_CHEST");
    private static final short FILTER_PRIORITY = 20000;

    public ChestVisualizer(MessagePlaceholderProvider provider, Invasion invasion, GeneratedChest chest) {
        super(new DistancedVisibilityStrategy(true, chest.getChestBlock().getLocation(), 100.0), Duration.ofMinutes(10L), provider);
        this.invasion = invasion;
        this.chest = chest;
        Location centerOfChest = LocationUtils.getCenterOfBlock(chest.getChestBlock());
        ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.FLAME).withLocation(centerOfChest);
        this.blackHole = Particles.blackhole((int)100, (double)3.0, (double)0.031415926535897934, (int)5, (int)Integer.MAX_VALUE, (ParticleDisplay)display);
        this.addComponent(new ParticleVisualComponent(this, Duration.ofSeconds(1L), display, this::spawnParticles));
        this.addComponent(new AudibleVisualComponent(this, Duration.ofSeconds(3L), XSound.BLOCK_NOTE_BLOCK_CHIME.record().withVolume(3.0f).soundPlayer().atLocation(centerOfChest)));
        this.addComponent(new HologramModelVisualComponent(this, Duration.ZERO, BukkitAdapter.adapt(centerOfChest).add(0, 0.5, 0), Collections.singletonList(GroupedHologram.parse(chest.getSettings().getConfig().getSection("hologram")))));
    }

    private void spawnParticles(ParticleDisplay display) {
        this.blackHole.getAsBoolean();
    }

    @Override
    @Nullable
    public VisibilityFilter shouldExcludePlayer(@NotNull Player player) {
        if (!this.invasion.getAttacker().getMembers().contains(player.getUniqueId())) {
            return VisibilityFilter.hide(FILTER_NS, (short)20000);
        }
        return null;
    }
}

