/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.chests;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \"2\u00020\u0001:\u0001\"BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\f0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lorg/kingdoms/managers/land/chests/ChestSettings;", "", "name", "", "displayName", "Lorg/kingdoms/locale/messenger/Messenger;", "total", "", "chance", "", "content", "", "Lorg/kingdoms/libs/kotlin/Pair;", "Lorg/bukkit/inventory/ItemStack;", "config", "Lorg/kingdoms/utils/config/ConfigSection;", "<init>", "(Ljava/lang/String;Lorg/kingdoms/locale/messenger/Messenger;IDLjava/util/List;Lorg/kingdoms/utils/config/ConfigSection;)V", "getName", "()Ljava/lang/String;", "getDisplayName", "()Lorg/kingdoms/locale/messenger/Messenger;", "setDisplayName", "(Lorg/kingdoms/locale/messenger/Messenger;)V", "getTotal", "()I", "setTotal", "(I)V", "getChance", "()D", "getContent", "()Ljava/util/List;", "getConfig", "()Lorg/kingdoms/utils/config/ConfigSection;", "Companion", "core"})
public final class ChestSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private Messenger displayName;
    private int total;
    private final double chance;
    @NotNull
    private final List<Pair<Double, ItemStack>> content;
    @NotNull
    private final ConfigSection config;

    public ChestSettings(@NotNull String name, @NotNull Messenger displayName, int total, double chance, @NotNull List<? extends Pair<Double, ? extends ItemStack>> content, @NotNull ConfigSection config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.name = name;
        this.displayName = displayName;
        this.total = total;
        this.chance = chance;
        this.content = content;
        this.config = config;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Messenger getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(@NotNull Messenger messenger) {
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"<set-?>");
        this.displayName = messenger;
    }

    public final int getTotal() {
        return this.total;
    }

    public final void setTotal(int n) {
        this.total = n;
    }

    public final double getChance() {
        return this.chance;
    }

    @NotNull
    public final List<Pair<Double, ItemStack>> getContent() {
        return this.content;
    }

    @NotNull
    public final ConfigSection getConfig() {
        return this.config;
    }

    @JvmStatic
    @NotNull
    public static final List<ChestSettings> parseChestSetting(@NotNull YamlConfigAccessor config, @NotNull MessagePlaceholderProvider context) {
        return Companion.parseChestSetting(config, context);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/managers/land/chests/ChestSettings$Companion;", "", "<init>", "()V", "parseChestSetting", "", "Lorg/kingdoms/managers/land/chests/ChestSettings;", "config", "Lorg/kingdoms/config/implementation/YamlConfigAccessor;", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<ChestSettings> parseChestSetting(@NotNull YamlConfigAccessor config, @NotNull MessagePlaceholderProvider context) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            List chests = new ArrayList();
            for (String chestName : config.getKeys()) {
                YamlConfigAccessor contentSection;
                YamlConfigAccessor chestConfig;
                String[] stringArray = new String[]{chestName};
                Intrinsics.checkNotNull((Object)config.gotoSection(stringArray));
                MathExpression mathExpression = chestConfig.get(NodeInterpreter.MATH, "total");
                Intrinsics.checkNotNull((Object)mathExpression);
                int totalOfThisType = (int)MathUtils.eval(mathExpression, (PlaceholderProvider)context);
                MathExpression mathExpression2 = chestConfig.get(NodeInterpreter.MATH, "chance");
                Intrinsics.checkNotNull((Object)mathExpression2);
                double chance = MathUtils.eval(mathExpression2, (PlaceholderProvider)context);
                String[] stringArray2 = new String[]{"display-name"};
                StaticMessenger displayName = new StaticMessenger(chestConfig.getString(stringArray2));
                List content = new ArrayList();
                String[] stringArray3 = new String[]{"content"};
                Intrinsics.checkNotNull((Object)chestConfig.gotoSection(stringArray3));
                for (String itemName : contentSection.getKeys()) {
                    YamlConfigAccessor itemSection;
                    String[] stringArray4 = new String[]{itemName};
                    Intrinsics.checkNotNull((Object)contentSection.gotoSection(stringArray4));
                    String[] stringArray5 = new String[]{"tries"};
                    int tries = itemSection.getInt(stringArray5);
                    if (tries <= 0) {
                        tries = 1;
                    }
                    MathExpression mathExpression3 = itemSection.get(NodeInterpreter.MATH, "chance");
                    Intrinsics.checkNotNull((Object)mathExpression3);
                    double itemChance = MathUtils.eval(mathExpression3, (PlaceholderProvider)context);
                    String[] stringArray6 = new String[]{"item"};
                    YamlConfigAccessor yamlConfigAccessor = itemSection.gotoSection(stringArray6);
                    Intrinsics.checkNotNull((Object)yamlConfigAccessor);
                    Intrinsics.checkNotNullExpressionValue((Object)XItemStack.deserialize((ConfigurationSection)yamlConfigAccessor.getSection().toBukkitConfigurationSection()), (String)"deserialize(...)");
                    while (tries > 0) {
                        ItemStack item;
                        content.add(new Pair((Object)itemChance, (Object)item));
                        --tries;
                    }
                }
                Intrinsics.checkNotNull((Object)chestName);
                Messenger messenger = displayName;
                ConfigSection configSection = chestConfig.getSection();
                Intrinsics.checkNotNullExpressionValue((Object)configSection, (String)"getSection(...)");
                chests.add(new ChestSettings(chestName, messenger, totalOfThisType, chance, content, configSection));
            }
            return chests;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

