/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.chests;

import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.ArrayIteratorsKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Ref;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.land.chests.ChestSettings;
import org.kingdoms.managers.land.chests.GeneratedChest;
import org.kingdoms.managers.land.chests.RandomBlockIterator;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.platform.bukkit.location.BukkitWorld;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.internal.arrays.KotlinArrayExtensions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/managers/land/chests/ChestGenerator;", "", "world", "Lorg/bukkit/World;", "generatePoints", "", "Lorg/kingdoms/server/location/BlockVector3;", "<init>", "(Lorg/bukkit/World;Ljava/util/Collection;)V", "generate", "Lorg/kingdoms/managers/land/chests/GeneratedChest;", "config", "Lorg/kingdoms/config/implementation/YamlConfigAccessor;", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nChestGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChestGenerator.kt\norg/kingdoms/managers/land/chests/ChestGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n1557#3:114\n1628#3,3:115\n*S KotlinDebug\n*F\n+ 1 ChestGenerator.kt\norg/kingdoms/managers/land/chests/ChestGenerator\n*L\n53#1:114\n53#1:115,3\n*E\n"})
public final class ChestGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    @NotNull
    private final Collection<BlockVector3> generatePoints;
    @JvmField
    @NotNull
    public static final Set<XMaterial> UNVALUABLE_MATERIALS;

    public ChestGenerator(@NotNull World world, @NotNull Collection<BlockVector3> generatePoints) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(generatePoints, (String)"generatePoints");
        this.world = world;
        this.generatePoints = generatePoints;
        if (!(!this.generatePoints.isEmpty())) {
            boolean bl = false;
            String string = "Generate points cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<GeneratedChest> generate(@NotNull YamlConfigAccessor config, @NotNull MessagePlaceholderProvider context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List chests = new ArrayList();
        ThreadLocalRandom randomizer = ThreadLocalRandom.current();
        MathExpression mathExpression = config.get(NodeInterpreter.MATH, "chance");
        Intrinsics.checkNotNull((Object)mathExpression);
        double mainChance = MathUtils.eval(mathExpression, (PlaceholderProvider)context);
        if (!MathUtils.hasChance(mainChance)) {
            return chests;
        }
        MathExpression mathExpression2 = config.get(NodeInterpreter.MATH, "total");
        Intrinsics.checkNotNull((Object)mathExpression2);
        int total = (int)MathUtils.eval(mathExpression2, (PlaceholderProvider)context);
        String[] stringArray = new String[]{"chests"};
        YamlConfigAccessor yamlConfigAccessor = config.gotoSection(stringArray);
        Intrinsics.checkNotNull((Object)yamlConfigAccessor);
        YamlConfigAccessor yamlConfigAccessor2 = yamlConfigAccessor.noDefault();
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfigAccessor2, (String)"noDefault(...)");
        List<ChestSettings> chestSettings = ChestSettings.Companion.parseChestSetting(yamlConfigAccessor2, context);
        Iterable $this$map$iv = this.generatePoints;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BlockVector3 blockVector3 = (BlockVector3)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(RandomBlockIterator.Companion.of((BlockVector3)it, 10));
        }
        Iterator pointsIterator = ((List)destination$iv$iv2).iterator();
        Ref.ObjectRef nextIter = new Ref.ObjectRef();
        nextIter.element = pointsIterator.next();
        while (total-- > 0) {
            Iterator<ChestSettings> iter = chestSettings.iterator();
            while (iter.hasNext()) {
                Block baseBlock;
                Block block;
                boolean dangerous;
                ChestSettings chest = iter.next();
                if (!MathUtils.hasChance(chest.getChance())) continue;
                int destination$iv$iv2 = chest.getTotal();
                chest.setTotal(destination$iv$iv2 + -1);
                if (destination$iv$iv2 <= 0) {
                    iter.remove();
                    continue;
                }
                do {
                    BlockVector3 randLoc = ChestGenerator.generate$getRandomPoint((Ref.ObjectRef<Iterator<BlockVector3>>)nextIter, pointsIterator, this);
                    BlockVector3 baseLoc = BlockVector3.Companion.of(randLoc.getX(), randLoc.getY() - 1, randLoc.getZ());
                    Intrinsics.checkNotNullExpressionValue((Object)this.world.getBlockAt(BukkitAdapter.adapt(randLoc.inWorld(new BukkitWorld(this.world)))), (String)"getBlockAt(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)this.world.getBlockAt(BukkitAdapter.adapt(baseLoc.inWorld(new BukkitWorld(this.world)))), (String)"getBlockAt(...)");
                } while (dangerous = !UNVALUABLE_MATERIALS.contains(XMaterial.matchXMaterial((Material)block.getType())) || !baseBlock.getType().isSolid());
                block.setType(Material.CHEST);
                BlockState blockState = block.getState();
                Intrinsics.checkNotNull((Object)blockState, (String)"null cannot be cast to non-null type org.bukkit.block.Chest");
                Chest state = (Chest)blockState;
                ChestGenerator $this$generate_u24lambda_u242 = this;
                boolean bl = false;
                int[] array = KotlinArrayExtensions.INSTANCE.toIntArray(RangesKt.until((int)0, (int)27));
                ArraysKt.shuffle((int[])array);
                Iterator emptySlots = (Iterator)ArrayIteratorsKt.iterator((int[])array);
                for (Pair<Double, ItemStack> pair : chest.getContent()) {
                    ItemStack cloned;
                    double chance = ((Number)pair.component1()).doubleValue();
                    ItemStack item = (ItemStack)pair.component2();
                    if (!MathUtils.hasChance(chance)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)item.clone(), (String)"clone(...)");
                    if (cloned.getAmount() <= 1) {
                        cloned.setAmount(1);
                    } else {
                        cloned.setAmount(randomizer.nextInt(cloned.getAmount() / 2, cloned.getAmount()));
                    }
                    state.getBlockInventory().setItem(((Number)emptySlots.next()).intValue(), cloned);
                }
                chests.add(new GeneratedChest(block, chest));
            }
        }
        return chests;
    }

    private static final BlockVector3 generate$getRandomPoint(Ref.ObjectRef<Iterator<BlockVector3>> nextIter, Iterator<? extends Iterator<BlockVector3>> pointsIterator, ChestGenerator this$0) {
        if (((Iterator)nextIter.element).hasNext()) {
            return (BlockVector3)((Iterator)nextIter.element).next();
        }
        if (!pointsIterator.hasNext()) {
            throw new IllegalStateException("Could not find any free space for invasion chests " + this$0.generatePoints.size());
        }
        nextIter.element = pointsIterator.next();
        return ChestGenerator.generate$getRandomPoint(nextIter, pointsIterator, this$0);
    }

    static {
        Object[] objectArray = new XMaterial[]{XMaterial.GRASS_BLOCK, XMaterial.TALL_GRASS, XMaterial.SHORT_GRASS};
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new XTag[]{XTag.SAND, XTag.SNOW, XTag.AIR, XTag.ICE, XTag.DIRT, XTag.LOGS};
        UNVALUABLE_MATERIALS = ChestGenerator.Companion.addAll(collection, CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\tH\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kingdoms/managers/land/chests/ChestGenerator$Companion;", "", "<init>", "()V", "UNVALUABLE_MATERIALS", "", "Lorg/kingdoms/libs/xseries/XMaterial;", "addAll", "materials", "", "tags", "Lorg/kingdoms/libs/xseries/XTag;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<XMaterial> addAll(Collection<? extends XMaterial> materials, Collection<XTag<XMaterial>> tags) {
            Set set = new HashSet(200);
            for (XMaterial xMaterial : materials) {
                set.add(xMaterial);
            }
            for (XTag xTag : tags) {
                Set set2 = xTag.getValues();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getValues(...)");
                set.addAll(set2);
            }
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

