/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.ranks.RankDeleteEvent;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.libs.xseries.base.XBase;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.BuildingProcessor;
import org.kingdoms.managers.land.InteractProcessor;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.managers.land.block.KingdomsBlockBreakContext;
import org.kingdoms.managers.protectionsign.ProtectionSignManager;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.server.events.EntityMountEvent;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.reflection.Reflect;
import org.kingdoms.utils.kingdoms.NationZone;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class LandProtectionManager
implements Listener {
    public static final boolean DISABLED = KingdomsConfig.Claims.DISABLE_PROTECTION_SYSTEM.getManager().getBoolean();

    public LandProtectionManager() {
        if (!DISABLED) {
            if (Reflect.classExists("org.bukkit.event.entity.EntityTransformEvent")) {
                Kingdoms.get().registerEvent(new EntityTransformEventListener());
            }
            if (Reflect.classExists("org.bukkit.event.block.BlockFertilizeEvent")) {
                Kingdoms.get().registerEvent(new BlockFertilizeProtection());
            }
            if (Reflect.classExists("org.bukkit.event.player.PlayerHarvestBlockEvent")) {
                Kingdoms.get().registerEvent(new BerryBushHandler());
            }
            if (KingdomsConfig.Claims.DISABLE_CROPS_PHYSICS.getManager().getBoolean()) {
                Kingdoms.get().registerEvent(new FixBedPhysics());
            }
        }
    }

    public static void openKingdomItemGUI(Player player, KingdomBuilding<?> building, KingdomItemInteractEvent<?> event) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.UNCLAIMED$KINGDOM$ITEM.getGUIPath(), new MessagePlaceholderProvider().raw("kingdom-item-name", ((KingdomBuildingStyle)building.getStyle()).getDisplayName()));
        if (gui != null) {
            KingdomItemGUIContext.addOtherButtons(event, gui);
            KingdomItemGUIContext.putGUI(gui, building, event);
            gui.open();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankDelete(RankDeleteEvent event) {
        block3: {
            String node;
            Group group;
            block2: {
                group = event.getGroup();
                node = event.getRank().getNode();
                if (!(group instanceof Kingdom)) break block2;
                Kingdom kingdom = (Kingdom)group;
                for (KingdomPlayer member : kingdom.getKingdomPlayers()) {
                    @Nullable String memberRankNode = member.getRankNode();
                    if (!node.equals(memberRankNode)) continue;
                    member.unsafeSetRank(null);
                }
                break block3;
            }
            if (!(group instanceof Nation)) break block3;
            Nation nation = (Nation)group;
            for (KingdomPlayer member : nation.getKingdomPlayers()) {
                @Nullable String memberRankNode = member.getNationRankNode();
                if (!node.equals(memberRankNode)) continue;
                member.unsafeSetNationalRank(null);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityBlockChange(EntityChangeBlockEvent event) {
        Player player;
        KingdomPlayer kp;
        Kingdom playerKingdom;
        switch (event.getEntityType()) {
            case WITHER: 
            case FALLING_BLOCK: 
            case VILLAGER: {
                return;
            }
        }
        if (event.getEntity() instanceof Animals) {
            return;
        }
        Land land = Land.getLand(event.getBlock());
        if (land == null) {
            return;
        }
        Kingdom landKingdom = land.getKingdom();
        if (landKingdom == null) {
            return;
        }
        if (event.getEntity() instanceof Player && landKingdom.hasAttribute(playerKingdom = (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)(player = (Player)event.getEntity()))).getKingdom(), (RelationAttribute)StandardRelationAttribute.BUILD)) {
            return;
        }
        if (landKingdom.getUpgradeLevel(MiscUpgrade.ANTI_TRAMPLE) > 1) {
            event.setCancelled(true);
        }
    }

    public static boolean onEntityBreakOrDamage(EntityDamageByEntityEvent event, Player player) {
        boolean innocent;
        Entity entity2 = event.getEntity();
        boolean bl = innocent = entity2 instanceof Animals || entity2 instanceof NPC || entity2 instanceof WaterMob;
        if (!innocent && !LandProtectionManager.shouldCheckEntityInteraction(XEntityType.of((EntityType)event.getEntityType()))) {
            return false;
        }
        Land land = Land.getLand(entity2.getLocation());
        if (land == null) {
            return false;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return false;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return false;
        }
        if (!innocent) {
            SimpleLocation location = SimpleLocation.of(entity2.getLocation());
            BuildingProcessor processor = new BuildingProcessor(kp, location, false);
            processor.setAffectedEntity(entity2);
            processor.process();
            processor.sendMessages((CommandSender)player);
            if (!processor.isSuccessful()) {
                event.setCancelled(true);
            } else {
                processor.finalizeProcess();
            }
            return false;
        }
        if (kingdom.getMiscUpgrades().getOrDefault(MiscUpgrade.ANTI_TRAMPLE.getNamespace(), 0) >= 3 && !MiscUpgrade.ANTI_TRAMPLE.getConfig().getStringList("blacklisted-animals").contains(entity2.getType().name()) && !StandardRelationAttribute.CEASEFIRE.hasAttribute(kp.getKingdom(), kingdom)) {
            KingdomsLang.OTHER_KINGDOMS_KILL.sendError((CommandSender)player, "entity", entity2.getName());
            if (event.getDamager() instanceof Projectile) {
                event.getDamager().remove();
            }
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    public static boolean shouldCheckEntityInteraction(XEntityType type) {
        switch (type) {
            case ARMOR_STAND: 
            case PAINTING: 
            case ITEM_FRAME: 
            case VILLAGER: 
            case END_CRYSTAL: {
                return true;
            }
        }
        return type.name().endsWith("BOAT");
    }

    private static void handleEntityInteraction(PlayerInteractEntityEvent event) {
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Entity entity2 = event.getRightClicked();
        Player player = event.getPlayer();
        if (KingdomsDefaultPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player)) {
            return;
        }
        Land land = Land.getLand(entity2.getLocation());
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        if (!StandardRelationAttribute.INTERACT.hasAttribute(kp.getKingdom(), kingdom)) {
            KingdomsLang.OTHER_KINGDOMS_INTERACT.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void bucketEmpty(PlayerBucketEmptyEvent event) {
        LandProtectionManager.handleBucket((PlayerBucketEvent)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void bucketFill(PlayerBucketFillEvent event) {
        LandProtectionManager.handleBucket((PlayerBucketEvent)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onKingdomItemBurn(BlockBurnEvent event) {
        Block block = event.getBlock();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(block)) {
            return;
        }
        SimpleLocation location = SimpleLocation.of(block);
        SimpleChunkLocation chunk = location.toSimpleChunkLocation();
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && regulator.hasRule(Regulator.Rule.ALLOW_FIRE)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockFireSpread(BlockIgniteEvent event) {
        if (event.getCause() == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL || event.getCause() == BlockIgniteEvent.IgniteCause.FIREBALL) {
            return;
        }
        Block block = event.getBlock();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(block)) {
            return;
        }
        SimpleLocation location = SimpleLocation.of(block);
        SimpleChunkLocation chunk = location.toSimpleChunkLocation();
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && regulator.hasRule(Regulator.Rule.ALLOW_FIRE)) {
            return;
        }
        event.setCancelled(true);
    }

    private static void handleBucket(PlayerBucketEvent event) {
        Player player = event.getPlayer();
        if (!BuildingProcessor.basicChecks((OfflinePlayer)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        SimpleLocation location = SimpleLocation.of(event.getBlock());
        BuildingProcessor processed = new BuildingProcessor(kp, location, false);
        processed.setAffectedBlock(event.getBlock());
        processed.setPlacingItem(event.getItemStack());
        processed.process();
        processed.sendMessages((CommandSender)player);
        if (!processed.isSuccessful()) {
            event.setCancelled(true);
        } else {
            processed.finalizeProcess();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Kingdom kingdom;
        SimpleLocation toLoc = SimpleLocation.of(event.getToBlock());
        Land toLand = toLoc.toSimpleChunkLocation().getLand();
        if (toLand == null || !toLand.isClaimed()) {
            return;
        }
        if (toLand.isKingdomBlock(toLoc.toBlockVector())) {
            event.setCancelled(true);
            return;
        }
        Land fromLand = Land.getLand(event.getBlock());
        Kingdom kingdom2 = kingdom = fromLand == null ? null : fromLand.getKingdom();
        if (!toLand.getKingdom().hasAttribute(kingdom, (RelationAttribute)StandardRelationAttribute.BUILD)) {
            event.setCancelled(true);
        }
    }

    public static Nation disallowedNationZone(KingdomPlayer kp, SimpleChunkLocation chunk) {
        NationZone nationZone = Land.getNationZone(chunk);
        if (nationZone == null) {
            return null;
        }
        Nation nation = nationZone.getNation();
        return nation.isMember(kp.getKingdomId()) ? null : nation;
    }

    private static boolean handleEntityRemove(Entity entity2, SimpleLocation location) {
        if (!BuildingProcessor.basicChecks((OfflinePlayer)(entity2 instanceof Player ? (Player)entity2 : null))) {
            return false;
        }
        Land land = location.toSimpleChunkLocation().getLand();
        if (!(entity2 instanceof Player)) {
            return land != null && land.isClaimed();
        }
        Player player = (Player)entity2;
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        BuildingProcessor processed = new BuildingProcessor(kp, location, false).process();
        processed.sendMessages((CommandSender)player);
        processed.setAffectedEntity(entity2);
        if (!processed.isSuccessful()) {
            return true;
        }
        processed.finalizeProcess();
        return false;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public static void onPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (KingdomBuildingManager.isKingdomItem(event.getItemInHand())) {
            event.setCancelled(true);
            return;
        }
        if (!BuildingProcessor.basicChecks((OfflinePlayer)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        SimpleLocation location = SimpleLocation.of(event.getBlock());
        BuildingProcessor processed = new BuildingProcessor(kp, location, true);
        processed.setPlacingItem(event.getItemInHand());
        processed.process();
        if (!processed.isSuccessful()) {
            processed.sendMessages((CommandSender)player);
            event.setCancelled(true);
            event.setBuild(false);
        } else {
            processed.finalizeProcess();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public static void onBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        SimpleLocation location = SimpleLocation.of(event.getBlock());
        SimpleChunkLocation chunk = location.toSimpleChunkLocation();
        Land land = chunk.getLand();
        if (land != null) {
            ProtectionSign protection = ProtectionSign.getProtection(event.getBlock()).orElse(null);
            if (protection != null) {
                AtomicBoolean fail = new AtomicBoolean();
                KingdomsLang error = ProtectionSignManager.handleBreak(player, event.getBlock(), protection, fail);
                if (fail.get()) {
                    error.sendError((CommandSender)player, new Object[0]);
                    event.setCancelled(true);
                } else {
                    error.sendMessage((CommandSender)player);
                }
                return;
            }
            KingdomBlock kingdomBlock = land.getKingdomBlocks().get(location.toBlockVector());
            if (kingdomBlock != null) {
                KingdomsBlockBreakContext<KingdomBlock> context = new KingdomsBlockBreakContext<KingdomBlock>(event, kingdomBlock, kp);
                Messenger result = kingdomBlock.getKingdomBlockHandler().onBreak((KingdomsBlockBreakContext)Fn.cast(context));
                if (result != null) {
                    result.sendError((CommandSender)player, context.getMessageContext());
                    event.setCancelled(true);
                }
                context.finalizeProcess();
                return;
            }
        }
        if (DISABLED) {
            return;
        }
        BuildingProcessor processed = new BuildingProcessor(kp, location, false);
        processed.setAffectedBlock(event.getBlock());
        processed.process();
        if (!processed.isSuccessful()) {
            processed.sendMessages((CommandSender)player);
            event.setCancelled(true);
        } else {
            processed.finalizeProcess();
        }
    }

    public static boolean isItemEntity(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case ARMOR_STAND: 
            case ITEM_FRAME: 
            case PAINTING: 
            case END_CRYSTAL: {
                return true;
            }
        }
        if (type.name().endsWith("BOAT")) {
            return true;
        }
        if (VersionSupport.SUPPORTS_SpawnEggMeta ? item.getItemMeta() instanceof SpawnEggMeta : item.getType().name().endsWith("_EGG")) {
            return true;
        }
        return type.name().endsWith("MINECART");
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onRide(EntityMountEvent event) {
        if (DISABLED) {
            return;
        }
        Entity entity2 = event.getMount();
        if (entity2.getType() != XEntityType.MINECART.get()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (KingdomsDefaultPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player)) {
            return;
        }
        Land land = Land.getLand(entity2.getLocation());
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        if (!StandardRelationAttribute.INTERACT.hasAttribute(kp.getKingdom(), kingdom)) {
            KingdomsLang.OTHER_KINGDOMS_INTERACT.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        if (event.getAttacker() == null) {
            return;
        }
        if (LandProtectionManager.handleEntityRemove(event.getAttacker(), SimpleLocation.of(event.getVehicle().getLocation()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Kingdom landKingdom;
        Player player = event.getPlayer();
        if (event.getNewGameMode() != GameMode.CREATIVE) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        Land land = Land.getLand(player.getLocation());
        if (land == null || !land.isClaimed()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (LandProtectionManager.preventedGameMode(player, kingdom, landKingdom = land.getKingdom())) {
            KingdomsLang.LANDS_GAMEMODE_PROTECTION_ACTIVATED.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    private static boolean preventedGameMode(Player player, Kingdom kingdom, Kingdom landKingdom) {
        if (KingdomsDefaultPluginPermission.LAND_BYPASS_CREATIVE.hasPermission((CommandSender)player)) {
            return false;
        }
        if (!KingdomsConfig.Relations.FORCE_SURVIVAL_MODE.getManager().getBoolean()) {
            return false;
        }
        if (StandardRelationAttribute.CEASEFIRE.hasAttribute(kingdom, landKingdom) && StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(kingdom, landKingdom)) {
            return false;
        }
        boolean wasAllowedToFly = player.isFlying();
        player.setGameMode(GameMode.SURVIVAL);
        if (wasAllowedToFly) {
            player.setAllowFlight(true);
            player.setFlying(true);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onTeleportProtection(LandChangeEvent event) {
        Kingdom landKingdom;
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        if (event.getCause() == null) {
            return;
        }
        Land land = event.getToLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        KingdomPlayer kp = event.getKingdomPlayer();
        if (kp.isAdmin()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        boolean prevented = LandProtectionManager.preventedGameMode(player, kingdom, landKingdom = land.getKingdom());
        if (prevented) {
            KingdomsLang.LANDS_GAMEMODE_PROTECTION.sendError((CommandSender)player, new Object[0]);
        }
        if (!(!prevented || event.getCause().getCause() != PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || StandardRelationAttribute.CEASEFIRE.hasAttribute(kingdom, landKingdom) && StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(kingdom, landKingdom))) {
            KingdomsLang.LANDS_PORTAL_PROTECTION.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        InteractProcessor processor = new InteractProcessor(event).process();
        if (processor.isSuccessful()) {
            processor.finalizeProcess();
        } else {
            processor.sendMessages((CommandSender)event.getPlayer());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        if (LandProtectionManager.handleEntityRemove(event.getRemover(), SimpleLocation.of(event.getEntity().getLocation()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void entityInteract(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Minecart || LandProtectionManager.shouldCheckEntityInteraction(XEntityType.of((EntityType)event.getRightClicked().getType()))) {
            LandProtectionManager.handleEntityInteraction(event);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void entityInteractAt(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked() instanceof ArmorStand) {
            LandProtectionManager.handleEntityInteraction((PlayerInteractEntityEvent)event);
        }
    }

    private static final class EntityTransformEventListener
    implements Listener {
        private EntityTransformEventListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onEntityTransform(EntityTransformEvent event) {
            if (DISABLED) {
                return;
            }
            if (event.getTransformReason() == EntityTransformEvent.TransformReason.LIGHTNING) {
                return;
            }
            if (MiscUpgrade.ANTI_TRAMPLE.isEnabled()) {
                return;
            }
            Land land = Land.getLand(event.getTransformedEntity().getLocation());
            if (land == null) {
                return;
            }
            Kingdom kingdom = land.getKingdom();
            if (kingdom == null) {
                return;
            }
            int lvl = kingdom.getUpgradeLevel(MiscUpgrade.ANTI_TRAMPLE);
            if (lvl >= 3) {
                event.setCancelled(true);
            }
        }
    }

    private static final class BlockFertilizeProtection
    implements Listener {
        private BlockFertilizeProtection() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onGrow(BlockFertilizeEvent event) {
            Player player = event.getPlayer();
            if (DISABLED) {
                return;
            }
            if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(event.getBlock())) {
                return;
            }
            KingdomPlayer kp = player == null ? null : KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            List blocks = event.getBlocks();
            for (BlockState block : blocks) {
                SimpleLocation loc = SimpleLocation.of(block.getLocation());
                SimpleChunkLocation chunk = loc.toSimpleChunkLocation();
                Land land = chunk.getLand();
                MessagePlaceholderProvider settings = LocationUtils.getLocationEdits(new MessagePlaceholderProvider().withContext(player), loc, "");
                if (land != null && land.isKingdomBlock(loc.toBlockVector())) {
                    if (player != null) {
                        KingdomsLang.LANDS_GROW_STRUCTURE_ERROR.sendError((CommandSender)player, settings);
                        KingdomsLang.LANDS_GROW_STRUCTURE_PROTECTED.sendError((CommandSender)player, settings);
                    }
                    event.setCancelled(true);
                    return;
                }
                if (player == null) continue;
                BuildingProcessor processed = new BuildingProcessor(kp, loc, false);
                processed.setAffectedBlock(event.getBlock());
                processed.process();
                if (processed.isSuccessful()) continue;
                KingdomsLang.LANDS_GROW_STRUCTURE_ERROR.sendError((CommandSender)player, settings);
                processed.sendMessages((CommandSender)player);
                event.setCancelled(true);
                return;
            }
        }
    }

    private static final class BerryBushHandler
    implements Listener {
        private BerryBushHandler() {
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onSweetBerryHarvesting(PlayerHarvestBlockEvent event) {
            if (event.getHarvestedBlock().getType() != Material.SWEET_BERRY_BUSH) {
                return;
            }
            Player player = event.getPlayer();
            if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            if (kp.isAdmin() || KingdomsDefaultPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player)) {
                return;
            }
            Block block = event.getHarvestedBlock();
            SimpleChunkLocation chunk = SimpleChunkLocation.of(block);
            Land land = chunk.getLand();
            if (land == null) {
                return;
            }
            Kingdom kingdom = kp.getKingdom();
            if (!StandardRelationAttribute.USE.hasAttribute(kingdom, land.getKingdom())) {
                KingdomsLang.OTHER_KINGDOMS_USE.sendMessage((CommandSender)player);
            } else if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.USE)) {
                StandardKingdomPermission.USE.sendDeniedMessage(player);
            } else {
                return;
            }
            event.setCancelled(true);
        }
    }

    public static final class FixBedPhysics
    implements Listener {
        protected static final Set<SimpleLocation> PREVENT = new HashSet<SimpleLocation>();
        public static boolean USED = false;
        protected static final BlockFace[] BED_CRITICAL_FACES = new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};

        public FixBedPhysics() {
            USED = true;
        }

        private static void unused(ItemStack item, Block block) {
            if (USED && XTag.BEDS.isTagged((XBase)XMaterial.matchXMaterial((ItemStack)item))) {
                SimpleLocation center = SimpleLocation.of(block);
                ArrayList<SimpleLocation> remove = new ArrayList<SimpleLocation>(BED_CRITICAL_FACES.length);
                for (BlockFace facing : BED_CRITICAL_FACES) {
                    SimpleLocation near = center.getRelative(facing.getModX(), facing.getModY(), facing.getModZ());
                    Block relativeBlock = near.getBlock();
                    remove.add(near);
                }
                PREVENT.addAll(remove);
                Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> PREVENT.removeAll(remove), 1L);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onSignPhysicsBreak(BlockPhysicsEvent event) {
            XMaterial material = XMaterial.matchXMaterial((Material)event.getBlock().getType());
            if (XTag.CROPS.isTagged((XBase)material)) {
                event.setCancelled(true);
            }
        }
    }
}

