/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.pvp.PvPManager;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;
import org.kingdoms.utils.paper.PaperEvents;
import org.kingdoms.utils.string.Strings;

public final class LandEffectsManager
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onPotionEffectsThrow(PotionSplashEvent event) {
        ThrownPotion potion = event.getPotion();
        if (!(potion.getShooter() instanceof Player)) {
            return;
        }
        List<String> disallowed = KingdomsConfig.Claims.POTION_PROTECTED_EFFECTS.getManager().getStringList();
        QuickEnumSet disallowedSet = new QuickEnumSet((Enum[])XPotion.VALUES);
        for (String string : disallowed) {
            Optional xPotion = XPotion.matchXPotion((String)string);
            xPotion.ifPresent(disallowedSet::add);
        }
        boolean contains = false;
        for (PotionEffect effect : potion.getEffects()) {
            if (!disallowedSet.contains(XPotion.matchXPotion((PotionEffectType)effect.getType()))) continue;
            contains = true;
            break;
        }
        if (!contains) {
            return;
        }
        Player player = (Player)potion.getShooter();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        for (LivingEntity entity2 : event.getAffectedEntities()) {
            if (player == entity2 || !(entity2 instanceof Player) || PvPManager.canFight(player, (Player)entity2)) continue;
            event.setIntensity(entity2, 0.0);
        }
    }

    public static Listener createBeaconEffects() {
        return PaperEvents.create(LandEffectsManager::onOwnedBeaconEffect);
    }

    private static void onOwnedBeaconEffect(PaperEvents.BeaconEffectEvent event) {
        Player player = event.getPlayer();
        Land land = Land.getLand(event.getBlock());
        if (land == null || !land.isClaimed()) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!land.getKingdom().hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.CEASEFIRE)) {
            event.setCancelled(true);
        }
    }

    static {
        EnumMap<KingdomRelation, List> effects = new EnumMap<KingdomRelation, List>(KingdomRelation.class);
        for (KingdomRelation relation : KingdomRelation.VALUES) {
            List<String> relEffects = KingdomsConfig.Relations.RELATIONS_EFFECTS.getManager().withOption("relation", Strings.configOption(relation)).getStringList();
            effects.put(relation, XPotion.parseEffects(relEffects));
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Land land;
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                Kingdom kingdom = kp.getKingdom();
                if (kp.isAdmin() || (land = SimpleChunkLocation.of(player.getLocation()).getLand()) == null || !land.isClaimed()) continue;
                KingdomRelation relation = land.getKingdom().getRelationWith(kingdom);
                List relEffects = (List)effects.get((Object)relation);
                Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                    for (XPotion.Effect effect : relEffects) {
                        effect.apply((LivingEntity)player);
                    }
                });
            }
        }, 10L, 200L);
    }
}

