/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.awt.Color;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.item.ItemDeserializationContext;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.constants.item.KingdomItemData;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingConstruction;
import org.kingdoms.constants.land.building.BuildingConstructionState;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.building.info.BuildingConstructionValidation;
import org.kingdoms.constants.land.building.info.BuildingSchematic;
import org.kingdoms.constants.land.building.info.BuildingSettings;
import org.kingdoms.constants.land.building.info.block.BlockInfo;
import org.kingdoms.constants.land.building.schema.EvaluatedBuildingMapping;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.nbt.NBTDataProvider;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.lands.AsyncBatchLandLoadEvent;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.LandUnloadEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.libs.xseries.base.XBase;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.HoverMessage;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.limit.BuildingLimiter;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContext;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContextBuilding;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContextItem;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.platform.bukkit.item.ItemNBT;
import org.kingdoms.platform.bukkit.location.BukkitWorld;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Direction;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.display.visualizer.PreviewBlockInfo;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.time.internal.TickDuration;

public final class KingdomBuildingManager
implements Listener {
    public static final Namespace PREVIEW_NS = Namespace.kingdoms("KINGDOM_BUILDING");
    public static final Namespace ORIGIN_NS = Namespace.kingdoms("ORIGIN");
    private static final MethodHandle SET_SHOOT_CONSUMABLE_ITEM;

    private static boolean shouldNotProtectAgainstInventory(Inventory inv) {
        switch (inv.getType()) {
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case HOPPER: 
            case DROPPER: 
            case DISPENSER: {
                return true;
            }
        }
        return XReflection.supports((int)11) && inv.getType() == InventoryType.SHULKER_BOX;
    }

    public static boolean isKingdomItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        NBTTagCompound nbt = ItemNBT.getTag(item);
        return nbt.has("Kingdoms");
    }

    public static void preview(Player player, KingdomBuilding<?> item) {
        Kingdoms.taskScheduler().async().delayed(TickDuration.ONE, () -> KingdomBuildingManager.validateAndPreview(player, item, false));
    }

    public static <T extends KingdomBuilding<S>, S extends KingdomBuildingStyle<?, ?, ?>> Pair<T, S> getPairs(KingdomsBlockPlaceContext<T> context, KingdomBuildingHandler<T> handler) {
        KingdomBuilding<Object> building;
        Object style;
        if (context instanceof KingdomsBlockPlaceContextItem) {
            KingdomItem kingdomItem = ((KingdomsBlockPlaceContextItem)context).getKingdomItem();
            KingdomItemData structureItemData = kingdomItem.getData().get(handler.getNamespace());
            NBTTagCompound structureNBT = (NBTTagCompound)structureItemData.getData();
            style = handler.getRegistry().getStyle(structureNBT.getString("type"));
            building = ((KingdomBuildingType)((KingdomBuildingStyle)style).getType()).build(new KingdomItemBuilder((KingdomBuildingStyle)Fn.cast(style), context.getOrigin(), context.getPlayer()));
            building.deserialize(new ItemDeserializationContext<SectionableDataGetter>(new NBTDataProvider(structureNBT), kingdomItem, structureNBT));
        } else {
            building = (KingdomBuilding)((KingdomsBlockPlaceContextBuilding)context).getBuilding();
            style = building.getStyle();
        }
        return Pair.of(building, style);
    }

    public static boolean validateAndPreview(Player player, KingdomBuilding<?> item, boolean isValidating) {
        Direction direction = Direction.cardinalDirectionFromYaw(player.getLocation().getYaw()).getOppositeFace();
        BuildingSchematic info = new BuildingSchematic(BuildingConstructionType.PREVIEW, item.getOrigin().toBlockVector().inWorld(new BukkitWorld(player.getWorld())), direction, item.getBuildingSettings(item.getLevel()));
        BuildingConstruction building = item.prepareBuilding(info);
        Map<String, BuildingSettings.Validation> previewSettings = info.getSettings().getPreview();
        Map<BlockVector3, BuildingConstructionValidation> validatedBlocks = building.validateBlocks();
        HashMap<Messenger, Pair> sharedProblems = new HashMap<Messenger, Pair>();
        boolean hasProblem = false;
        try (StructureVisualizer preview = new StructureVisualizer(PREVIEW_NS, player, validatedBlocks.keySet(), KingdomsConfig.KINGDOM_ITEMS_PREVIEW_DURATION.getManager().getTime());){
            SimpleChunkLocation originChunk = item.getOrigin().toSimpleChunkLocation();
            Map<BlockVector3, EvaluatedBuildingMapping> schema = ((KingdomBuildingStyle)item.getStyle()).matchSchema(info.getOrigin(), item.getLevel());
            for (Map.Entry<BlockVector3, BuildingConstructionValidation> entry : validatedBlocks.entrySet()) {
                BlockVector3 immLoc = entry.getKey();
                BuildingConstructionValidation validation = entry.getValue();
                boolean skipEntryMessage = false;
                BlockInfo actualBlock = validation.getActualBlock();
                SimpleChunkLocation blockChunk = SimpleLocation.of(originChunk.getWorld(), immLoc).toSimpleChunkLocation();
                BuildingSettings.Validation validationEntry = null;
                if (!originChunk.equals(blockChunk)) {
                    validationEntry = previewSettings.get("out-of-chunk");
                } else {
                    EvaluatedBuildingMapping mapping = schema.get(immLoc);
                    if (mapping != null) {
                        if (mapping.matches()) {
                            validationEntry = previewSettings.get("ok");
                        } else {
                            hasProblem = true;
                            skipEntryMessage = true;
                            validationEntry = previewSettings.get("schema-mismatch");
                        }
                    } else {
                        Block block = player.getWorld().getBlockAt(immLoc.getX(), immLoc.getY(), immLoc.getZ());
                        XMaterial mat = XMaterial.matchXMaterial((Material)block.getType());
                        if (!XTag.AIR.isTagged((XBase)mat) && !XTag.FLUID.isTagged((XBase)mat)) {
                            validationEntry = previewSettings.get("conflict");
                        }
                    }
                }
                if (validationEntry == null) {
                    validationEntry = previewSettings.get("ok");
                }
                Color color = validationEntry == null ? Color.PINK : validationEntry.getColor();
                if (!skipEntryMessage && validationEntry != null && validationEntry.getMessage() != null) {
                    BuildingSettings.Validation finalConfigEntry = validationEntry;
                    Pair shared = sharedProblems.computeIfAbsent(validationEntry.getMessage(), k -> Pair.of(finalConfigEntry.getType(), new ArrayList()));
                    ((List)shared.getValue()).add(immLoc);
                }
                preview.add(immLoc, new PreviewBlockInfo(actualBlock, color));
            }
            for (Map.Entry<BlockVector3, Object> entry : schema.entrySet()) {
                EvaluatedBuildingMapping evaluated = (EvaluatedBuildingMapping)entry.getValue();
                if (evaluated.matches()) continue;
                hasProblem = true;
                BlockVector3 loc = entry.getKey();
                Block block = player.getLocation().getWorld().getBlockAt(loc.getX(), loc.getY(), loc.getZ());
                evaluated.getMapping().getMismatchMessage().sendError((CommandSender)player, info.getSettings().getMessageContext().clone().raw("schema_displayname", evaluated.getMapping().getDisplayName()).parse("location", LocationUtils.parseLocation(loc)).parse("block", XMaterial.matchXMaterial((Material)block.getType())));
            }
            for (Map.Entry<BlockVector3, Object> entry : sharedProblems.entrySet()) {
                if (((Pair)entry.getValue()).getKey() == BuildingSettings.ValidationType.ERROR) {
                    hasProblem = true;
                }
                ((Messenger)((Object)entry.getKey())).sendMessage((CommandSender)player, info.getSettings().getMessageContext().clone().parse("locations", ((List)((Pair)entry.getValue()).getValue()).stream().map(x -> {
                    Block block = player.getLocation().getWorld().getBlockAt(x.getX(), x.getY(), x.getZ());
                    return new HoverMessage("{$sep}[" + LocationUtils.parseLocation(x) + "{$sep}]", "{$p}Block{$colon} {$s}" + XMaterial.matchXMaterial((Material)block.getType()), "").toString();
                }).collect(Collectors.joining(" {$sep}- "))));
            }
            if (hasProblem) {
                preview.setColor(Color.RED);
            } else {
                preview.setColor(Color.WHITE);
            }
            preview.setColor(new Color(0, 100, 255, 200));
            preview.displayBlocks();
            preview.blockMarkers();
            if (!isValidating || hasProblem) {
                preview.start();
            }
            if (!isValidating) {
                KingdomsLang.COMMAND_BUILDING_PREVIEW_PREVIEWING.sendMessage((CommandSender)player, new MessagePlaceholderProvider().withContext(player).raw("building", ((KingdomBuildingStyle)item.getStyle()).getDisplayName()));
            }
            boolean bl = !hasProblem;
            return bl;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUnclaim(UnclaimLandEvent event) {
        boolean removeInUnclaimed = KingdomsConfig.Structures.REMOVE_UNCLAIMED.getManager().getBoolean();
        Kingdom kingdom = event.getKingdom();
        for (Land land : event.getLands()) {
            for (Structure structure : land.getStructures().values().toArray(new Structure[0])) {
                if (!removeInUnclaimed && !((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus()) continue;
                KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
                ctx.dontCallEvent();
                ctx.setRemoveInstantly(true);
                structure.remove(ctx);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDropItem(PlayerDropItemEvent event) {
        Item dropped = event.getItemDrop();
        ItemStack item = dropped.getItemStack();
        NBTTagCompound nbt = ItemNBT.getTag(item);
        if ((nbt = nbt.tryGetTag("Kingdoms", NBTTagType.COMPOUND)) == null) {
            return;
        }
        String tag = (String)nbt.get("Structure", NBTTagType.STRING);
        KingdomBuildingStyle kingdomItem = null;
        if (tag != null) {
            kingdomItem = StructureRegistry.get().getStyle(tag);
        } else {
            tag = (String)nbt.get("Turret", NBTTagType.STRING);
            if (tag != null) {
                kingdomItem = TurretRegistry.get().getStyle(tag);
            }
        }
        if (kingdomItem != null) {
            kingdomItem.droppedItemName(dropped);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(AsyncBatchLandLoadEvent event) {
        for (Land land : event.getLands()) {
            for (Turret turret : land.getTurrets().values()) {
                KingdomBuildingManager.changeState(turret, true);
            }
            for (Structure structure : land.getStructures().values()) {
                KingdomBuildingManager.changeState(structure, true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkUnload(LandUnloadEvent event) {
        Land land = event.getLand();
        for (Turret turret : land.getTurrets().values()) {
            KingdomBuildingManager.changeState(turret, false);
        }
        for (Structure structure : land.getStructures().values()) {
            KingdomBuildingManager.changeState(structure, false);
        }
    }

    private static void changeState(KingdomBuilding<?> building, boolean loaded) {
        Building actualBuilding = building.getBuilding();
        if (!(actualBuilding instanceof BuildingConstruction)) {
            building.getVisualsManager().updateVisuals();
            return;
        }
        BuildingConstruction ctor = (BuildingConstruction)actualBuilding;
        if (ctor.getState() == BuildingConstructionState.AWAITING_CONTINUATION) {
            ctor.continueLastState();
        }
        BlockVector2 chunk = building.getOrigin().toSimpleChunkLocation().toBlockVector();
        if (loaded) {
            ctor.onChunkLoad(chunk);
        } else {
            ctor.onChunkUnload(chunk);
        }
        building.getVisualsManager().updateVisuals();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(ClaimLandEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer().getPlayer();
        if (player == null) {
            return;
        }
        Kingdom kingdom = event.getKingdom();
        for (Land land : event.getLands()) {
            MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(kingdom).parse("chunk", KingdomsLang.LOCATIONS_CHUNK.parse(LocationUtils.getChunkEdits(land.getLocation())));
            if (!((BuildingLimiter)BuildingLimiter.ofStructures(kingdom, land).process()).removeExtra().isEmpty()) {
                KingdomsLang.STRUCTURES_LIMIT_REMOVED_EXTRA.sendError((CommandSender)player, settings);
            }
            if (((BuildingLimiter)BuildingLimiter.ofTurrets(kingdom, land).process()).removeExtra().isEmpty()) continue;
            KingdomsLang.TURRETS_LIMIT_REMOVED_EXTRA.sendError((CommandSender)player, settings);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemPickup(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        if (!PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (KingdomsDefaultPluginPermission.CREATIVE_PICKUP.hasPermission((CommandSender)player, true)) {
            return;
        }
        ItemStack item = event.getItem().getItemStack();
        if (KingdomBuildingManager.isKingdomItem(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryUse(InventoryClickEvent event) {
        Inventory inv = event.getClickedInventory();
        if (inv == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (KingdomsDefaultPluginPermission.INVENTORY_BYPASS.hasPermission((CommandSender)player, true)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (KingdomBuildingManager.isKingdomItem(item)) {
            KingdomsLang.KINGDOM_ITEM_INVENTORY.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onKingdomItemShoot(EntityShootBowEvent event) {
        if (!XReflection.supports((int)13)) {
            event.setCancelled(true);
            return;
        }
        ItemStack itemBeingShot = event.getConsumable();
        if (itemBeingShot == null) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!KingdomItem.isKingdomItem(itemBeingShot)) {
            return;
        }
        Player shooter = (Player)event.getEntity();
        if (shooter.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        for (ItemStack item : shooter.getInventory().getStorageContents()) {
            if (item == null || !item.getType().name().contains("ARROW") || KingdomItem.isKingdomItem(item)) continue;
            event.setConsumeItem(false);
            try {
                SET_SHOOT_CONSUMABLE_ITEM.invoke(event, item);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        event.setConsumeItem(false);
        event.setCancelled(true);
        KingdomsLang.KINGDOM_ITEM_SHOOT.sendError((CommandSender)shooter, new Object[0]);
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseKingdomItemForCrafting(CraftItemEvent event) {
        boolean result = true;
        for (ItemStack item : event.getInventory().getContents()) {
            if (result) {
                result = false;
                continue;
            }
            if (item.getType() == Material.AIR || !KingdomItem.isKingdomItem(item)) continue;
            KingdomsLang.KINGDOM_ITEM_CRAFT.sendError((CommandSender)event.getWhoClicked(), new Object[0]);
            event.setCancelled(true);
            return;
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle shootSetter = null;
        try {
            if (XReflection.supports((int)14)) {
                Field field = EntityShootBowEvent.class.getDeclaredField("consumable");
                field.setAccessible(true);
                shootSetter = lookup.unreflectSetter(field);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        SET_SHOOT_CONSUMABLE_ITEM = shootSetter;
    }
}

