/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.processor.AbstractKingdomsProcessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.libs.xseries.base.XBase;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.turrets.TurretManager;
import org.kingdoms.managers.land.BuildingProcessor;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.managers.land.block.KingdomsBlockInteractContext;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContext;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContextItem;
import org.kingdoms.managers.protectionsign.ProtectionSignManager;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.platform.bukkit.item.ItemNBT;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.string.StringMatcher;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/managers/land/InteractProcessor;", "Lorg/kingdoms/abstraction/processor/AbstractKingdomsProcessor;", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "<init>", "(Lorg/bukkit/event/player/PlayerInteractEvent;)V", "reprocess", "process", "processIssue", "Lorg/kingdoms/locale/messenger/Messenger;", "others", "Lorg/kingdoms/locale/KingdomsLang;", "land", "Lorg/kingdoms/constants/land/Land;", "notPlate", "", "core"})
@SourceDebugExtension(value={"SMAP\nInteractProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractProcessor.kt\norg/kingdoms/managers/land/InteractProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1#2:279\n1#2:290\n1611#3,9:280\n1863#3:289\n1864#3:291\n1620#3:292\n*S KotlinDebug\n*F\n+ 1 InteractProcessor.kt\norg/kingdoms/managers/land/InteractProcessor\n*L\n121#1:290\n121#1:280,9\n121#1:289\n121#1:291\n121#1:292\n*E\n"})
public final class InteractProcessor
extends AbstractKingdomsProcessor {
    @NotNull
    private final PlayerInteractEvent event;

    public InteractProcessor(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.event = event;
    }

    @Override
    @NotNull
    public InteractProcessor reprocess() {
        return new InteractProcessor(this.event);
    }

    @Override
    @NotNull
    public InteractProcessor process() {
        super.process();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Messenger processIssue() {
        boolean notPlate;
        boolean handInteraction;
        Block block = this.event.getClickedBlock();
        boolean bl = handInteraction = this.event.getAction() == Action.RIGHT_CLICK_BLOCK || block != null && block.getType() == Material.DRAGON_EGG;
        if (!handInteraction && this.event.getAction() != Action.PHYSICAL) {
            return null;
        }
        Player player = this.event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        if (Kingdoms.isStrict()) {
            Block block2 = block;
            Intrinsics.checkNotNull((Object)block2);
            if (XBlock.isAir((Material)block2.getType())) {
                KLogger.debug((DebugNS)KingdomsDebug.HACK, () -> InteractProcessor.processIssue$lambda$0(this, block));
                return null;
            }
        }
        Block block3 = block;
        Intrinsics.checkNotNull((Object)block3);
        Land land = Land.getLand(block3);
        ItemStack item = this.event.getItem();
        boolean isInDisabledWorld = KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player2);
        if (handInteraction) {
            Nation nationZone;
            Object $i$f$mapNotNull2;
            KingdomBlock kingdomBlock;
            BlockVector3 location = BlockVector3.Companion.of(block.getX(), block.getY(), block.getZ());
            boolean exceedsBuildLimit = LocationUtils.exceedsBuildLimit(this.event);
            if (!exceedsBuildLimit && item != null) {
                Object legacyTag;
                KingdomItem kingdomItem = KingdomItem.Companion.getKingdomItem(item);
                KingdomBuildingHandler handler = null;
                if (kingdomItem == null) {
                    NBTTagCompound nbt;
                    NBTTagCompound nBTTagCompound = nbt = ItemNBT.getTag(item);
                    Intrinsics.checkNotNull((Object)nBTTagCompound);
                    nbt = nBTTagCompound.tryGetTag("Kingdoms", NBTTagType.COMPOUND);
                    if (nbt != null) {
                        Namespace namespace;
                        Namespace namespace2;
                        String string = (String)nbt.get("Namespace", NBTTagType.STRING);
                        if (string != null) {
                            String it = string;
                            boolean bl2 = false;
                            namespace2 = Namespace.fromString(it);
                        } else {
                            namespace2 = namespace = null;
                        }
                        if (namespace != null) {
                            handler = (KingdomBuildingHandler)((Object)Kingdoms.get().getKingdomsBlockRegistry().getRegistered(namespace));
                        } else {
                            legacyTag = (String)nbt.get("Structure", NBTTagType.STRING);
                            if (legacyTag != null) {
                                handler = TurretManager.INSTANCE;
                                return null;
                            }
                            legacyTag = (String)nbt.get("Turret", NBTTagType.STRING);
                            if (legacyTag != null) {
                                handler = TurretManager.INSTANCE;
                            }
                        }
                    }
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    Set<Namespace> set = kingdomItem.getData().keySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                    Iterable $this$mapNotNull$iv = set;
                    boolean $i$f$mapNotNull2 = false;
                    legacyTag = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        KingdomBuildingHandler it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl3 = false;
                        Namespace it = (Namespace)element$iv$iv;
                        boolean bl4 = false;
                        if ((KingdomBuildingHandler)((Object)Kingdoms.get().getKingdomsBlockRegistry().getRegistered(it)) == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    handler = (KingdomBuildingHandler)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                }
                if (kingdomItem != null && handler != null) {
                    if (isInDisabledWorld) {
                        return KingdomsLang.STRUCTURES_DISABLED_WORLD;
                    }
                    KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player2);
                    Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
                    Block block4 = this.event.getClickedBlock();
                    Intrinsics.checkNotNull((Object)block4);
                    SimpleLocation simpleLocation = SimpleLocation.of(block4.getRelative(this.event.getBlockFace()));
                    Intrinsics.checkNotNullExpressionValue((Object)simpleLocation, (String)"of(...)");
                    KingdomsBlockPlaceContextItem interactContext = new KingdomsBlockPlaceContextItem(this.event, kingdomPlayer, simpleLocation, land, kingdomItem);
                    Object t = Fn.cast(interactContext);
                    Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
                    Messenger messenger = handler.onPlace((KingdomsBlockPlaceContext)t);
                    if (messenger != null) {
                        messenger.sendError((CommandSender)player2, interactContext.getMessageContext());
                    }
                    interactContext.sendMessages((CommandSender)player2);
                    interactContext.finalizeProcess();
                }
            }
            if (land == null) {
                return null;
            }
            if (isInDisabledWorld) {
                return null;
            }
            if (this.event.getHand() == EquipmentSlot.HAND && (kingdomBlock = land.getKingdomBlocks().get(location)) != null) {
                Object t = Fn.cast(kingdomBlock);
                Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
                KingdomBlock kingdomBlock2 = (KingdomBlock)t;
                KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player2);
                Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
                KingdomsBlockInteractContext<KingdomBlock> interactContext = new KingdomsBlockInteractContext<KingdomBlock>(this.event, kingdomBlock2, kingdomPlayer);
                KingdomBuildingHandler<?> kingdomBlockHandler = kingdomBlock.getKingdomBlockHandler();
                if (kingdomBlockHandler != null) {
                    Object t2 = Fn.cast(interactContext);
                    Intrinsics.checkNotNullExpressionValue(t2, (String)"cast(...)");
                    $i$f$mapNotNull2 = kingdomBlockHandler.onInteract((KingdomsBlockInteractContext)t2);
                    if ($i$f$mapNotNull2 != null) {
                        $i$f$mapNotNull2.sendError((CommandSender)player2, interactContext.getMessageContext());
                    }
                    interactContext.sendMessages((CommandSender)player2);
                    interactContext.finalizeProcess();
                }
            }
            if (LandProtectionManager.DISABLED) {
                return null;
            }
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player2);
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
            KingdomPlayer kp = kingdomPlayer;
            if (!kp.isAdmin() && !KingdomsDefaultPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player2) && (nationZone = LandProtectionManager.disallowedNationZone(kp, land.getLocation())) != null) {
                String string = nationZone.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.var("nation", string);
                return KingdomsLang.LANDS_NATION_ZONE_INTERACT;
            }
            if (!exceedsBuildLimit && item != null && LandProtectionManager.isItemEntity(item)) {
                SimpleLocation loc = SimpleLocation.of(block.getRelative(this.event.getBlockFace()));
                Intrinsics.checkNotNull((Object)loc);
                $i$f$mapNotNull2 = new BuildingProcessor(kp, loc, true);
                BuildingProcessor $this$processIssue_u24lambda_u243 = $i$f$mapNotNull2;
                boolean bl6 = false;
                $this$processIssue_u24lambda_u243.setPlacingItem(item);
                BuildingProcessor processed = ((BuildingProcessor)$i$f$mapNotNull2).process();
                this.inherit(processed);
            }
        }
        if (isInDisabledWorld) {
            return null;
        }
        if (land == null) {
            return null;
        }
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player2);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        KingdomPlayer kp = kingdomPlayer;
        if (kp.isInvading()) {
            boolean whitelist = KingdomsConfig.Invasions.ALLOW_INTERACTABLE_WHITELIST.getManager().getBoolean();
            List<String> blocks = KingdomsConfig.Invasions.ALLOW_INTERACTABLE_BLOCKS.getManager().getStringList();
            for (String blockFilter : blocks) {
                XMaterial mat;
                StringMatcher matcher = StringMatcher.fromString(blockFilter);
                Intrinsics.checkNotNullExpressionValue((Object)XMaterial.matchXMaterial((Material)block.getType()), (String)"matchXMaterial(...)");
                if (whitelist != matcher.matches(mat.name())) continue;
                return null;
            }
        }
        boolean bl7 = notPlate = this.event.getAction() != Action.PHYSICAL || !StringsKt.endsWith$default((String)block.getType().name(), (String)"_PLATE", (boolean)false, (int)2, null);
        if (notPlate) {
            XMaterial xMaterial = XMaterial.matchXMaterial((Material)block.getType());
            Intrinsics.checkNotNullExpressionValue((Object)xMaterial, (String)"matchXMaterial(...)");
            XMaterial mat = xMaterial;
            if (XTag.STAIRS.isTagged((XBase)mat) || !XTag.FENCES.isTagged((XBase)mat) && !XTag.isInteractable((XMaterial)mat)) {
                return null;
            }
            if (this.event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Optional<ProtectionSign> optional = ProtectionSign.getProtection(block);
                Intrinsics.checkNotNullExpressionValue(optional, (String)"getProtection(...)");
                Optional<ProtectionSign> protectionOpt = optional;
                if (protectionOpt.isPresent()) {
                    if (!land.isClaimed() && !KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean()) {
                        return KingdomsLang.PROTECTED_SIGNS_UNCLAIMED_INTERACT;
                    }
                    return ProtectionSignManager.handleProtectedBlock(this.event, protectionOpt.get(), this);
                }
            }
        }
        if (!land.isClaimed()) {
            return null;
        }
        return this.others(land, notPlate);
    }

    @Nullable
    public final KingdomsLang others(@NotNull Land land, boolean notPlate) {
        boolean isConsumableInHand;
        Boolean interact;
        Intrinsics.checkNotNullParameter((Object)land, (String)"land");
        Block block = this.event.getClickedBlock();
        Intrinsics.checkNotNull((Object)block);
        Block block2 = block;
        Player player = this.event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ItemStack item = this.event.getItem();
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && (interact = regulator.canInteract(player2.getUniqueId(), XMaterial.matchXMaterial((Material)block2.getType()))) != null) {
            if (interact.booleanValue()) {
                return null;
            }
            return KingdomsLang.REGULATOR_INTERACTIONS_DISALLOWED;
        }
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player2);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        KingdomPlayer kp = kingdomPlayer;
        if (kp.isAdmin() || KingdomsDefaultPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player2)) {
            return null;
        }
        Kingdom kingdom = kp.getKingdom();
        boolean bl = isConsumableInHand = item != null && item.getType().isEdible();
        if (!isConsumableInHand && item != null) {
            XMaterial xMaterial = XMaterial.matchXMaterial((ItemStack)item);
            Intrinsics.checkNotNullExpressionValue((Object)xMaterial, (String)"matchXMaterial(...)");
            XMaterial mat = xMaterial;
            isConsumableInHand = mat == XMaterial.SHIELD || mat == XMaterial.BOW || mat == XMaterial.CROSSBOW;
        }
        boolean showMessage = notPlate && !isConsumableInHand;
        List<String> list = KingdomsConfig.Ranks.INTERACT_BLOCKS.getManager().getStringList();
        XMaterial xMaterial = XMaterial.matchXMaterial((Material)block2.getType());
        Intrinsics.checkNotNullExpressionValue((Object)xMaterial, (String)"matchXMaterial(...)");
        XMaterial mat = xMaterial;
        if (XTag.anyMatch((Object)mat, (Collection)XTag.stringMatcher((Collection)list, null))) {
            if (!StandardRelationAttribute.INTERACT.hasAttribute(kingdom, land.getKingdom())) {
                this.event.setUseInteractedBlock(Event.Result.DENY);
                if (showMessage) {
                    return KingdomsLang.OTHER_KINGDOMS_INTERACT;
                }
            } else if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.INTERACT)) {
                this.event.setUseInteractedBlock(Event.Result.DENY);
                if (showMessage) {
                    return StandardKingdomPermission.INTERACT.getDeniedMessage();
                }
            }
        } else if (!StandardRelationAttribute.USE.hasAttribute(kingdom, land.getKingdom())) {
            this.event.setUseInteractedBlock(Event.Result.DENY);
            if (showMessage) {
                return KingdomsLang.OTHER_KINGDOMS_USE;
            }
        } else if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.USE)) {
            this.event.setUseInteractedBlock(Event.Result.DENY);
            if (showMessage) {
                return StandardKingdomPermission.USE.getDeniedMessage();
            }
        }
        return null;
    }

    private static final Object processIssue$lambda$0(InteractProcessor this$0, Block $block) {
        return this$0.event.getPlayer().getName() + " might be using a hacked client, setting their nexus, or just lagging. They clicked an AIR block (which is not possible): " + this$0.event.getAction() + " - " + $block.getType() + " - " + LocationUtils.toReadableLocation($block.getLocation());
    }
}

