/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.data.managers.LandManager;
import org.kingdoms.events.lands.AsyncBatchLandLoadEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.events.lands.LandUnloadEvent;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.iterator.SharedSubIterable;

public final class ChunkManager
implements Listener {
    private static void handleLandChange(PlayerMoveEvent event, PlayerTeleportEvent cause) {
        SimpleChunkLocation fromChunk = SimpleChunkLocation.of(event.getFrom());
        SimpleChunkLocation toChunk = SimpleChunkLocation.of(event.getTo());
        if (fromChunk.getX() != toChunk.getX() || fromChunk.getZ() != toChunk.getZ()) {
            LandChangeEvent chunkChangeEvent = new LandChangeEvent(event, fromChunk, toChunk, cause);
            Bukkit.getPluginManager().callEvent((Event)chunkChangeEvent);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        LandManager.queryLand(SimpleChunkLocation.of(chunk));
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        SimpleChunkLocation loc = SimpleChunkLocation.of(chunk);
        Land land = (Land)Kingdoms.get().getDataCenter().getLandManager().getDataIfLoaded(loc);
        if (land == null || !land.isClaimed()) {
            return;
        }
        LandUnloadEvent unloadEvent = new LandUnloadEvent(land);
        Bukkit.getPluginManager().callEvent((Event)unloadEvent);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onChunkChange(PlayerMoveEvent event) {
        ChunkManager.handleLandChange(event, null);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onTeleport(PlayerTeleportEvent event) {
        ChunkManager.handleLandChange((PlayerMoveEvent)event, event);
    }

    static {
        Duration delay = Duration.ofSeconds(30L);
        Kingdoms.taskScheduler().async().repeating(delay, delay, () -> {
            LandManager landManager = Kingdoms.get().getDataCenter().getLandManager();
            HashMap<SimpleChunkLocation, List<CompletableFuture<Land>>> queriedLands = new HashMap<SimpleChunkLocation, List<CompletableFuture<Land>>>(LandManager.QUERIED_LANDS);
            LandManager.QUERIED_LANDS.clear();
            SharedSubIterable toBeLoaded = new SharedSubIterable(queriedLands.keySet(), 1000);
            int size = queriedLands.size();
            ArrayList<Land> loaded = new ArrayList<Land>(size);
            while (toBeLoaded.hasRemaining()) {
                landManager.load(toBeLoaded, loaded);
                toBeLoaded.getSharedIterator().resetIndex();
            }
            for (Land land : loaded) {
                List consumers = (List)queriedLands.get(land.getLocation());
                for (CompletableFuture consumer : consumers) {
                    consumer.complete(land);
                }
            }
            if (!loaded.isEmpty()) {
                KLogger.debug((DebugNS)KingdomsDebug.DATA_QUERIED$LANDS, "Queried " + queriedLands.size() + " lands and loaded " + loaded.size() + " of them.");
                AsyncBatchLandLoadEvent loadEvent = new AsyncBatchLandLoadEvent(loaded);
                Bukkit.getPluginManager().callEvent((Event)loadEvent);
            }
        });
        int queried = 0;
        for (World world : Bukkit.getWorlds()) {
            if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(world)) continue;
            for (Chunk chunk : world.getLoadedChunks()) {
                ++queried;
                LandManager.queryLand(SimpleChunkLocation.of(chunk));
            }
        }
        if (queried != 0) {
            KLogger.info("A total of " + queried + " loaded chunks has been queried.");
        }
    }
}

