/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.util.Collection;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.processor.AbstractKingdomsProcessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.BlockLogManager;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.nms.EntityFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 62\u00020\u0001:\u00016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\r\u001a\u00020\u0000J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0014\u0010-\u001a\u0004\u0018\u00010,2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010,2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u0000H\u0016J\b\u00104\u001a\u00020\u0000H\u0016J\n\u00105\u001a\u0004\u0018\u00010,H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00067"}, d2={"Lorg/kingdoms/managers/land/BuildingProcessor;", "Lorg/kingdoms/abstraction/processor/AbstractKingdomsProcessor;", "kp", "Lorg/kingdoms/constants/player/KingdomPlayer;", "location", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "placing", "", "<init>", "(Lorg/kingdoms/constants/player/KingdomPlayer;Lorg/kingdoms/constants/land/location/SimpleLocation;Z)V", "chunk", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "Lorg/kingdoms/libs/checkerframework/checker/nullness/qual/NonNull;", "processAll", "player", "Lorg/bukkit/entity/Player;", "Lorg/kingdoms/libs/checkerframework/checker/nullness/qual/Nullable;", "getPlayer", "()Lorg/bukkit/entity/Player;", "affectedBlock", "Lorg/bukkit/block/Block;", "getAffectedBlock", "()Lorg/bukkit/block/Block;", "setAffectedBlock", "(Lorg/bukkit/block/Block;)V", "affectedEntity", "Lorg/bukkit/entity/Entity;", "getAffectedEntity", "()Lorg/bukkit/entity/Entity;", "setAffectedEntity", "(Lorg/bukkit/entity/Entity;)V", "placingItem", "Lorg/bukkit/inventory/ItemStack;", "getPlacingItem", "()Lorg/bukkit/inventory/ItemStack;", "setPlacingItem", "(Lorg/bukkit/inventory/ItemStack;)V", "cause", "Lorg/bukkit/event/Event;", "getCause", "()Lorg/bukkit/event/Event;", "setCause", "(Lorg/bukkit/event/Event;)V", "buildInClaimedOnly", "Lorg/kingdoms/locale/messenger/Messenger;", "chargeBuilding", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "hasBuildPerms", "land", "Lorg/kingdoms/constants/land/Land;", "reprocess", "process", "processIssue", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBuildingProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildingProcessor.kt\norg/kingdoms/managers/land/BuildingProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
public final class BuildingProcessor
extends AbstractKingdomsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KingdomPlayer kp;
    @NotNull
    private final SimpleLocation location;
    private final boolean placing;
    @NotNull
    private final SimpleChunkLocation chunk;
    private boolean processAll;
    @NotNull
    private final Player player;
    @Nullable
    private Block affectedBlock;
    @Nullable
    private Entity affectedEntity;
    @Nullable
    private ItemStack placingItem;
    @Nullable
    private Event cause;

    public BuildingProcessor(@NotNull KingdomPlayer kp, @NotNull SimpleLocation location, boolean placing) {
        Intrinsics.checkNotNullParameter((Object)kp, (String)"kp");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.kp = kp;
        this.location = location;
        this.placing = placing;
        SimpleChunkLocation simpleChunkLocation = this.location.toSimpleChunkLocation();
        Intrinsics.checkNotNullExpressionValue((Object)simpleChunkLocation, (String)"toSimpleChunkLocation(...)");
        this.chunk = simpleChunkLocation;
        Player player = this.kp.getPlayer();
        if (player == null) {
            throw new IllegalStateException(("Player " + this.kp + " is null").toString());
        }
        this.player = player;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @Nullable
    public final Block getAffectedBlock() {
        return this.affectedBlock;
    }

    public final void setAffectedBlock(@Nullable Block block) {
        this.affectedBlock = block;
    }

    @Nullable
    public final Entity getAffectedEntity() {
        return this.affectedEntity;
    }

    public final void setAffectedEntity(@Nullable Entity entity2) {
        this.affectedEntity = entity2;
    }

    @Nullable
    public final ItemStack getPlacingItem() {
        return this.placingItem;
    }

    public final void setPlacingItem(@Nullable ItemStack itemStack) {
        this.placingItem = itemStack;
    }

    @Nullable
    public final Event getCause() {
        return this.cause;
    }

    public final void setCause(@Nullable Event event) {
        this.cause = event;
    }

    @NotNull
    public final BuildingProcessor processAll() {
        this.processAll = true;
        return this;
    }

    private final Messenger buildInClaimedOnly() {
        boolean isInRange;
        boolean bl;
        KingdomsConfig.Claims whitelistOption;
        List matchers;
        XMaterial material;
        XMaterial xMaterial;
        KingdomsConfig.Claims enabledOption;
        KingdomsConfig.Claims claims = enabledOption = this.placing ? KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_PLACE : KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_BREAK;
        if (!enabledOption.getManager().getBoolean()) {
            return null;
        }
        if (this.placing) {
            if (this.placingItem != null) {
                ItemStack itemStack = this.placingItem;
                Intrinsics.checkNotNull((Object)itemStack);
                xMaterial = XMaterial.matchXMaterial((ItemStack)itemStack);
            } else {
                xMaterial = null;
            }
        } else if (this.affectedBlock != null) {
            Block block = this.affectedBlock;
            Intrinsics.checkNotNull((Object)block);
            xMaterial = XMaterial.matchXMaterial((Material)block.getType());
        } else {
            xMaterial = material = this.affectedEntity != null ? EntityFactory.getMaterialFromEntity(this.affectedEntity) : null;
        }
        if (material != null && XTag.anyMatch((Object)material, (Collection)(matchers = XTag.stringMatcher((Collection)(whitelistOption = this.placing ? KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_WHITELIST_PLACE : KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_WHITELIST_BREAK).getManager().getStringList(), null)))) {
            return null;
        }
        boolean charges = KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_ENABLED.getManager().getBoolean();
        int unclaimedBuildRadius = KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_UNCLAIMED_BUILD_RADIUS.getManager().getInt();
        this.var("radius", unclaimedBuildRadius);
        if (!charges && unclaimedBuildRadius <= 0) {
            return this.placing ? (Messenger)KingdomsLang.IN_CLAIM_ONLY_PLACING_GENERAL : (Messenger)KingdomsLang.IN_CLAIM_ONLY_BREAKING_GENERAL;
        }
        Kingdom kingdom = this.kp.getKingdom();
        if (unclaimedBuildRadius <= 0) {
            bl = false;
        } else {
            if (kingdom == null) {
                return this.placing ? (Messenger)KingdomsLang.IN_CLAIM_ONLY_PLACING_GENERAL : (Messenger)KingdomsLang.IN_CLAIM_ONLY_BREAKING_GENERAL;
            }
            Boolean bl2 = this.chunk.findFromSurroundingChunks(unclaimedBuildRadius, false, arg_0 -> BuildingProcessor.buildInClaimedOnly$lambda$0(kingdom, arg_0));
            Intrinsics.checkNotNull((Object)bl2);
            bl = isInRange = bl2.booleanValue();
        }
        if (!charges) {
            if (!isInRange) {
                return this.placing ? (Messenger)KingdomsLang.IN_CLAIM_ONLY_PLACING_RADIUS : (Messenger)KingdomsLang.IN_CLAIM_ONLY_BREAKING_RADIUS;
            }
            return null;
        }
        boolean inRange = KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_IN_RANGE.getManager().getBoolean();
        if (inRange == isInRange) {
            return this.chargeBuilding(kingdom);
        }
        if (isInRange) {
            return null;
        }
        return this.placing ? (Messenger)KingdomsLang.IN_CLAIM_ONLY_PLACING_RADIUS : (Messenger)KingdomsLang.IN_CLAIM_ONLY_BREAKING_RADIUS;
    }

    private final Messenger chargeBuilding(Kingdom kingdom) {
        KingdomsConfig.Claims rpOpt = this.placing ? KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_PLACING_RESOURCE_POINTS : KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_BREAKING_RESOURCE_POINTS;
        KingdomsConfig.Claims moneyOpt = this.placing ? KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_PLACING_MONEY : KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_BREAKING_MONEY;
        long rp = rpOpt.getManager().getLong();
        double money = moneyOpt.getManager().getDouble();
        String string = Numbers.toFancyNumber(rp);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toFancyNumber(...)");
        this.var("money", string);
        String string2 = Numbers.toFancyNumber(rp);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toFancyNumber(...)");
        this.var("rp", string2);
        if (rp > 0L && kingdom == null) {
            return BuildingProcessor.chargeBuilding$notifier(this);
        }
        if (rp != 0L && kingdom != null && !kingdom.getResourcePoints().has(rp)) {
            return BuildingProcessor.chargeBuilding$notifier(this);
        }
        if (!(money == 0.0) && ServiceHandler.bankServiceAvailable() && !ServiceVault.hasMoney((OfflinePlayer)this.player, money)) {
            return BuildingProcessor.chargeBuilding$notifier(this);
        }
        this.addFinalizer(() -> BuildingProcessor.chargeBuilding$lambda$1(rp, kingdom, money, this));
        return null;
    }

    private final Messenger hasBuildPerms(Land land) {
        StandardKingdomPermission permission;
        StandardKingdomPermission standardKingdomPermission = permission = land.isNexusLand() ? StandardKingdomPermission.NEXUS_BUILD : StandardKingdomPermission.BUILD;
        if (this.kp.hasPermission(permission)) {
            return null;
        }
        if (this.kp.hasPermission(StandardKingdomPermission.BUILD_OWNED)) {
            if (Intrinsics.areEqual((Object)land.getClaimedBy(), (Object)this.kp.getId())) {
                return null;
            }
            return KingdomsLang.LANDS_BUILD_OWN_ONLY;
        }
        return permission.getDeniedMessage();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BuildingProcessor reprocess() {
        void var1_1;
        BuildingProcessor clone = new BuildingProcessor(this.kp, this.location, this.placing);
        boolean bl = false;
        clone.placingItem = this.placingItem;
        clone.affectedBlock = this.affectedBlock;
        clone.affectedEntity = this.affectedEntity;
        if (this.processAll) {
            clone.processAll();
        }
        return var1_1;
    }

    @Override
    @NotNull
    public BuildingProcessor process() {
        super.process();
        return this;
    }

    @Override
    @Nullable
    public Messenger processIssue() {
        Messenger messenger;
        Boolean attr;
        Land land;
        if (this.processAll && !Companion.basicChecks((OfflinePlayer)this.player)) {
            return null;
        }
        if (this.kp.isAdmin()) {
            return null;
        }
        if ((this.placing ? KingdomsDefaultPluginPermission.LAND_BUILD_PLACE : KingdomsDefaultPluginPermission.LAND_BUILD_BREAK).hasPermission((CommandSender)this.player)) {
            return null;
        }
        if (KingdomsConfig.Invasions.ALLOW_BUILDING_ENABLED.getManager().getBoolean() && this.kp.isInvading()) {
            Invasion invasion = this.kp.getInvasion();
            Intrinsics.checkNotNull((Object)invasion);
            if (invasion.isAffected(this.chunk)) {
                if (KingdomsConfig.Invasions.ALLOW_BUILDING_OWN_ONLY.getManager().getBoolean()) {
                    if (BlockLogManager.owns(this.player.getPlayer(), this.location)) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
        }
        if ((land = this.chunk.getLand()) == null || !land.isClaimed()) {
            Messenger messenger2 = this.buildInClaimedOnly();
            if (messenger2 != null) {
                Messenger it = messenger2;
                boolean bl = false;
                return it;
            }
            Nation nationZone = LandProtectionManager.disallowedNationZone(this.kp, this.chunk);
            if (nationZone != null) {
                String string = nationZone.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.var("nation", string);
                return this.placing ? (Messenger)KingdomsLang.LANDS_NATION_ZONE_PLACE : (Messenger)KingdomsLang.LANDS_NATION_ZONE_BREAK;
            }
            return null;
        }
        if (land.isKingdomBlock(this.location.toBlockVector())) {
            return KingdomsLang.BUILDING_ALREADY_PLACED;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && (attr = regulator.hasAttribute(this.player.getUniqueId(), Regulator.Attribute.BUILD)) != null) {
            if (attr.booleanValue()) {
                return null;
            }
            return this.placing ? (Messenger)KingdomsLang.OTHER_KINGDOMS_PLACE : (Messenger)KingdomsLang.OTHER_KINGDOMS_BREAK;
        }
        Kingdom kingdom = this.kp.getKingdom();
        if (kingdom != null && (messenger = this.hasBuildPerms(land)) != null) {
            Messenger it = messenger;
            boolean bl = false;
            return it;
        }
        if (!StandardRelationAttribute.BUILD.hasAttribute(kingdom, land.getKingdom())) {
            return this.placing ? (Messenger)KingdomsLang.OTHER_KINGDOMS_PLACE : (Messenger)KingdomsLang.OTHER_KINGDOMS_BREAK;
        }
        return null;
    }

    private static final Boolean buildInClaimedOnly$lambda$0(Kingdom $kingdom, SimpleChunkLocation currentChunk) {
        SimpleChunkLocation simpleChunkLocation = currentChunk;
        Intrinsics.checkNotNull((Object)simpleChunkLocation);
        return $kingdom.isClaimed(simpleChunkLocation) ? Boolean.valueOf(true) : null;
    }

    private static final Messenger chargeBuilding$notifier(BuildingProcessor this$0) {
        return this$0.placing ? (Messenger)KingdomsLang.IN_CLAIM_ONLY_PLACING_CHARGES : (Messenger)KingdomsLang.IN_CLAIM_ONLY_BREAKING_CHARGES;
    }

    private static final void chargeBuilding$lambda$1(long $rp, Kingdom $kingdom, double $money, BuildingProcessor this$0) {
        if ($rp != 0L) {
            Kingdom kingdom = $kingdom;
            Intrinsics.checkNotNull((Object)kingdom);
            kingdom.getResourcePoints().minusAssign($rp);
        }
        if (!($money == 0.0) && ServiceHandler.bankServiceAvailable()) {
            ServiceVault.withdraw((OfflinePlayer)this$0.player, $money);
        }
    }

    @JvmStatic
    public static final boolean basicChecks(@Nullable OfflinePlayer player) {
        return Companion.basicChecks(player);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/managers/land/BuildingProcessor$Companion;", "", "<init>", "()V", "basicChecks", "", "player", "Lorg/bukkit/OfflinePlayer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean basicChecks(@Nullable OfflinePlayer player) {
            if (LandProtectionManager.DISABLED) {
                return false;
            }
            return !(player instanceof Player) || !KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

