/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.inventory;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.caffeine.cache.RemovalCause;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function3;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.inventory.IndividualInventoryWatcher;
import org.kingdoms.managers.inventory.InventoryWatcherListener;
import org.kingdoms.server.inventory.InventoryView;
import org.kingdoms.utils.cache.caffeine.CacheHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0015H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/managers/inventory/InventoryWatcher;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "LISTENERS", "", "Lorg/kingdoms/managers/inventory/InventoryWatcherListener;", "registerListener", "", "listener", "VIEWERS", "Lorg/kingdoms/libs/caffeine/cache/Cache;", "Ljava/util/UUID;", "Lorg/kingdoms/managers/inventory/IndividualInventoryWatcher;", "inventorySession", "player", "Lorg/bukkit/entity/Player;", "onClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onDrag", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "core"})
public final class InventoryWatcher
implements Listener {
    @NotNull
    public static final InventoryWatcher INSTANCE = new InventoryWatcher();
    @JvmField
    @NotNull
    public static final Set<InventoryWatcherListener> LISTENERS;
    @JvmField
    @NotNull
    public static final Cache<UUID, IndividualInventoryWatcher> VIEWERS;

    private InventoryWatcher() {
    }

    @JvmStatic
    public static final void registerListener(@NotNull InventoryWatcherListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!LISTENERS.add(listener)) {
            throw new IllegalArgumentException("Already registered: " + listener);
        }
    }

    private final IndividualInventoryWatcher inventorySession(Player player) {
        Inventory topInventory = InventoryView.of(player.getOpenInventory()).getTopInventory();
        IndividualInventoryWatcher current = (IndividualInventoryWatcher)VIEWERS.getIfPresent((Object)player.getUniqueId());
        if (current != null && current.getInventory() == topInventory) {
            current.checkSpam();
            return current;
        }
        List listeners = new ArrayList();
        for (InventoryWatcherListener listener : LISTENERS) {
            Intrinsics.checkNotNull((Object)topInventory, (String)"null cannot be cast to non-null type org.bukkit.inventory.Inventory");
            if (!listener.shouldWatchGUI(topInventory)) continue;
            listeners.add(listener);
        }
        if (listeners.isEmpty()) {
            return null;
        }
        Intrinsics.checkNotNull((Object)topInventory, (String)"null cannot be cast to non-null type org.bukkit.inventory.Inventory");
        IndividualInventoryWatcher watcher = new IndividualInventoryWatcher(player, topInventory, listeners);
        VIEWERS.put((Object)player.getUniqueId(), (Object)watcher);
        return watcher;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onClick(@NotNull InventoryClickEvent event) {
        block2: {
            IndividualInventoryWatcher watcher;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            HumanEntity humanEntity = event.getWhoClicked();
            Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
            if (player == null) {
                return;
            }
            Player player2 = player;
            Inventory inventory = event.getClickedInventory();
            if (inventory == null) {
                return;
            }
            Inventory clickedInv = inventory;
            IndividualInventoryWatcher individualInventoryWatcher = watcher = this.inventorySession(player2);
            if (individualInventoryWatcher == null) break block2;
            individualInventoryWatcher.process(event);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onDrag(@NotNull InventoryDragEvent event) {
        block1: {
            IndividualInventoryWatcher watcher;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            HumanEntity humanEntity = event.getWhoClicked();
            Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
            if (player == null) {
                return;
            }
            Player player2 = player;
            IndividualInventoryWatcher individualInventoryWatcher = watcher = this.inventorySession(player2);
            if (individualInventoryWatcher == null) break block1;
            individualInventoryWatcher.process(event);
        }
    }

    private static final Unit VIEWERS$lambda$0(UUID uUID, IndividualInventoryWatcher value, RemovalCause removalCause) {
        Intrinsics.checkNotNullParameter((Object)removalCause, (String)"<unused var>");
        Intrinsics.checkNotNull((Object)value);
        if (value.getEvents().isEmpty()) {
            return Unit.INSTANCE;
        }
        for (InventoryWatcherListener handler : value.getListeners()) {
            handler.onExpire(value);
        }
        return Unit.INSTANCE;
    }

    private static final void VIEWERS$lambda$1(Function3 $tmp0, Object p0, Object p1, RemovalCause p2) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        $tmp0.invoke(p0, p1, (Object)p2);
    }

    static {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        LISTENERS = set;
        Cache cache = CacheHandler.newBuilder().expireAfterAccess(Duration.ofSeconds(5L)).scheduler(CacheHandler.getCacheScheduler()).removalListener((arg_0, arg_1, arg_2) -> InventoryWatcher.VIEWERS$lambda$1(InventoryWatcher::VIEWERS$lambda$0, arg_0, arg_1, arg_2)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        VIEWERS = cache;
    }
}

