/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.inventory;

import org.bukkit.inventory.ItemStack;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.gui.objects.GUIOptionParser;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.CascadingMessageContextProvider;
import org.kingdoms.utils.nms.JsonItemStack;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J%\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/kingdoms/managers/inventory/InventoryItemAction;", "Lorg/kingdoms/locale/provider/CascadingMessageContextProvider;", "<init>", "()V", "time", "", "getTime", "()J", "typeName", "", "getTypeName", "()Ljava/lang/String;", "serialize", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addXYSlot", "prefix", "slot", "", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "addXYSlot$core", "Put", "Take", "Swap", "Move", "core"})
public abstract class InventoryItemAction
implements CascadingMessageContextProvider {
    private final long time = System.currentTimeMillis();

    public final long getTime() {
        return this.time;
    }

    @NotNull
    public abstract String getTypeName();

    public abstract void serialize(@NotNull SectionableDataSetter var1);

    public final void addXYSlot$core(@NotNull String prefix, int slot, @NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int[] nArray = GUIOptionParser.rawSlotToXY(slot);
        Intrinsics.checkNotNull((Object)nArray);
        int x = nArray[0];
        int y = nArray[1];
        context.raw(prefix, slot);
        context.raw(prefix + "_x", x);
        context.raw(prefix + "_y", y);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/managers/inventory/InventoryItemAction$Move;", "Lorg/kingdoms/managers/inventory/InventoryItemAction;", "item", "Lorg/bukkit/inventory/ItemStack;", "fromSlot", "", "toSlot", "<init>", "(Lorg/bukkit/inventory/ItemStack;II)V", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "getFromSlot", "()I", "getToSlot", "typeName", "", "getTypeName", "()Ljava/lang/String;", "serialize", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addMessageContextEdits", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "core"})
    public static final class Move
    extends InventoryItemAction {
        @NotNull
        private final ItemStack item;
        private final int fromSlot;
        private final int toSlot;
        @NotNull
        private final String typeName;

        public Move(@NotNull ItemStack item, int fromSlot, int toSlot) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.item = item;
            this.fromSlot = fromSlot;
            this.toSlot = toSlot;
            this.typeName = "MOVE";
        }

        @NotNull
        public final ItemStack getItem() {
            return this.item;
        }

        public final int getFromSlot() {
            return this.fromSlot;
        }

        public final int getToSlot() {
            return this.toSlot;
        }

        @Override
        @NotNull
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public void serialize(@NotNull SectionableDataSetter provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            provider.setString("item", JsonItemStack.serialize(this.item));
            provider.setInt("fromSlot", this.fromSlot);
            provider.setInt("toSlot", this.toSlot);
        }

        @Override
        public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.raw("item", this.item);
            this.addXYSlot$core("fromSlot", this.fromSlot, context);
            this.addXYSlot$core("toSlot", this.toSlot, context);
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.fromSlot + " -> " + this.toSlot + " :: " + this.item + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/managers/inventory/InventoryItemAction$Put;", "Lorg/kingdoms/managers/inventory/InventoryItemAction;", "initialAmount", "", "item", "Lorg/bukkit/inventory/ItemStack;", "slot", "<init>", "(ILorg/bukkit/inventory/ItemStack;I)V", "getInitialAmount", "()I", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "getSlot", "typeName", "", "getTypeName", "()Ljava/lang/String;", "serialize", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addMessageContextEdits", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "core"})
    public static final class Put
    extends InventoryItemAction {
        private final int initialAmount;
        @NotNull
        private final ItemStack item;
        private final int slot;

        public Put(int initialAmount, @NotNull ItemStack item, int slot) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.initialAmount = initialAmount;
            this.item = item;
            this.slot = slot;
        }

        public final int getInitialAmount() {
            return this.initialAmount;
        }

        @NotNull
        public final ItemStack getItem() {
            return this.item;
        }

        public final int getSlot() {
            return this.slot;
        }

        @Override
        @NotNull
        public String getTypeName() {
            return "PUT";
        }

        @Override
        public void serialize(@NotNull SectionableDataSetter provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            provider.setString("item", JsonItemStack.serialize(this.item));
            provider.setInt("slot", this.slot);
            provider.setInt("initialAmount", this.initialAmount);
        }

        @Override
        public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.raw("item", this.item);
            this.addXYSlot$core("slot", this.slot, context);
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.slot + " :: " + this.item + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/managers/inventory/InventoryItemAction$Swap;", "Lorg/kingdoms/managers/inventory/InventoryItemAction;", "slot", "", "oldItem", "Lorg/bukkit/inventory/ItemStack;", "newItem", "<init>", "(ILorg/bukkit/inventory/ItemStack;Lorg/bukkit/inventory/ItemStack;)V", "getSlot", "()I", "getOldItem", "()Lorg/bukkit/inventory/ItemStack;", "getNewItem", "typeName", "", "getTypeName", "()Ljava/lang/String;", "serialize", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addMessageContextEdits", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "core"})
    public static final class Swap
    extends InventoryItemAction {
        private final int slot;
        @NotNull
        private final ItemStack oldItem;
        @NotNull
        private final ItemStack newItem;
        @NotNull
        private final String typeName;

        public Swap(int slot, @NotNull ItemStack oldItem, @NotNull ItemStack newItem) {
            Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
            Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
            this.slot = slot;
            this.oldItem = oldItem;
            this.newItem = newItem;
            this.typeName = "SWAP";
        }

        public final int getSlot() {
            return this.slot;
        }

        @NotNull
        public final ItemStack getOldItem() {
            return this.oldItem;
        }

        @NotNull
        public final ItemStack getNewItem() {
            return this.newItem;
        }

        @Override
        @NotNull
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public void serialize(@NotNull SectionableDataSetter provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            provider.setString("oldItem", JsonItemStack.serialize(this.oldItem));
            provider.setString("newItem", JsonItemStack.serialize(this.newItem));
            provider.setInt("slot", this.slot);
        }

        @Override
        public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.raw("oldItem", this.oldItem);
            context.raw("newItem", this.newItem);
            this.addXYSlot$core("slot", this.slot, context);
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.slot + " :: " + this.oldItem + " -> " + this.newItem + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/managers/inventory/InventoryItemAction$Take;", "Lorg/kingdoms/managers/inventory/InventoryItemAction;", "initialAmount", "", "item", "Lorg/bukkit/inventory/ItemStack;", "slot", "<init>", "(ILorg/bukkit/inventory/ItemStack;I)V", "getInitialAmount", "()I", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "getSlot", "typeName", "", "getTypeName", "()Ljava/lang/String;", "serialize", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addMessageContextEdits", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "core"})
    public static final class Take
    extends InventoryItemAction {
        private final int initialAmount;
        @NotNull
        private final ItemStack item;
        private final int slot;
        @NotNull
        private final String typeName;

        public Take(int initialAmount, @NotNull ItemStack item, int slot) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.initialAmount = initialAmount;
            this.item = item;
            this.slot = slot;
            this.typeName = "TAKE";
        }

        public final int getInitialAmount() {
            return this.initialAmount;
        }

        @NotNull
        public final ItemStack getItem() {
            return this.item;
        }

        public final int getSlot() {
            return this.slot;
        }

        @Override
        @NotNull
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public void serialize(@NotNull SectionableDataSetter provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            provider.setString("item", JsonItemStack.serialize(this.item));
            provider.setInt("slot", this.slot);
            provider.setInt("initialAmount", this.initialAmount);
        }

        @Override
        public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.raw("item", this.item);
            this.addXYSlot$core("slot", this.slot, context);
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.slot + " :: " + this.item + ')';
        }
    }
}

