/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.managers.inventory.InventoryItemAction;
import org.kingdoms.managers.inventory.InventoryWatcherListener;
import org.kingdoms.server.inventory.BukkitInventoryView;
import org.kingdoms.server.inventory.InventoryView;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.internal.numbers.NumberExtensions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0002J \u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007J\u0016\u0010%\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0019J$\u0010'\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010\u001f2\b\u0010)\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J*\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00172\b\u0010/\u001a\u0004\u0018\u00010\u001f2\u0006\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020\u001d2\u0006\u0010&\u001a\u000203J\u000e\u00102\u001a\u00020\u001d2\u0006\u0010&\u001a\u000204R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00065"}, d2={"Lorg/kingdoms/managers/inventory/IndividualInventoryWatcher;", "", "player", "Lorg/bukkit/entity/Player;", "inventory", "Lorg/bukkit/inventory/Inventory;", "listeners", "", "Lorg/kingdoms/managers/inventory/InventoryWatcherListener;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/inventory/Inventory;Ljava/util/List;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getInventory", "()Lorg/bukkit/inventory/Inventory;", "getListeners", "()Ljava/util/List;", "openSince", "", "getOpenSince", "()J", "events", "", "", "", "Lorg/kingdoms/managers/inventory/InventoryItemAction;", "getEvents", "()Ljava/util/Map;", "checkSpam", "", "getItemFrom", "Lorg/bukkit/inventory/ItemStack;", "action", "stack", "slot", "actions", "evaluateEvents", "addEvent", "event", "handleTwoItems", "topInvItem", "otherItem", "collectToCursor", "cursor", "moveToInventory", "to", "clickedSlot", "clickedItem", "putting", "", "process", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "core"})
@SourceDebugExtension(value={"SMAP\nIndividualInventoryWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndividualInventoryWatcher.kt\norg/kingdoms/managers/inventory/IndividualInventoryWatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 NumberExtensions.kt\norg/kingdoms/utils/internal/numbers/NumberExtensions\n*L\n1#1,361:1\n1#2:362\n1368#3:363\n1454#3,5:364\n381#4,7:369\n9#5:376\n*S KotlinDebug\n*F\n+ 1 IndividualInventoryWatcher.kt\norg/kingdoms/managers/inventory/IndividualInventoryWatcher\n*L\n41#1:363\n41#1:364,5\n131#1:369,7\n262#1:376\n*E\n"})
public final class IndividualInventoryWatcher {
    @NotNull
    private final Player player;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final List<InventoryWatcherListener> listeners;
    private final long openSince;
    @NotNull
    private final Map<Integer, List<InventoryItemAction>> events;

    public IndividualInventoryWatcher(@NotNull Player player, @NotNull Inventory inventory, @NotNull List<? extends InventoryWatcherListener> listeners) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        this.player = player;
        this.inventory = inventory;
        this.listeners = listeners;
        this.openSince = System.currentTimeMillis();
        this.events = new LinkedHashMap();
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final List<InventoryWatcherListener> getListeners() {
        return this.listeners;
    }

    public final long getOpenSince() {
        return this.openSince;
    }

    @NotNull
    public final Map<Integer, List<InventoryItemAction>> getEvents() {
        return this.events;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkSpam() {
        Iterable iterable = this.events.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            List list = (List)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.size();
            n = n2 + n3;
        }
        int totalEvents = n;
        if (totalEvents >= 5000) {
            this.player.kickPlayer("\u00a74Spamming kingdom inventory");
        }
    }

    private final ItemStack getItemFrom(InventoryItemAction action) {
        ItemStack itemStack;
        InventoryItemAction inventoryItemAction = action;
        if (inventoryItemAction instanceof InventoryItemAction.Put) {
            itemStack = ((InventoryItemAction.Put)action).getItem();
        } else if (inventoryItemAction instanceof InventoryItemAction.Take) {
            itemStack = ((InventoryItemAction.Take)action).getItem();
        } else {
            throw new IllegalArgumentException("unknown action " + action);
        }
        return itemStack;
    }

    /*
     * WARNING - void declaration
     */
    private final InventoryItemAction stack(int slot, List<? extends InventoryItemAction> actions) {
        InventoryItemAction firstItemAction;
        InventoryItemAction inventoryItemAction;
        int n;
        void $this$flatMapTo$iv$iv;
        if (actions.size() == 1) {
            return (InventoryItemAction)CollectionsKt.first(actions);
        }
        Iterable $this$flatMap$iv = actions;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            InventoryItemAction it = (InventoryItemAction)element$iv$iv;
            boolean bl = false;
            if (it instanceof InventoryItemAction.Swap) {
                Object[] objectArray = new InventoryItemAction[]{new InventoryItemAction.Take(((InventoryItemAction.Swap)it).getOldItem().getAmount(), ((InventoryItemAction.Swap)it).getOldItem(), ((InventoryItemAction.Swap)it).getSlot()), new InventoryItemAction.Put(((InventoryItemAction.Swap)it).getNewItem().getAmount(), ((InventoryItemAction.Swap)it).getNewItem(), ((InventoryItemAction.Swap)it).getSlot())};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)it);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List actions2 = (List)destination$iv$iv;
        InventoryItemAction action = (InventoryItemAction)CollectionsKt.first((List)actions2);
        if (action instanceof InventoryItemAction.Put) {
            n = ((InventoryItemAction.Put)action).getInitialAmount();
        } else if (action instanceof InventoryItemAction.Take) {
            n = ((InventoryItemAction.Take)action).getInitialAmount();
        } else {
            throw new IllegalArgumentException("unknown action " + action);
        }
        int initialSize = n;
        ItemStack firstItem = this.getItemFrom((InventoryItemAction)CollectionsKt.first((List)actions2));
        ItemStack lastItem = this.getItemFrom((InventoryItemAction)CollectionsKt.last((List)actions2));
        boolean sameItem = firstItem.isSimilar(lastItem);
        int firstAmountEnd = 0;
        int lastAmountEnd = 0;
        for (InventoryItemAction action2 : actions2) {
            boolean bl;
            ItemStack item = this.getItemFrom(action2);
            InventoryItemAction inventoryItemAction2 = action2;
            if (inventoryItemAction2 instanceof InventoryItemAction.Put) {
                bl = false;
            } else if (inventoryItemAction2 instanceof InventoryItemAction.Take) {
                bl = true;
            } else {
                throw new IllegalArgumentException("unknown " + action2);
            }
            boolean subtract = bl;
            if (item.isSimilar(firstItem)) {
                firstAmountEnd = IndividualInventoryWatcher.stack$operation(subtract, firstAmountEnd, item);
                continue;
            }
            if (sameItem || !item.isSimilar(lastItem)) continue;
            lastAmountEnd = IndividualInventoryWatcher.stack$operation(subtract, lastAmountEnd, item);
        }
        if (!sameItem) {
            if (initialSize != 0) {
                KingdomsBukkitExtensions.INSTANCE.setSafeAmount(firstItem, initialSize);
                return new InventoryItemAction.Swap(slot, firstItem, lastItem);
            }
            KingdomsBukkitExtensions.INSTANCE.setSafeAmount(lastItem, lastAmountEnd);
            return new InventoryItemAction.Put(0, lastItem, slot);
        }
        if (!(lastAmountEnd == 0)) {
            boolean bl = false;
            String string = "lastAmountEnd was expected to be not changed: " + lastAmountEnd;
            throw new IllegalArgumentException(string.toString());
        }
        if (firstAmountEnd > 0) {
            KingdomsBukkitExtensions.INSTANCE.setSafeAmount(firstItem, firstAmountEnd);
            inventoryItemAction = new InventoryItemAction.Put(initialSize, firstItem, slot);
        } else if (firstAmountEnd < 0) {
            KingdomsBukkitExtensions.INSTANCE.setSafeAmount(firstItem, Math.abs(firstAmountEnd));
            inventoryItemAction = new InventoryItemAction.Take(initialSize, firstItem, slot);
        } else {
            inventoryItemAction = null;
        }
        InventoryItemAction inventoryItemAction3 = firstItemAction = inventoryItemAction;
        if (inventoryItemAction3 != null) {
            return inventoryItemAction3;
        }
        return null;
    }

    @NotNull
    public final List<InventoryItemAction> evaluateEvents() {
        List map = new ArrayList();
        for (Map.Entry<Integer, List<InventoryItemAction>> entry : this.events.entrySet()) {
            List<InventoryItemAction> actions;
            int slot = ((Number)entry.getKey()).intValue();
            InventoryItemAction stacked = this.stack(slot, actions = entry.getValue());
            if (stacked == null) continue;
            map.add(stacked);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public final void addEvent(int slot, @NotNull InventoryItemAction event) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Map<Integer, List<InventoryItemAction>> map = this.events;
        Integer key$iv = slot;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        List slotActions = (List)object;
        slotActions.add(event);
    }

    private final void handleTwoItems(int slot, ItemStack topInvItem, ItemStack otherItem) {
        if (ItemUtil.notNull(topInvItem) && ItemUtil.notNull(otherItem)) {
            ItemStack itemStack = topInvItem;
            Intrinsics.checkNotNull((Object)itemStack);
            ItemStack itemStack2 = itemStack.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
            ItemStack itemStack3 = otherItem;
            Intrinsics.checkNotNull((Object)itemStack3);
            ItemStack itemStack4 = itemStack3.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"clone(...)");
            this.addEvent(slot, new InventoryItemAction.Swap(slot, itemStack2, itemStack4));
        } else if (ItemUtil.notNull(topInvItem)) {
            ItemStack itemStack = topInvItem;
            Intrinsics.checkNotNull((Object)itemStack);
            ItemStack itemStack5 = itemStack.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"clone(...)");
            ItemStack cloned = itemStack5;
            this.addEvent(slot, new InventoryItemAction.Take(topInvItem.getAmount(), cloned, slot));
        } else if (ItemUtil.notNull(otherItem)) {
            ItemStack itemStack = topInvItem;
            int n = itemStack != null ? itemStack.getAmount() : 0;
            ItemStack itemStack6 = otherItem;
            Intrinsics.checkNotNull((Object)itemStack6);
            ItemStack itemStack7 = itemStack6.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack7, (String)"clone(...)");
            this.addEvent(slot, new InventoryItemAction.Put(n, itemStack7, slot));
        }
    }

    private final void collectToCursor(ItemStack cursor, Inventory inventory) {
        int canTakeAmount = cursor.getMaxStackSize() - cursor.getAmount();
        if (canTakeAmount <= 0) {
            return;
        }
        ItemStack[] itemStackArray = inventory.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
        ItemStack[] itemStackArray2 = itemStackArray;
        int n = itemStackArray2.length;
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack;
            int slot = i;
            ItemStack item = itemStackArray2[i];
            if (item == null || !item.isSimilar(cursor)) continue;
            if (canTakeAmount > item.getAmount()) {
                int n2 = item.getAmount();
                ItemStack itemStack2 = item.clone();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
                this.addEvent(slot, new InventoryItemAction.Take(n2, itemStack2, slot));
                canTakeAmount -= item.getAmount();
                continue;
            }
            int takeAmount = item.getAmount() - canTakeAmount;
            ItemStack $this$collectToCursor_u24lambda_u244 = itemStack = item.clone();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$collectToCursor_u24lambda_u244);
            KingdomsBukkitExtensions.INSTANCE.setSafeAmount($this$collectToCursor_u24lambda_u244, takeAmount);
            ItemStack itemStack3 = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"apply(...)");
            ItemStack cloned = itemStack3;
            this.addEvent(slot, new InventoryItemAction.Take(item.getAmount(), cloned, slot));
            return;
        }
    }

    private final void moveToInventory(Inventory to, int clickedSlot, ItemStack clickedItem, boolean putting) {
        Iterator iterator;
        if (ItemUtil.isNull(clickedItem)) {
            return;
        }
        Intrinsics.checkNotNull((Object)clickedItem);
        List similarSlots = new ArrayList();
        List emptySlots = new ArrayList();
        ItemStack[] itemStackArray = to.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
        ItemStack[] itemStackArray2 = itemStackArray;
        int n = itemStackArray2.length;
        for (int i = 0; i < n; ++i) {
            int itemSlot = i;
            ItemStack item = itemStackArray2[i];
            if (item == null) {
                emptySlots.add(itemSlot);
                continue;
            }
            if (item.getMaxStackSize() <= item.getAmount() || !item.isSimilar(clickedItem)) continue;
            similarSlots.add(TuplesKt.to((Object)itemSlot, (Object)item));
        }
        int remaining = clickedItem.getAmount();
        if (!((Collection)similarSlots).isEmpty()) {
            for (Pair pair : similarSlots) {
                ItemStack cloned;
                int similarSlot = ((Number)pair.component1()).intValue();
                ItemStack similarItem = (ItemStack)pair.component2();
                int mergedAmount = similarItem.getMaxStackSize() < similarItem.getAmount() + remaining ? similarItem.getMaxStackSize() - similarItem.getAmount() : remaining;
                Intrinsics.checkNotNullExpressionValue((Object)clickedItem.clone(), (String)"clone(...)");
                KingdomsBukkitExtensions.INSTANCE.setSafeAmount(cloned, mergedAmount);
                IndividualInventoryWatcher.moveToInventory$handleEvent(putting, this, similarItem.getAmount(), similarSlot, cloned);
                if ((remaining -= mergedAmount) > 0) continue;
            }
        }
        if (!((Collection)emptySlots).isEmpty() && remaining > 0 && (iterator = emptySlots.iterator()).hasNext()) {
            int emptySlot = ((Number)iterator.next()).intValue();
            ItemStack itemStack = clickedItem.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
            ItemStack cloned = itemStack;
            KingdomsBukkitExtensions.INSTANCE.setSafeAmount(cloned, remaining);
            IndividualInventoryWatcher.moveToInventory$handleEvent(putting, this, 0, emptySlot, cloned);
            remaining = 0;
        }
        if (!putting) {
            ItemStack itemStack = clickedItem.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
            ItemStack clone = itemStack;
            KingdomsBukkitExtensions.INSTANCE.setSafeAmount(clone, KingdomsBukkitExtensions.INSTANCE.getSafeAmount(clone) - remaining);
            this.addEvent(clickedSlot, new InventoryItemAction.Take(clickedItem.getAmount(), clone, clickedSlot));
        }
    }

    public final void process(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        Inventory clicked = inventory;
        BukkitInventoryView openInventory = InventoryView.of(event.getWhoClicked().getOpenInventory());
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        Intrinsics.checkNotNullExpressionValue((Object)clickType, (String)"getClick(...)");
        ClickType clickType2 = clickType;
        InventoryAction inventoryAction = event.getAction();
        Intrinsics.checkNotNullExpressionValue((Object)inventoryAction, (String)"getAction(...)");
        InventoryAction action = inventoryAction;
        ItemStack slotItem = event.getCurrentItem();
        ItemStack heldItem = event.getCursor();
        if (action == InventoryAction.NOTHING || action == InventoryAction.UNKNOWN) {
            return;
        }
        if (action == InventoryAction.COLLECT_TO_CURSOR) {
            ItemStack itemStack = heldItem;
            Intrinsics.checkNotNull((Object)itemStack);
            this.collectToCursor(itemStack, openInventory.getTopInventory());
            return;
        }
        if (clicked == openInventory.getTopInventory()) {
            if (ItemUtil.notNull(slotItem)) {
                Integer takeAmount;
                Intrinsics.checkNotNull((Object)slotItem);
                switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                    case 1: {
                        Integer n = slotItem.getAmount();
                        break;
                    }
                    case 2: {
                        ItemStack itemStack = heldItem;
                        Integer n = itemStack != null ? itemStack.getMaxStackSize() : slotItem.getAmount();
                        break;
                    }
                    case 3: {
                        NumberExtensions numberExtensions = NumberExtensions.INSTANCE;
                        int $this$isEven$iv = slotItem.getAmount();
                        boolean $i$f$isEven = false;
                        Integer n = $this$isEven$iv % 2 == 0 ? slotItem.getAmount() / 2 : slotItem.getAmount() / 2 + 1;
                        break;
                    }
                    case 4: {
                        Integer n = 1;
                        break;
                    }
                    case 5: {
                        Integer n = slotItem.getAmount();
                        break;
                    }
                    case 6: {
                        Integer n = 1;
                        break;
                    }
                    case 7: {
                        this.moveToInventory(openInventory.getBottomInventory(), slot, slotItem, false);
                        return;
                    }
                    default: {
                        Integer n = takeAmount = null;
                    }
                }
                if (takeAmount != null) {
                    ItemStack itemStack = slotItem.clone();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
                    ItemStack cloned = itemStack;
                    int initialAmount = cloned.getAmount();
                    KingdomsBukkitExtensions.INSTANCE.setSafeAmount(cloned, takeAmount);
                    this.addEvent(slot, new InventoryItemAction.Take(initialAmount, cloned, slot));
                    return;
                }
            }
            if (ItemUtil.notNull(heldItem)) {
                Integer placeAmount;
                ItemStack itemStack = heldItem;
                Intrinsics.checkNotNull((Object)itemStack);
                ItemStack itemStack2 = itemStack.clone();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
                ItemStack cloned = itemStack2;
                switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                    case 8: {
                        Integer n = heldItem.getAmount();
                        break;
                    }
                    case 9: {
                        ItemStack itemStack3 = slotItem;
                        Intrinsics.checkNotNull((Object)itemStack3);
                        Integer n = itemStack3.getMaxStackSize() - slotItem.getAmount();
                        break;
                    }
                    case 10: {
                        Integer n = 1;
                        break;
                    }
                    default: {
                        Integer n = placeAmount = null;
                    }
                }
                if (placeAmount != null) {
                    int initialAmount = cloned.getAmount();
                    KingdomsBukkitExtensions.INSTANCE.setSafeAmount(cloned, placeAmount);
                    this.addEvent(slot, new InventoryItemAction.Put(initialAmount, cloned, slot));
                    return;
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                case 11: {
                    ItemStack itemStack = slotItem;
                    Intrinsics.checkNotNull((Object)itemStack);
                    ItemStack itemStack4 = itemStack.clone();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"clone(...)");
                    ItemStack itemStack5 = heldItem;
                    Intrinsics.checkNotNull((Object)itemStack5);
                    ItemStack itemStack6 = itemStack5.clone();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"clone(...)");
                    this.addEvent(slot, new InventoryItemAction.Swap(slot, itemStack4, itemStack6));
                    return;
                }
                case 12: 
                case 13: {
                    ItemStack targetItem = event.getHotbarButton() > -1 ? openInventory.getBottomInventory().getItem(event.getHotbarButton()) : this.player.getInventory().getItemInOffHand();
                    this.handleTwoItems(slot, slotItem, targetItem);
                    return;
                }
            }
        } else if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            this.moveToInventory(openInventory.getTopInventory(), slot, slotItem, true);
        }
    }

    public final void process(@NotNull InventoryDragEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Inventory inventory = event.getWhoClicked().getOpenInventory().getTopInventory();
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getTopInventory(...)");
        Inventory top = inventory;
        int topSize = top.getSize() - 1;
        for (Map.Entry entry : event.getNewItems().entrySet()) {
            ItemStack cloned;
            Integer slot = (Integer)entry.getKey();
            ItemStack item = (ItemStack)entry.getValue();
            if (slot > topSize) continue;
            Intrinsics.checkNotNull((Object)slot);
            ItemStack itemStack = top.getItem(slot.intValue());
            int initialSize = itemStack != null ? itemStack.getAmount() : 0;
            Intrinsics.checkNotNullExpressionValue((Object)item.clone(), (String)"clone(...)");
            KingdomsBukkitExtensions.INSTANCE.setSafeAmount(cloned, KingdomsBukkitExtensions.INSTANCE.getSafeAmount(cloned) - initialSize);
            this.addEvent(slot, new InventoryItemAction.Put(initialSize, cloned, slot));
        }
    }

    private static final int stack$operation(boolean subtract, int currentAmount, ItemStack second) {
        return subtract ? currentAmount - second.getAmount() : currentAmount + second.getAmount();
    }

    private static final void moveToInventory$handleEvent(boolean $putting, IndividualInventoryWatcher this$0, int initialAmount, int slot, ItemStack item) {
        if (!$putting) {
            return;
        }
        this$0.addEvent(slot, new InventoryItemAction.Put(initialAmount, item, slot));
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InventoryAction.values().length];
            try {
                nArray[InventoryAction.PICKUP_ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.PICKUP_SOME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.PICKUP_HALF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.PICKUP_ONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.DROP_ALL_SLOT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.DROP_ONE_SLOT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.MOVE_TO_OTHER_INVENTORY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.PLACE_ALL.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.PLACE_SOME.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.PLACE_ONE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.SWAP_WITH_CURSOR.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.HOTBAR_SWAP.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryAction.HOTBAR_MOVE_AND_READD.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

