/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.invasions;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.EnumConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.stats.DefaultStats;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.invasion.KingdomInvadeAttackEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.PowerupManager;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.invasions.InvasionFactory;
import org.kingdoms.managers.invasions.Plunder;
import org.kingdoms.managers.pvp.PvPManager;
import org.kingdoms.server.events.EntityMountEvent;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.cache.caffeine.ExpirationStrategy;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.string.Strings;

public class InvasionManager
implements Listener {
    public static boolean handleCommandList(String cmd, String rest, PluginCommand pluginCommand, boolean smartCommand, EnumConfig commandsOption, EnumConfig whitelistOption) {
        List<String> commands = commandsOption.getManager().getStringList();
        if (commands.isEmpty()) {
            return true;
        }
        boolean whitelist = whitelistOption.getManager().getBoolean();
        boolean contains = false;
        for (String blocked : commands) {
            int index;
            String mainBlockedCmd;
            PluginCommand mainBlockedPluginCmd;
            boolean bl = contains = cmd.startsWith(blocked) || cmd.matches(blocked);
            if (smartCommand && pluginCommand != null && pluginCommand == (mainBlockedPluginCmd = Bukkit.getPluginCommand((String)(mainBlockedCmd = (index = blocked.indexOf(32)) == -1 ? blocked : blocked.substring(0, index))))) {
                String blockedRest = blocked.substring(index + 1);
                if (index == -1 || rest.startsWith(blockedRest) || rest.matches(blockedRest)) {
                    contains = true;
                }
            }
            if (!contains) continue;
            break;
        }
        return whitelist == contains;
    }

    public static void showBossBars(Player player, Kingdom kingdom) {
        if (kingdom == null) {
            return;
        }
        Invasion.forAllRelatedRangedBossBarInvasions(kingdom, inv -> inv.addBossBar(player, kingdom.equals(inv.getAttacker())));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        KingdomPlayer attackerKp;
        Entity victim = event.getEntity();
        Entity damager = event.getDamager();
        Player playerDamager = PvPManager.getDamager(damager);
        if (playerDamager != null) {
            damager = playerDamager;
        }
        if (!victim.hasMetadata("INVASION")) {
            return;
        }
        Invasion invasion = Invasion.getInvasion((LivingEntity)victim);
        if (!(victim instanceof Player) && playerDamager != null && !(attackerKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)playerDamager)).isAdmin()) {
            Kingdom attackerKingdom = attackerKp.getKingdom();
            if (attackerKingdom != null && attackerKingdom.isPacifist()) {
                event.setCancelled(true);
                return;
            }
            if (KingdomsConfig.Invasions.CHAMPIONS_DISABLE_FRIENDLY_DAMAGE.getManager().getBoolean() && invasion.getDefender().hasAttribute(attackerKingdom, (RelationAttribute)StandardRelationAttribute.CEASEFIRE)) {
                event.setCancelled(true);
                return;
            }
        }
        if (!damager.hasMetadata("INVASION")) {
            return;
        }
        KingdomInvadeAttackEvent attackEvent = new KingdomInvadeAttackEvent(invasion, event);
        Bukkit.getPluginManager().callEvent((Event)attackEvent);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Duration sessionDuration = KingdomsConfig.Invasions.ONLINE_MEMBERS_SESSION_DURATION.getManager().getTime(new PlaceholderContextBuilder().withContext(PlaceholderTarget.of(player)));
        if (sessionDuration == null || sessionDuration.isZero()) {
            return;
        }
        InvasionFactory.TOTAL_PLAYTIME.put(player.getUniqueId(), System.currentTimeMillis(), ExpirationStrategy.all(sessionDuration));
    }

    @EventHandler
    public void onUnclaim(UnclaimLandEvent event) {
        event.getLands().forEach(land -> land.endInvasions(Invasion.Result.UNCLAIMED));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onUnclaim(KingdomDisbandEvent event) {
        Kingdom kingdom = event.getKingdom();
        kingdom.getLands().forEach(land -> land.endInvasions(Invasion.Result.UNCLAIMED));
    }

    @EventHandler(ignoreCancelled=true)
    public void onChampion_GET_IN_THE_BOAT(EntityMountEvent event) {
        if (event.getEntity().hasMetadata("INVASION")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onChampionDamages(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        if (!event.getEntity().hasMetadata("INVASION")) {
            return;
        }
        String name = event.getCause().name();
        for (String cause : KingdomsConfig.Invasions.CHAMPIONS_DISABLED_DAMAGES.getManager().getStringList()) {
            if (!cause.equalsIgnoreCase(name)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomLeave(KingdomLeaveEvent event) {
        KingdomPlayer kp = event.getPlayer();
        Invasion invasion = kp.getInvasion();
        if (invasion != null) {
            invasion.end(Invasion.Result.ATTACKER_NO_LONGER_IN_KINGDOM);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        Invasion invasion = kp.getInvasion();
        PowerupManager.onPlayerDeathPowerLoss(player, kp);
        if (kingdom != null) {
            KingdomPlayer kpKiller;
            Kingdom killerKingdom;
            kingdom.getStatistics().inc(DefaultStats.Kingdom.TOTAL_DEATHS);
            LivingEntity killer = PvPManager.getKiller((EntityDeathEvent)event);
            if (killer instanceof Player && (killerKingdom = (kpKiller = KingdomPlayer.getKingdomPlayer(killer.getUniqueId())).getKingdom()) != null) {
                killerKingdom.getStatistics().inc(DefaultStats.Kingdom.TOTAL_KILLS);
            }
        }
        if (invasion != null) {
            String name;
            if (KingdomsConfig.Invasions.PLAYER_DEATHS_KEEP_ENABLED.getManager().getBoolean()) {
                ConditionalExpression condition = KingdomsConfig.Invasions.PLAYER_DEATHS_KEEP_INVENTORY_ATTACKERS.getManager().getCondition();
                if (ConditionProcessor.process(condition, invasion.getMessageContext().withContext(player))) {
                    event.setKeepInventory(true);
                    event.getDrops().clear();
                }
                event.setKeepLevel(KingdomsConfig.Invasions.PLAYER_DEATHS_KEEP_LEVEL.getManager().getBoolean());
            }
            if (!(invasion instanceof Plunder)) {
                invasion.end(Invasion.Result.DIED);
            }
            if (MathUtils.hasChance(5.0) && (name = invasion.getDefender().getName()).contains("elden") && name.contains("ring")) {
                MessageHandler.sendPlayerPluginMessage(player, "&4It seems like you're destined to die as a &lnameless&4, &l&nmaidenless&4, &c&l&m&nRUNT&4.");
            }
        } else {
            MessagePlaceholderProvider context;
            ConditionalExpression condition;
            List<Land> landsUnderAttack;
            List<Land> list = landsUnderAttack = kingdom == null ? null : kingdom.getLandsUnderAttack();
            if (landsUnderAttack != null && !landsUnderAttack.isEmpty() && KingdomsConfig.Invasions.PLAYER_DEATHS_KEEP_ENABLED.getManager().getBoolean() && ConditionProcessor.process(condition = KingdomsConfig.Invasions.PLAYER_DEATHS_KEEP_INVENTORY_DEFENDERS.getManager().getCondition(), context = landsUnderAttack.iterator().next().getMessageContext().withContext(player))) {
                event.setKeepInventory(true);
                event.getDrops().clear();
            }
        }
        if (kingdom != null) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
                Nation nation;
                InvasionManager.handleScores(kingdom);
                if (KingdomsConfig.Invasions.PLUNDER_KEEP_PARTICIPANTS_NATION.getManager().getBoolean() && (nation = kingdom.getNation()) != null) {
                    for (Kingdom member : nation.getKingdoms()) {
                        InvasionManager.handleScores(member);
                    }
                }
                KingdomRelation[] relations = ArrayUtils.when(KingdomsConfig.Invasions.PLUNDER_KEEP_PARTICIPANTS_ALLIES.getManager().getBoolean(), KingdomRelation.ALLY).when(KingdomsConfig.Invasions.PLUNDER_KEEP_PARTICIPANTS_TRUCES.getManager().getBoolean(), KingdomRelation.TRUCE).toArray((KingdomRelation[])new KingdomRelation[0]);
                for (Kingdom helpers : kingdom.getKingdomsWithRelation(relations)) {
                    InvasionManager.handleScores(helpers);
                }
            });
        }
    }

    private static void handleScores(Kingdom kingdom) {
        kingdom.getInvasions().values().forEach(inv -> inv.addDefenderScore(1.0));
        kingdom.getLandsUnderAttack().forEach(underAttack -> underAttack.getInvasions().values().forEach(inv -> inv.addAttackerScore(1.0)));
    }

    @EventHandler
    public void onChampionDeath(EntityDeathEvent event) {
        LivingEntity entity2 = event.getEntity();
        if (entity2 instanceof Player) {
            return;
        }
        Invasion invasion = Invasion.getInvasion(entity2);
        if (invasion == null) {
            return;
        }
        if (invasion instanceof Plunder && KingdomsConfig.Invasions.PLUNDER_CONTINUE_IF_CHAMPION_DIES.getManager().getBoolean()) {
            return;
        }
        EntityDamageEvent deathCause = entity2.getLastDamageCause();
        String damageCause = deathCause == null ? "defaults" : Strings.configOption(deathCause.getCause());
        List<String> messages = KingdomsConfig.Invasions.CHAMPIONS_DEATH_MESSAGES.getManager().withProperty(damageCause).getStringList();
        if (messages.isEmpty()) {
            messages = KingdomsConfig.Invasions.CHAMPIONS_DEATH_MESSAGES.getManager().withProperty("defaults").getStringList();
        }
        int rand = ThreadLocalRandom.current().nextInt(0, messages.size());
        String deathMsg = messages.get(rand);
        MessagePlaceholderProvider msgSettings = new MessagePlaceholderProvider().other(invasion.getDefender());
        LivingEntity killer = PvPManager.getKiller(event);
        if (killer instanceof Player) {
            msgSettings.withContext((Player)killer);
        } else {
            msgSettings.withContext(invasion.getInvaderPlayer());
        }
        MessageProvider msg = MessageCompiler.compile(deathMsg).getSimpleProvider();
        for (Player online : Bukkit.getOnlinePlayers()) {
            msg.send((CommandSender)online, msgSettings);
        }
        msg.send((CommandSender)Bukkit.getConsoleSender(), msgSettings);
        invasion.end(Invasion.Result.SUCCESS);
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Kingdom landKingdom;
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        String command = event.getMessage().substring(1);
        String commandLowercase = command.toLowerCase();
        int mainCmdIndex = command.indexOf(32);
        String mainCmd = mainCmdIndex == -1 ? command : command.substring(0, mainCmdIndex);
        String args = mainCmdIndex == -1 ? "" : command.substring(mainCmdIndex + 1);
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)mainCmd);
        boolean smartCommand = KingdomsConfig.Invasions.COMMANDS_SMART_COMMAND.getManager().getBoolean();
        Kingdom kingdom = kp.getKingdom();
        if (Masswar.getInstance().isRunning() && !InvasionManager.handleCommandList(commandLowercase, args, pluginCommand, true, KingdomsConfig.Invasions.MASSWAR_COMMANDS_LIST, KingdomsConfig.Invasions.MASSWAR_COMMANDS_WHITELIST)) {
            event.setCancelled(true);
            KingdomsLang.MASSWAR_COMMAND_DISALLOWED.sendError((CommandSender)player, "cmd", command);
            return;
        }
        if ((kp.isInvading() || kingdom != null && KingdomsConfig.Invasions.COMMANDS_INVADER_KINGDOM_WIDE.getManager().getBoolean() && kingdom.isInvading()) && !InvasionManager.handleCommandList(commandLowercase, args, pluginCommand, smartCommand, KingdomsConfig.Invasions.COMMANDS_INVADER_LIST, KingdomsConfig.Invasions.COMMANDS_INVADER_WHITELIST)) {
            event.setCancelled(true);
            KingdomsLang.INVASION_BLOCKED_COMMAND.sendMessage((CommandSender)player, "cmd", command);
            return;
        }
        if (kingdom != null && kingdom.isUnderAttack() && !InvasionManager.handleCommandList(commandLowercase, args, pluginCommand, smartCommand, KingdomsConfig.Invasions.COMMANDS_DEFENDER_LIST, KingdomsConfig.Invasions.COMMANDS_DEFENDER_WHITELIST)) {
            event.setCancelled(true);
            KingdomsLang.INVASION_BLOCKED_COMMAND.sendMessage((CommandSender)player, "cmd", command);
            return;
        }
        Land land = Land.getLand(player.getLocation());
        Kingdom kingdom2 = landKingdom = land == null ? null : land.getKingdom();
        if (landKingdom != null) {
            KingdomRelation relation = landKingdom.getRelationWith(kingdom);
            for (String blocked : KingdomsConfig.Relations.RELATIONS_DISABLED_COMMANDS.getManager().withOption("relation", Strings.configOption(relation)).getStringList()) {
                if (!commandLowercase.startsWith(blocked)) continue;
                KingdomsLang.RELATIONS_DISABLED_COMMANDS.sendMessage((CommandSender)player, "cmd", event.getMessage());
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        XMaterial mat;
        boolean contains;
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasMetadata("INVASION")) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).isAdmin()) {
            return;
        }
        boolean whitelist = KingdomsConfig.Invasions.ITEMS_WHITELIST.getManager().getBoolean();
        if (whitelist != (contains = XTag.anyMatch((Object)(mat = XMaterial.matchXMaterial((ItemStack)event.getItem())), (Collection)XTag.stringMatcher(KingdomsConfig.Invasions.ITEMS_LIST.getManager().getStringList(), null)))) {
            event.setCancelled(true);
            KingdomsLang.INVASION_BLOCKED_ITEM.sendMessage((CommandSender)player, "item", mat.toString());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || event.getCause() == PlayerTeleportEvent.TeleportCause.UNKNOWN) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.isInvading() || kp.isAdmin()) {
            return;
        }
        if (!KingdomsConfig.Invasions.ALLOW_TELEPORTATION.getManager().getBoolean()) {
            event.setCancelled(true);
            KingdomsLang.INVASION_BLOCKED_TELEPORTATION.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (event.getFrom().getWorld() != event.getTo().getWorld()) {
            event.setCancelled(true);
            KingdomsLang.INVASION_BLOCKED_WORLD_CHANGE.sendError((CommandSender)player, new Object[0]);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onChampionTeleport(EntityPortalEvent event) {
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Player) {
            return;
        }
        if (entity2.hasMetadata("INVASION")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLogout(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        Invasion invasion = kp.getInvasion();
        if (invasion != null) {
            invasion.end(Invasion.Result.LOGOUT);
        }
        if (kingdom != null) {
            Invasion.forAllRelatedRangedBossBarInvasions(kingdom, inv -> inv.removeBossBar(player));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onGlide(EntityToggleGlideEvent event) {
        if (!event.isGliding()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (KingdomsConfig.Invasions.ALLOW_ELYTRA.getManager().getBoolean()) {
            return;
        }
        Player player = (Player)event.getEntity();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.isInvading()) {
            return;
        }
        event.setCancelled(true);
        KingdomsLang.INVASION_BLOCKED_ELYTRA.sendError((CommandSender)player, new Object[0]);
    }

    public static final class AdvancedInvasionManager
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void championTransformEvent(EntityTransformEvent event) {
            if (event.getEntity().hasMetadata("INVASION")) {
                event.setCancelled(true);
            }
        }
    }
}

