/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.internals;

import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.reflection.ReflectiveNamespace;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftClassHandle;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftMapping;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.internals.EmergencyMode;

public final class ReloadProtection
implements Listener {
    private static final Set<String> KNOWN_RELOAD_COMMANDS = new HashSet<String>(40);
    private static final AtomicBoolean SHUTDOWN_STATE = new AtomicBoolean(false);

    public static void ensureLoadedNaturally() {
        Boolean isReady = null;
        try {
            ReflectiveNamespace ns = XReflection.namespaced();
            MinecraftClassHandle MinecraftServer2 = ns.ofMinecraft("package nms.server; public abstract class MinecraftServer {}");
            Object minecraftServer = MinecraftServer2.method("public static MinecraftServer getServer();").reflect().invoke();
            isReady = ((MethodHandle)MinecraftServer2.field().getter().returns(Boolean.TYPE).makeAccessible().map(MinecraftMapping.MOJANG, "isReady").map(MinecraftMapping.SPIGOT, (String)XReflection.v((int)21, (Object)"ag").v(20, (Object)"ag").v(19, (Object)"ad").v(18, (Object)"ah").v(17, (Object)"ah").v(16, (Object)"M").v(15, (Object)"Q").v(14, (Object)"Q").v(13, (Object)"P").v(12, (Object)"Q").v(11, (Object)"Q").v(10, (Object)"P").v(9, (Object)"P").v(8, (Object)"Q").orElse((Object)"isReady")).unreflect()).invoke(minecraftServer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (isReady != null && isReady.booleanValue()) {
            ReloadProtection.warn(false);
        }
    }

    public static void ensureLoadOnce() {
        URI uri = null;
        try {
            uri = Kingdoms.class.getResource("/config.yml").toURI();
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        try {
            FileSystems.getFileSystem(uri);
            ReloadProtection.warn(true);
            return;
        }
        catch (FileSystemNotFoundException ex) {
            Class CraftServerClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "").named(new String[]{"CraftServer"}).unreflect();
            if (CraftServerClass != null) {
                int reloadCount = 0;
                try {
                    reloadCount = (Integer)CraftServerClass.getDeclaredField("reloadCount").get(Bukkit.getServer());
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
                if (reloadCount > 0) {
                    ReloadProtection.warn(true);
                }
            }
            return;
        }
    }

    private static void warn(boolean reload) {
        EmergencyMode.alert(EmergencyMode.DEFCON.DEFCON_2, "You've " + (reload ? "reloaded" : "loaded") + " the plugin using an external service. In order to enable the plugin again, you need to restart your server. During this period all kingdoms will remain unprotected.");
        throw new IllegalStateException("Cannot enable the plugin" + (reload ? " again" : " in this state"));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onReloadPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (ReloadProtection.handleReloadCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
            event.setCancelled(true);
        }
    }

    static boolean handleReloadCommand(CommandSender sender, String cmd) {
        if (!(cmd = cmd.toLowerCase(Locale.ENGLISH)).startsWith("reload") && !KNOWN_RELOAD_COMMANDS.contains(cmd)) {
            return false;
        }
        MessageCompiler.compile("\n&8-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n\n &4&lDo not reload KingdomsX with&e /reload &4&lor external plugins.&r\n &4&lUse the respective commands instead. E.g. &2&l/k reload&4\n &r&2If you want to reload Kingdoms, you won't even need to reload in most cases since the plugin\n automatically reloads most configs.\n If you want to reload all plugins restart the server.\n\n This action has been blocked by KingdomsX plugin\n because it will break the plugin.\n\n&8-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n", false, false).getExtraProvider().withSound(XSound.BLOCK_NOTE_BLOCK_PLING.record()).send(sender, new MessagePlaceholderProvider());
        return true;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onReloadCommand(ServerCommandEvent event) {
        if (ReloadProtection.handleReloadCommand(event.getSender(), event.getCommand())) {
            event.setCancelled(true);
        }
    }

    static {
        for (String mainCmd : Arrays.asList("plugman", "plugmanx")) {
            for (String subCmd : Arrays.asList("reload", "enable", "unload", "load", "disable")) {
                for (String name : Arrays.asList("kingdom", "kingdoms", "kingdomx", "kingdomsx")) {
                    KNOWN_RELOAD_COMMANDS.add(mainCmd + ' ' + subCmd + ' ' + name);
                }
            }
        }
    }
}

