/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.internals;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.events.general.KingdomGUIOpenEvent;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.events.lands.AsyncBatchLandLoadEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.internal.jdk.Java10;

public final class KingdomsTimings
implements Listener {
    public static final Map<Object, LinkedList<Long>> TIMINGS = new ConcurrentHashMap<Object, LinkedList<Long>>();
    private static boolean ENABLED = false;
    private static boolean registered = false;
    private static long started;

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static double getAverageTimesPerMinute(List<Long> times) {
        if (times.size() <= 1) {
            return 0.0;
        }
        Long last = null;
        ArrayList<Long> differences = new ArrayList<Long>(times.size());
        for (Long time : times) {
            if (last != null) {
                long diff = Math.abs(time - last);
                differences.add(diff);
            }
            last = time;
        }
        long avgEveryMillis = differences.stream().mapToLong(Long::longValue).sum() / (long)differences.size();
        return 60000.0 / (double)avgEveryMillis;
    }

    public static void enable() {
        ENABLED = true;
        started = System.currentTimeMillis();
        if (!registered) {
            Bukkit.getPluginManager().registerEvents((Listener)new KingdomsTimings(), (Plugin)Kingdoms.get());
            registered = true;
        }
    }

    public static long getStarted() {
        return started;
    }

    private static void putTiming(Object key) {
        LinkedList list = TIMINGS.computeIfAbsent(key, k -> new LinkedList());
        if (list.size() > 10000) {
            list.removeFirst();
        }
        list.add(System.currentTimeMillis());
    }

    public static void time() {
        if (!ENABLED) {
            return;
        }
        Method meth = Java10.getCallerMethod(2);
        KingdomsTimings.putTiming(meth);
    }

    public static void time(Object description) {
        if (!ENABLED) {
            return;
        }
        KingdomsTimings.putTiming(description);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void moveToAnotherChunk(AsyncBatchLandLoadEvent event) {
        KingdomsTimings.time("AsyncBatchLandLoadEvent");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void moveToAnotherChunk(LandChangeEvent event) {
        KingdomsTimings.time("Changed Land");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void changeWorlds(PlayerChangedWorldEvent event) {
        KingdomsTimings.time("Changed World");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void playerJoined(PlayerJoinEvent event) {
        KingdomsTimings.time("Player Join");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void playerLeft(PlayerQuitEvent event) {
        KingdomsTimings.time("Player Quit");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void turretActivated(TurretActivateEvent event) {
        KingdomsTimings.time("Turret Activation");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void guiOpened(KingdomGUIOpenEvent event) {
        KingdomsTimings.time("GUI Opened");
    }
}

